/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.UUID;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="authentication_requests")
public class SamlAuthenticationRequest {
    @Id
    private String id;
    private String requestId;
    private String issuer;
    private String consumerAssertionServiceURL;
    private String relayState;
    private String hash;
    private Date expiresIn;
    private String userId;
    private String requesterEntityId;
    private boolean rememberMe;
    private String rememberMeValue;

    public SamlAuthenticationRequest(String requestId, String issuer, String consumerAssertionServiceURL, String relayState, String requesterEntityId) {
        this.id = UUID.randomUUID().toString();
        this.requestId = requestId;
        this.issuer = issuer;
        this.consumerAssertionServiceURL = consumerAssertionServiceURL;
        this.relayState = relayState;
        this.expiresIn = Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneId.systemDefault()).toInstant());
        this.requesterEntityId = requesterEntityId;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public void setRememberMeValue(String rememberMeValue) {
        this.rememberMeValue = rememberMeValue;
    }

    public String getId() {
        return this.id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getConsumerAssertionServiceURL() {
        return this.consumerAssertionServiceURL;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getHash() {
        return this.hash;
    }

    public Date getExpiresIn() {
        return this.expiresIn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRequesterEntityId() {
        return this.requesterEntityId;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public String getRememberMeValue() {
        return this.rememberMeValue;
    }

    public SamlAuthenticationRequest() {
    }
}

