/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import myconext.exceptions.UserNotFoundException;
import myconext.mail.MailBox;
import myconext.manage.ServiceNameResolver;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.User;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SamlMessageStore;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.provider.identity.IdentityProviderService;
import org.springframework.security.saml.provider.identity.IdpAuthenticationRequestFilter;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.saml2.Saml2Object;
import org.springframework.security.saml.saml2.attribute.Attribute;
import org.springframework.security.saml.saml2.attribute.AttributeNameFormat;
import org.springframework.security.saml.saml2.authentication.Assertion;
import org.springframework.security.saml.saml2.authentication.AuthenticationRequest;
import org.springframework.security.saml.saml2.authentication.Response;
import org.springframework.security.saml.saml2.authentication.Scoping;
import org.springframework.security.saml.saml2.metadata.Binding;
import org.springframework.security.saml.saml2.metadata.Endpoint;
import org.springframework.security.saml.saml2.metadata.NameId;
import org.springframework.security.saml.saml2.metadata.ServiceProviderMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class GuestIdpAuthenticationRequestFilter
extends IdpAuthenticationRequestFilter {
    public static final String GUEST_IDP_REMEMBER_ME_COOKIE_NAME = "guest-idp-remember-me";
    public static final String BROWSER_SESSION_COOKIE_NAME = "BROWSERSESSION";
    public static final String REGISTER_MODUS_COOKIE_NAME = "REGISTER_MODUS_COOKIE_NAME";
    private static final Log LOG = LogFactory.getLog(GuestIdpAuthenticationRequestFilter.class);
    private final SamlRequestMatcher ssoSamlRequestMatcher;
    private final SamlRequestMatcher magicSamlRequestMatcher;
    private final String redirectUrl;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final String spEntityId;
    private final int rememberMeMaxAge;
    private final boolean secureCookie;
    private final String magicLinkUrl;
    private final MailBox mailBox;
    private final ServiceNameResolver serviceNameResolver;

    public GuestIdpAuthenticationRequestFilter(SamlProviderProvisioning<IdentityProviderService> provisioning, SamlMessageStore<Assertion, HttpServletRequest> assertionStore, String redirectUrl, ServiceNameResolver serviceNameResolver, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, String spEntityId, int rememberMeMaxAge, boolean secureCookie, String magicLinkUrl, MailBox mailBox) {
        super(provisioning, assertionStore);
        this.ssoSamlRequestMatcher = new SamlRequestMatcher(provisioning, "SSO");
        this.magicSamlRequestMatcher = new SamlRequestMatcher(provisioning, "magic");
        this.redirectUrl = redirectUrl;
        this.serviceNameResolver = serviceNameResolver;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.spEntityId = spEntityId;
        this.rememberMeMaxAge = rememberMeMaxAge;
        this.secureCookie = secureCookie;
        this.magicLinkUrl = magicLinkUrl;
        this.mailBox = mailBox;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.ssoSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting SSO filter");
            this.sso(request, response);
            return;
        }
        if (this.magicSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting magic filter");
            this.magic(request, response);
            return;
        }
        super.doFilterInternal(request, response, filterChain);
    }

    private void sso(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IdentityProviderService provider = (IdentityProviderService)this.getProvisioning().getHostedProvider();
        String samlRequest = request.getParameter("SAMLRequest");
        String relayState = request.getParameter("RelayState");
        AuthenticationRequest authenticationRequest = (AuthenticationRequest)provider.fromXml(samlRequest, true, this.isDeflated(request), AuthenticationRequest.class);
        provider.validate((Saml2Object)authenticationRequest);
        String requesterEntityId = this.requesterId(authenticationRequest);
        SamlAuthenticationRequest samlAuthenticationRequest = new SamlAuthenticationRequest(authenticationRequest.getId(), authenticationRequest.getAssertionConsumerService().getLocation(), relayState, StringUtils.hasText((String)requesterEntityId) ? requesterEntityId : "");
        samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        Optional rememberMeCookieOptional = this.cookieByName(request, GUEST_IDP_REMEMBER_ME_COOKIE_NAME);
        Optional userRememberedOptional = rememberMeCookieOptional.map(arg_0 -> this.userFromCookie(arg_0)).flatMap(Function.identity());
        Optional userFromAuthentication = this.userFromAuthentication();
        User previousAuthenticatedUser = userRememberedOptional.orElse(userFromAuthentication.orElse(null));
        if (previousAuthenticatedUser != null && !authenticationRequest.isForceAuth().booleanValue()) {
            ServiceProviderMetadata serviceProviderMetadata = (ServiceProviderMetadata)provider.getRemoteProvider(this.spEntityId);
            this.sendAssertion(request, response, samlAuthenticationRequest.getRelayState(), previousAuthenticatedUser, provider, serviceProviderMetadata, authenticationRequest);
        } else {
            this.addBrowserIdentificationCookie(response);
            String serviceName = this.serviceNameResolver.resolve(requesterEntityId);
            String modus = this.cookieByName(request, REGISTER_MODUS_COOKIE_NAME).map(c -> "&modus=cr").orElse("");
            response.sendRedirect(this.redirectUrl + "/login/" + samlAuthenticationRequest.getId() + "?name=" + URLEncoder.encode(serviceName, "UTF-8") + modus);
        }
    }

    private Optional<User> userFromCookie(Cookie remembered) {
        LOG.info((Object)"Returning user from rememberMe cookie");
        return this.authenticationRequestRepository.findByRememberMeValue(remembered.getValue()).map(req -> this.userRepository.findById((Object)req.getUserId())).flatMap(Function.identity());
    }

    private Optional<User> userFromAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        LOG.info((Object)("Attempting user authentication from security context: " + authentication));
        return authentication != null && authentication.isAuthenticated() && authentication instanceof UsernamePasswordAuthenticationToken ? Optional.of((User)authentication.getPrincipal()) : Optional.empty();
    }

    private Optional<Cookie> cookieByName(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            return Stream.of(cookies).filter(cookie -> cookie.getName().equals(cookieName)).findAny();
        }
        return Optional.empty();
    }

    private void addBrowserIdentificationCookie(HttpServletResponse response) {
        response.setHeader("Set-Cookie", "BROWSERSESSION=true; SameSite=Lax" + (this.secureCookie ? "; Secure" : ""));
    }

    private boolean isDeflated(HttpServletRequest request) {
        return HttpMethod.GET.name().equalsIgnoreCase(request.getMethod());
    }

    private String requesterId(AuthenticationRequest authenticationRequest) {
        Scoping scoping = authenticationRequest.getScoping();
        List requesterIds = scoping != null ? scoping.getRequesterIds() : null;
        return CollectionUtils.isEmpty((Collection)requesterIds) ? null : (String)requesterIds.get(0);
    }

    private void magic(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Optional optionalCookie = this.cookieByName(request, BROWSER_SESSION_COOKIE_NAME);
        if (!optionalCookie.isPresent()) {
            response.sendRedirect(this.redirectUrl + "/session");
            return;
        }
        String hash = request.getParameter("h");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByHash(hash);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        User user = (User)this.userRepository.findById((Object)samlAuthenticationRequest.getUserId()).orElseThrow(UserNotFoundException::new);
        if (user.isNewUser()) {
            user.setNewUser(false);
            this.userRepository.save((Object)user);
            LOG.info((Object)String.format("Saving user %s after new registration and magic link", user.getUsername()));
            String charSet = Charset.defaultCharset().name();
            this.mailBox.sendAccountConfirmation(user);
            response.sendRedirect(this.redirectUrl + "/confirm?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet) + "&email=" + URLEncoder.encode(user.getEmail(), charSet) + "&name=" + URLEncoder.encode(this.serviceNameResolver.resolve(samlAuthenticationRequest.getRequesterEntityId()), charSet));
            return;
        }
        samlAuthenticationRequest.setHash(null);
        LOG.info((Object)String.format("Disabling magic link after use by %s ", user.getUsername()));
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        IdentityProviderService provider = (IdentityProviderService)this.getProvisioning().getHostedProvider();
        ServiceProviderMetadata serviceProviderMetadata = (ServiceProviderMetadata)provider.getRemoteProvider(this.spEntityId);
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.setId(samlAuthenticationRequest.getRequestId());
        authenticationRequest.setAssertionConsumerService(new Endpoint().setLocation(samlAuthenticationRequest.getConsumerAssertionServiceURL()));
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        if (samlAuthenticationRequest.isRememberMe()) {
            LOG.info((Object)String.format("Remember me functionality activated for %s ", user.getUsername()));
            this.addRememberMeCookie(response, samlAuthenticationRequest);
        }
        this.sendAssertion(request, response, samlAuthenticationRequest.getRelayState(), user, provider, serviceProviderMetadata, authenticationRequest);
    }

    private void addRememberMeCookie(HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest) {
        Cookie cookie = new Cookie(GUEST_IDP_REMEMBER_ME_COOKIE_NAME, samlAuthenticationRequest.getRememberMeValue());
        cookie.setMaxAge(this.rememberMeMaxAge);
        cookie.setSecure(this.secureCookie);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    private void sendAssertion(HttpServletRequest request, HttpServletResponse response, String relayState, User user, IdentityProviderService provider, ServiceProviderMetadata serviceProviderMetadata, AuthenticationRequest authenticationRequest) {
        Assertion assertion = provider.assertion(serviceProviderMetadata, authenticationRequest, user.getUid(), NameId.PERSISTENT);
        this.attributes(user).forEach(arg_0 -> ((Assertion)assertion).addAttribute(arg_0));
        Response samlResponse = provider.response(authenticationRequest, assertion, serviceProviderMetadata);
        Endpoint acsUrl = provider.getPreferredEndpoint(serviceProviderMetadata.getServiceProvider().getAssertionConsumerService(), Binding.POST, -1);
        String encoded = provider.toEncodedXml((Saml2Object)samlResponse, false);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("action", acsUrl.getLocation());
        model.put("SAMLResponse", encoded);
        if (StringUtils.hasText((String)relayState)) {
            model.put("RelayState", HtmlUtils.htmlEscape((String)relayState));
        }
        this.processHtml(request, response, this.getPostBindingTemplate(), model);
    }

    private List<Attribute> attributes(User user) {
        String displayName = String.format("%s %s", user.getGivenName(), user.getFamilyName());
        return Arrays.asList(this.attribute("urn:mace:dir:attribute-def:cn", displayName), this.attribute("urn:mace:dir:attribute-def:displayName", displayName), this.attribute("urn:mace:dir:attribute-def:eduPersonPrincipalName", user.getUid() + "@" + user.getSchacHomeOrganization()), this.attribute("urn:mace:dir:attribute-def:givenName", user.getGivenName()), this.attribute("urn:mace:dir:attribute-def:mail", user.getEmail()), this.attribute("urn:mace:dir:attribute-def:sn", user.getFamilyName()), this.attribute("urn:mace:dir:attribute-def:uid", user.getUid()), this.attribute("urn:mace:terena.org:attribute-def:schacHomeOrganization", user.getSchacHomeOrganization()));
    }

    private Attribute attribute(String name, String value) {
        return new Attribute().setName(name).setNameFormat(AttributeNameFormat.URI).addValues(new Object[]{value});
    }
}

