/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.validation.constraints.NotNull;
import myconext.exceptions.WeakPasswordException;
import myconext.validation.PasswordStrength;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Document(collection="users")
public class User
implements Serializable,
UserDetails {
    @Id
    private String id;
    @NotNull
    private String email;
    private String givenName;
    private String familyName;
    private String uid;
    private String schacHomeOrganization;
    private String authenticatingAuthority;
    private String password;
    private boolean newUser;
    private String preferredLanguage;
    private long created;
    private long updatedAt = System.currentTimeMillis() / 1000L;

    public User(@NotNull String uid, @NotNull String email, String givenName, String familyName, String schacHomeOrganization, String authenticatingAuthority, String preferredLanguage) {
        this.uid = uid;
        this.email = email;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = schacHomeOrganization;
        this.authenticatingAuthority = authenticatingAuthority;
        this.preferredLanguage = preferredLanguage;
        this.newUser = true;
        this.created = System.currentTimeMillis() / 1000L;
    }

    public void validate() {
        Assert.notNull((Object)this.email, (String)"Email is required");
        Assert.notNull((Object)this.givenName, (String)"GivenName is required");
        Assert.notNull((Object)this.familyName, (String)"FamilyName is required");
    }

    public void encryptPassword(String password, PasswordEncoder encoder) {
        if (StringUtils.hasText((String)password)) {
            if (!PasswordStrength.strongEnough((String)password)) {
                throw new WeakPasswordException();
            }
            this.password = encoder.encode((CharSequence)password);
        } else {
            this.password = null;
        }
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singletonList(new SimpleGrantedAuthority("ROLE_GUEST"));
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.email;
    }

    @Transient
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Transient
    public boolean isEnabled() {
        return true;
    }

    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public User() {
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getUid() {
        return this.uid;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public String getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    public boolean isNewUser() {
        return this.newUser;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }
}

