/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.mail.MailBox;
import myconext.manage.ServiceNameResolver;
import myconext.model.MagicLinkRequest;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.UpdateUserSecurityRequest;
import myconext.model.User;
import myconext.model.UserResponse;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserRepository;
import myconext.security.EmailGuessingPrevention;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api"})
public class UserController {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private UserRepository userRepository;
    private AuthenticationRequestRepository authenticationRequestRepository;
    private MailBox mailBox;
    private ServiceNameResolver serviceNameResolver;
    private String magicLinkUrl;
    private String schacHomeOrganization;
    private String guestIdpEntityId;
    private SecureRandom random = new SecureRandom();
    private PasswordEncoder passwordEncoder = new BCryptPasswordEncoder(-1, this.random);
    private EmailGuessingPrevention emailGuessingPreventor;

    public UserController(UserRepository userRepository, AuthenticationRequestRepository authenticationRequestRepository, MailBox mailBox, ServiceNameResolver serviceNameResolver, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${schac_home_organization}") String schacHomeOrganization, @Value(value="${guest_idp_entity_id}") String guestIdpEntityId, @Value(value="${email_guessing_sleep_millis}") int emailGuessingSleepMillis) {
        this.userRepository = userRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.mailBox = mailBox;
        this.serviceNameResolver = serviceNameResolver;
        this.magicLinkUrl = magicLinkUrl;
        this.schacHomeOrganization = schacHomeOrganization;
        this.guestIdpEntityId = guestIdpEntityId;
        this.emailGuessingPreventor = new EmailGuessingPrevention(emailGuessingSleepMillis);
    }

    @PostMapping(value={"/idp/magic_link_request"})
    public ResponseEntity newMagicLinkRequest(@Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User user = magicLinkRequest.getUser();
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.userRepository.findUserByEmail(user.getEmail());
        if (optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body(Collections.singletonMap("status", HttpStatus.CONFLICT.value()));
        }
        String preferredLanguage = LocaleContextHolder.getLocale().getLanguage();
        User userToSave = new User(UUID.randomUUID().toString(), user.getEmail(), user.getGivenName(), user.getFamilyName(), this.schacHomeOrganization, this.guestIdpEntityId, preferredLanguage);
        userToSave.encryptPassword(user.getPassword(), this.passwordEncoder);
        userToSave = (User)this.userRepository.save((Object)userToSave);
        return this.doMagicLink(userToSave, samlAuthenticationRequest, magicLinkRequest, false);
    }

    @PutMapping(value={"/idp/magic_link_request"})
    public ResponseEntity magicLinkRequest(@Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User providedUser = magicLinkRequest.getUser();
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.userRepository.findUserByEmail(providedUser.getEmail());
        if (!optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(Collections.singletonMap("status", HttpStatus.NOT_FOUND.value()));
        }
        User user = (User)optionalUser.get();
        String preferredLanguage = user.getPreferredLanguage();
        String language = LocaleContextHolder.getLocale().getLanguage();
        if (StringUtils.isEmpty((Object)preferredLanguage) || !preferredLanguage.equals(language)) {
            user.setPreferredLanguage(language);
            this.userRepository.save((Object)user);
        }
        if (magicLinkRequest.isUsePassword()) {
            if (!this.passwordEncoder.matches((CharSequence)providedUser.getPassword(), user.getPassword())) {
                return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(Collections.singletonMap("status", HttpStatus.FORBIDDEN.value()));
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
            LOG.info((Object)String.format("User %s successfully logged in with password", user.getUsername()));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        return this.doMagicLink(user, samlAuthenticationRequest, magicLinkRequest, magicLinkRequest.isUsePassword());
    }

    @GetMapping(value={"/sp/me", "sp/migrate/merge", "sp/migrate/proceed"})
    public ResponseEntity me(Authentication authentication) {
        User user;
        List samlAuthenticationRequests = this.authenticationRequestRepository.findByUserIdAndRememberMe((user = this.userRepository.findOneUserByEmail(((User)authentication.getPrincipal()).getEmail())).getId(), true);
        return ResponseEntity.ok((Object)new UserResponse(user, !samlAuthenticationRequests.isEmpty()));
    }

    @DeleteMapping(value={"/sp/forget"})
    public ResponseEntity forgetMe(Authentication authentication) {
        User user = (User)authentication.getPrincipal();
        String userId = user.getId();
        Long count = this.authenticationRequestRepository.deleteByUserId(userId);
        LOG.info((Object)String.format("Do not remember user %s anymore", user.getUsername()));
        return ResponseEntity.ok((Object)count);
    }

    @PutMapping(value={"/sp/update"})
    public ResponseEntity updateUserProfile(Authentication authentication, @RequestBody User deltaUser) {
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        user.setFamilyName(deltaUser.getFamilyName());
        user.setGivenName(deltaUser.getGivenName());
        user.validate();
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("Update user profile for %s", user.getUsername()));
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user, false));
    }

    @PutMapping(value={"/sp/security"})
    public ResponseEntity updateUserSecurity(Authentication authentication, @RequestBody UpdateUserSecurityRequest updateUserRequest) {
        User deltaUser = (User)this.userRepository.findById((Object)updateUserRequest.getUserId()).orElseThrow(UserNotFoundException::new);
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        if (StringUtils.hasText((String)user.getPassword()) && !this.passwordEncoder.matches((CharSequence)updateUserRequest.getCurrentPassword(), user.getPassword())) {
            throw new ForbiddenException();
        }
        user.encryptPassword(updateUserRequest.getNewPassword(), this.passwordEncoder);
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("Updates / set password for user %s", user.getUsername()));
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user, false));
    }

    @GetMapping(value={"/sp/logout"})
    public ResponseEntity logout(HttpServletRequest request) throws URISyntaxException {
        return this.doLogout(request);
    }

    @DeleteMapping(value={"/sp/delete"})
    public ResponseEntity deleteUser(Authentication authentication, HttpServletRequest request) throws URISyntaxException {
        User principal = (User)authentication.getPrincipal();
        this.userRepository.deleteById((Object)principal.getId());
        LOG.info((Object)String.format("Deleted user %s", principal.getEmail()));
        return this.doLogout(request);
    }

    private ResponseEntity doLogout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        return ResponseEntity.ok(Collections.singletonMap("status", "oke"));
    }

    private User verifyAndFetchUser(Authentication authentication, User deltaUser) {
        return this.verifyAndFetchUser(authentication, deltaUser.getId());
    }

    private User verifyAndFetchUser(Authentication authentication, String id) {
        User principal = (User)authentication.getPrincipal();
        if (!principal.getId().equals(id)) {
            throw new ForbiddenException();
        }
        return this.userRepository.findOneUserByEmail(principal.getEmail());
    }

    private ResponseEntity doMagicLink(User user, SamlAuthenticationRequest samlAuthenticationRequest, MagicLinkRequest magicLinkRequest, boolean passwordFlow) {
        samlAuthenticationRequest.setHash(this.hash());
        samlAuthenticationRequest.setUserId(user.getId());
        samlAuthenticationRequest.setRememberMe(magicLinkRequest.isRememberMe());
        if (magicLinkRequest.isRememberMe()) {
            samlAuthenticationRequest.setRememberMeValue(UUID.randomUUID().toString());
        }
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        if (passwordFlow) {
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash()));
        }
        if (user.isNewUser()) {
            LOG.info((Object)String.format("Sending magic link for new user %s", user.getUsername()));
            this.mailBox.sendAccountVerification(user, samlAuthenticationRequest.getHash());
        } else {
            String serviceName = this.serviceNameResolver.resolve(samlAuthenticationRequest.getRequesterEntityId());
            LOG.info((Object)String.format("Sending magic link for existing user %s", user.getUsername()));
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), serviceName);
        }
        return ResponseEntity.status((int)201).body(Collections.singletonMap("result", "ok"));
    }

    private String hash() {
        byte[] bytes = new byte[64];
        this.random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

