/*
 * Decompiled with CFR 0.152.
 */
package myconext.shibboleth;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import myconext.exceptions.MigrationDuplicateUserEmailException;
import myconext.mail.MailBox;
import myconext.model.User;
import myconext.repository.UserRepository;
import myconext.security.CookieResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    public static final String SHIB_GIVEN_NAME = "Shib-givenName";
    public static final String SHIB_SUR_NAME = "Shib-surName";
    public static final String SHIB_EMAIL = "Shib-InetOrgPerson-mail";
    public static final String SHIB_UID = "uid";
    public static final String SHIB_SCHAC_HOME_ORGANIZATION = "schacHomeOrganization";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    private final UserRepository userRepository;
    private final MailBox mailBox;
    private final String oneginiEntityId;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, UserRepository userRepository, String oneginiEntityId, MailBox mailBox) {
        this.setAuthenticationManager(authenticationManager);
        this.userRepository = userRepository;
        this.mailBox = mailBox;
        this.oneginiEntityId = oneginiEntityId;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Optional optionalUserByEmail;
        String authenticatingAuthorities;
        String familyName;
        String givenName;
        String email;
        String schacHomeOrganization;
        String uid = this.getHeader(SHIB_UID, request);
        boolean valid = Stream.of(uid, schacHomeOrganization = this.getHeader(SHIB_SCHAC_HOME_ORGANIZATION, request), email = this.getHeader(SHIB_EMAIL, request), givenName = this.getHeader(SHIB_GIVEN_NAME, request), familyName = this.getHeader(SHIB_SUR_NAME, request), authenticatingAuthorities = this.getHeader(SHIB_AUTHENTICATING_AUTHORITY, request)).allMatch(StringUtils::hasText);
        if (!valid) {
            LOG.warn("Missing required attribute(s): uid {}, schacHomeOrganization {}, givenName {}, familyName {}, email {}, authenticatingAuthorities {}", new Object[]{uid, schacHomeOrganization, givenName, familyName, email, authenticatingAuthorities});
            return null;
        }
        Optional optionalUser = this.userRepository.findUserByUid(uid);
        if (!optionalUser.isPresent() && (optionalUserByEmail = this.userRepository.findUserByEmail(email)).isPresent()) {
            User existingUser = (User)optionalUserByEmail.get();
            String requestURI = request.getRequestURI();
            if (requestURI.endsWith("sp/migrate/merge")) {
                LOG.info("Migrate oneGini account {} to eduID account", (Object)existingUser.getEmail());
                this.userRepository.delete((Object)existingUser);
            } else if (requestURI.endsWith("sp/migrate/proceed")) {
                LOG.info("Not migrating oneGini account {} to eduID account", (Object)existingUser.getEmail());
                optionalUser = optionalUserByEmail;
            } else {
                throw new MigrationDuplicateUserEmailException(email, request.getRequestURI());
            }
        }
        String authenticatingAuthority = authenticatingAuthorities.split(";")[0].trim();
        String preferredLanguage = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        return optionalUser.orElseGet(() -> this.provisionUser(uid, schacHomeOrganization, givenName, familyName, email, authenticatingAuthority, preferredLanguage));
    }

    private User provisionUser(String uid, String schacHomeOrganization, String givenName, String familyName, String email, String authenticatingAuthority, String preferredLanguage) {
        User user = new User(uid, email, givenName, familyName, schacHomeOrganization, authenticatingAuthority, preferredLanguage);
        user.setNewUser(false);
        user = (User)this.userRepository.save((Object)user);
        LOG.info("Provision new User: uid {}, email {}, givenName {}, familyName {}, schacHomeOrganization {}, authenticatingAuthority {}", new Object[]{uid, email, givenName, familyName, schacHomeOrganization, authenticatingAuthority});
        if (this.oneginiEntityId.equalsIgnoreCase(user.getAuthenticatingAuthority())) {
            LOG.info("Sending account migration mail to {}", (Object)user.getEmail());
            this.mailBox.sendAccountMigration(user);
        } else {
            LOG.info("Not sending account migration mail. The authenticatingAuthority of the user '{}' does not equal the configured oneginiEntityId '{}'", (Object)authenticatingAuthority, (Object)this.oneginiEntityId);
        }
        return user;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : "";
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

