/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import myconext.model.SamlAuthenticationRequest;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ResourceCleaner {
    private static final Log LOG = LogFactory.getLog(ResourceCleaner.class);
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final boolean cronJobResponsible;

    @Autowired
    public ResourceCleaner(AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Scheduled(cron="${cron.token-cleaner-expression}")
    public void clean() {
        if (!this.cronJobResponsible) {
            return;
        }
        Date now = new Date();
        this.info(SamlAuthenticationRequest.class, this.authenticationRequestRepository.deleteByExpiresInBeforeAndRememberMe(now, false).longValue());
        List users = this.userRepository.findByLinkedAccounts_ExpiresAtBefore(now);
        users.forEach(user -> {
            List linkedAccounts = user.getLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.getExpiresAt().toInstant().isAfter(now.toInstant())).collect(Collectors.toList());
            user.setLinkedAccounts(linkedAccounts);
            LOG.info((Object)String.format("Removed expired linked account for user %s", user.getEmail()));
            this.userRepository.save(user);
        });
    }

    private void info(Class clazz, long count) {
        LOG.info((Object)String.format("Deleted %s instances of %s in cleanup", count, clazz));
    }
}

