/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.util.List;
import java.util.Map;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.User;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class UserResponse {
    private String id;
    private String email;
    private String givenName;
    private String familyName;
    private boolean usePassword;
    private boolean usePublicKey;
    private Map<String, String> publicKeyCredentials;
    private List<LinkedAccount> linkedAccounts;
    private String schacHomeOrganization;
    private String uid;
    private boolean rememberMe;
    private long created;
    private Map<String, EduID> eduIdPerServiceProvider;

    public UserResponse(User user, Map<String, EduID> eduIdPerServiceProvider, boolean rememberMe) {
        this.id = user.getId();
        this.email = user.getEmail();
        this.givenName = user.getGivenName();
        this.familyName = user.getFamilyName();
        this.schacHomeOrganization = user.getSchacHomeOrganization();
        this.uid = user.getUid();
        this.usePassword = StringUtils.hasText((String)user.getPassword());
        this.publicKeyCredentials = user.getPublicKeyCredentials();
        this.linkedAccounts = user.getLinkedAccounts();
        this.usePublicKey = !CollectionUtils.isEmpty((Map)this.publicKeyCredentials);
        this.rememberMe = rememberMe;
        this.created = user.getCreated();
        this.eduIdPerServiceProvider = eduIdPerServiceProvider;
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public boolean isUsePassword() {
        return this.usePassword;
    }

    public boolean isUsePublicKey() {
        return this.usePublicKey;
    }

    public Map<String, String> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public long getCreated() {
        return this.created;
    }

    public Map<String, EduID> getEduIdPerServiceProvider() {
        return this.eduIdPerServiceProvider;
    }
}

