/*
 * Decompiled with CFR 0.152.
 */
package myconext.webauthn;

import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialType;
import com.yubico.webauthn.data.exception.Base64UrlException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UserCredentialRepository
implements CredentialRepository {
    private UserRepository userRepository;

    @Autowired
    public UserCredentialRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public Set<PublicKeyCredentialDescriptor> getCredentialIdsForUsername(String email) {
        Optional userOptional = this.userRepository.findUserByEmailIgnoreCase(email);
        return userOptional.map(user -> user.getPublicKeyCredentials().keySet().stream().map(id -> PublicKeyCredentialDescriptor.builder().id(this.byteArrayFromBase64Url(id)).type(PublicKeyCredentialType.PUBLIC_KEY).build()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public Optional<ByteArray> getUserHandleForUsername(String email) {
        return this.userRepository.findUserByEmailIgnoreCase(email).map(user -> this.byteArrayFromBase64Url(user.getUserHandle()));
    }

    public Optional<String> getUsernameForUserHandle(ByteArray userHandle) {
        return this.userRepository.findUserByUserHandle(userHandle.getBase64Url()).map(user -> user.getEmail());
    }

    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray userHandle) {
        String credentialKey = credentialId.getBase64Url();
        Optional optionalUser = this.userRepository.findUserByUserHandle(userHandle.getBase64Url());
        if (!optionalUser.isPresent()) {
            return Optional.empty();
        }
        Map publicKeyCredentials = ((User)optionalUser.get()).getPublicKeyCredentials();
        String publicKeyCose = (String)publicKeyCredentials.get(credentialKey);
        if (StringUtils.isEmpty((Object)publicKeyCose)) {
            return Optional.empty();
        }
        RegisteredCredential registeredCredential = RegisteredCredential.builder().credentialId(credentialId).userHandle(userHandle).publicKeyCose(this.byteArrayFromBase64Url(publicKeyCose)).build();
        return Optional.of(registeredCredential);
    }

    public Set<RegisteredCredential> lookupAll(ByteArray credentialId) {
        return Collections.emptySet();
    }

    protected ByteArray byteArrayFromBase64Url(String base64Url) {
        try {
            return ByteArray.fromBase64Url((String)base64Url);
        }
        catch (Base64UrlException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

