/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.github.mongobeej.changeset.ChangeLog;
import com.github.mongobeej.changeset.ChangeSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import myconext.model.PublicKeyCredentials;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.annotation.Transactional;

@ChangeLog
public class Migrations {
    @ChangeSet(order="001", id="transformUserPublicKeyCredentials", author="okke.harsta@surf.nl")
    @Transactional
    public void transformUserPublicKeyCredentials(MongoTemplate mongoTemplate) {
        List usersAsMaps = mongoTemplate.findAll(Map.class, "users");
        usersAsMaps.forEach(userAsMap -> {
            Object publicKeyCredentialsValue;
            if (userAsMap.containsKey("publicKeyCredentials") && (publicKeyCredentialsValue = userAsMap.get("publicKeyCredentials")) instanceof Map) {
                Map credentials = (Map)publicKeyCredentialsValue;
                List publicKeyCredentials = credentials.entrySet().stream().map(entry -> new PublicKeyCredentials((String)entry.getKey(), (String)entry.getValue(), "key-" + UUID.randomUUID().toString())).collect(Collectors.toList());
                userAsMap.put("publicKeyCredentials", publicKeyCredentials);
                mongoTemplate.save(userAsMap, "users");
            }
        });
    }
}

