/*
 * Decompiled with CFR 0.152.
 */
package myconext.log;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import myconext.model.User;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class MDCFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PreAuthenticatedAuthenticationToken token;
        Object principal;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof PreAuthenticatedAuthenticationToken && (principal = (token = (PreAuthenticatedAuthenticationToken)authentication).getPrincipal()) instanceof User) {
            User user = (User)principal;
            MDC.put((String)"user_id", (String)user.getId());
            MDC.put((String)"user_email", (String)user.getEmail());
        }
        chain.doFilter(request, response);
    }
}

