/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.ServiceNameResolver;
import myconext.model.Challenge;
import myconext.model.DeleteServiceTokens;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.MagicLinkRequest;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.UpdateUserSecurityRequest;
import myconext.model.User;
import myconext.model.UserResponse;
import myconext.oidcng.OpenIDConnect;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.ChallengeRepository;
import myconext.repository.UserRepository;
import myconext.security.EmailGuessingPrevention;
import myconext.webauthn.UserCredentialRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/myconext/api"})
public class UserController {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final UserRepository userRepository;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final MailBox mailBox;
    private final ServiceNameResolver serviceNameResolver;
    private final OpenIDConnect openIDConnect;
    private final String magicLinkUrl;
    private final String schacHomeOrganization;
    private final String guestIdpEntityId;
    private final String webAuthnSpRedirectUrl;
    private final String idpBaseUrl;
    private final RelyingParty relyingParty;
    private final UserCredentialRepository userCredentialRepository;
    private final ChallengeRepository challengeRepository;
    private final SecureRandom random = new SecureRandom();
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder(-1, this.random);
    private final EmailGuessingPrevention emailGuessingPreventor;

    public UserController(UserRepository userRepository, UserCredentialRepository userCredentialRepository, ChallengeRepository challengeRepository, AuthenticationRequestRepository authenticationRequestRepository, MailBox mailBox, ServiceNameResolver serviceNameResolver, OpenIDConnect openIDConnect, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${schac_home_organization}") String schacHomeOrganization, @Value(value="${guest_idp_entity_id}") String guestIdpEntityId, @Value(value="${email_guessing_sleep_millis}") int emailGuessingSleepMillis, @Value(value="${sp_redirect_url}") String spBaseUrl, @Value(value="${idp_redirect_url}") String idpBaseUrl, @Value(value="${rp_origin}") String rpOrigin, @Value(value="${rp_id}") String rpId) {
        this.userRepository = userRepository;
        this.userCredentialRepository = userCredentialRepository;
        this.challengeRepository = challengeRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.mailBox = mailBox;
        this.serviceNameResolver = serviceNameResolver;
        this.openIDConnect = openIDConnect;
        this.magicLinkUrl = magicLinkUrl;
        this.schacHomeOrganization = schacHomeOrganization;
        this.guestIdpEntityId = guestIdpEntityId;
        this.idpBaseUrl = idpBaseUrl;
        this.webAuthnSpRedirectUrl = String.format("%s/webauthn", spBaseUrl);
        this.relyingParty = this.relyingParty(rpId, rpOrigin);
        this.emailGuessingPreventor = new EmailGuessingPrevention(emailGuessingSleepMillis);
    }

    @PostMapping(value={"/idp/magic_link_request"})
    public ResponseEntity newMagicLinkRequest(@Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User user = magicLinkRequest.getUser();
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.userRepository.findUserByEmailIgnoreCase(user.getEmail());
        if (optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body(Collections.singletonMap("status", HttpStatus.CONFLICT.value()));
        }
        String preferredLanguage = LocaleContextHolder.getLocale().getLanguage();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        User userToSave = new User(UUID.randomUUID().toString(), user.getEmail(), user.getGivenName(), user.getFamilyName(), this.schacHomeOrganization, this.guestIdpEntityId, requesterEntityId, this.serviceNameResolver.resolve(requesterEntityId), preferredLanguage);
        userToSave = (User)this.userRepository.save((Object)userToSave);
        return this.doMagicLink(userToSave, samlAuthenticationRequest, magicLinkRequest.isRememberMe(), false);
    }

    @PutMapping(value={"/idp/magic_link_request"})
    public ResponseEntity magicLinkRequest(@Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        String serviceProviderName;
        String requesterEntityId;
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User providedUser = magicLinkRequest.getUser();
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.findUserStoreLanguage(providedUser.getEmail());
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        boolean needToSave = user.eduIdForServiceProviderNeedsUpdate(requesterEntityId = samlAuthenticationRequest.getRequesterEntityId(), serviceProviderName = this.serviceNameResolver.resolve(requesterEntityId));
        if (needToSave) {
            user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, serviceProviderName);
            this.userRepository.save((Object)user);
        }
        if (magicLinkRequest.isUsePassword()) {
            if (!this.passwordEncoder.matches((CharSequence)providedUser.getPassword(), user.getPassword())) {
                return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(Collections.singletonMap("status", HttpStatus.FORBIDDEN.value()));
            }
            MDCContext.mdcContext(Optional.of(user), (String[])new String[]{"action", "successful login with password"});
            LOG.info((Object)"Successfully logged in with password");
        }
        return this.doMagicLink(user, samlAuthenticationRequest, magicLinkRequest.isRememberMe(), magicLinkRequest.isUsePassword());
    }

    @GetMapping(value={"/sp/me", "sp/migrate/merge", "sp/migrate/proceed"})
    public ResponseEntity<UserResponse> me(Authentication authentication) {
        User user = this.userRepository.findOneUserByEmailIgnoreCase(((User)authentication.getPrincipal()).getEmail());
        return this.userResponseRememberMe(user);
    }

    @DeleteMapping(value={"/sp/forget"})
    public ResponseEntity<Long> forgetMe(Authentication authentication) {
        User user = (User)authentication.getPrincipal();
        String userId = user.getId();
        Long count = this.authenticationRequestRepository.deleteByUserId(userId);
        MDCContext.mdcContext(Optional.of(user), (String[])new String[]{"action", "forget me"});
        LOG.info((Object)"Do not remember user anymore");
        return ResponseEntity.ok((Object)count);
    }

    @PutMapping(value={"/sp/update"})
    public ResponseEntity updateUserProfile(Authentication authentication, @RequestBody User deltaUser) {
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        user.setFamilyName(deltaUser.getFamilyName());
        user.setGivenName(deltaUser.getGivenName());
        user.validate();
        this.userRepository.save((Object)user);
        MDCContext.mdcContext(Optional.of(user), (String[])new String[]{"action", "update user profile"});
        LOG.info((Object)"Update user profile");
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user, this.convertEduIdPerServiceProvider(user), false));
    }

    @PutMapping(value={"/sp/security"})
    public ResponseEntity updateUserSecurity(Authentication authentication, @RequestBody UpdateUserSecurityRequest updateUserRequest) {
        User deltaUser = (User)this.userRepository.findById((Object)updateUserRequest.getUserId()).orElseThrow(UserNotFoundException::new);
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        if (StringUtils.hasText((String)user.getPassword()) && !this.passwordEncoder.matches((CharSequence)updateUserRequest.getCurrentPassword(), user.getPassword())) {
            throw new ForbiddenException();
        }
        user.encryptPassword(updateUserRequest.getNewPassword(), this.passwordEncoder);
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("Updates / set password for user %s", user.getUsername()));
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user, this.convertEduIdPerServiceProvider(user), false));
    }

    @PutMapping(value={"/sp/institution"})
    public ResponseEntity removeUserLinkedAccounts(Authentication authentication, @RequestBody LinkedAccount linkedAccount) {
        User user = this.userFromAuthentication(authentication);
        List linkedAccounts = user.getLinkedAccounts().stream().filter(la -> !la.getSchacHomeOrganization().equals(linkedAccount.getSchacHomeOrganization())).collect(Collectors.toList());
        user.setLinkedAccounts(linkedAccounts);
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("Deleted linked account %s from user %s", linkedAccount.getSchacHomeOrganization(), user.getUsername()));
        return this.userResponseRememberMe(user);
    }

    @PutMapping(value={"/sp/credential"})
    public ResponseEntity removePublicKeyCredential(Authentication authentication, @RequestBody Map<String, String> credential) {
        User user = this.userFromAuthentication(authentication);
        String identifier = credential.get("identifier");
        List publicKeyCredentials = user.getPublicKeyCredentials().stream().filter(key -> !key.getIdentifier().equals(identifier)).collect(Collectors.toList());
        user.setPublicKeyCredentials(publicKeyCredentials);
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("Deleted publicKeyCredentials %s from user %s", identifier, user.getUsername()));
        return this.userResponseRememberMe(user);
    }

    @PutMapping(value={"/sp/service"})
    public ResponseEntity<UserResponse> removeUserService(Authentication authentication, @RequestBody DeleteServiceTokens serviceAndTokens) {
        User user = this.userFromAuthentication(authentication);
        String eduId = serviceAndTokens.getEduId();
        Map<String, EduID> eduIdPerServiceProvider = user.getEduIdPerServiceProvider().entrySet().stream().filter(entry -> !((EduID)entry.getValue()).getValue().equals(eduId)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        user.setEduIdPerServiceProvider(eduIdPerServiceProvider);
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("Deleted eduID %s from user %s", eduId, user.getUsername()));
        return this.doRemoveTokens(serviceAndTokens, user);
    }

    @PutMapping(value={"/sp/tokens"})
    public ResponseEntity<UserResponse> removeTokens(Authentication authentication, @RequestBody DeleteServiceTokens serviceAndTokens) {
        User user = this.userFromAuthentication(authentication);
        return this.doRemoveTokens(serviceAndTokens, user);
    }

    private ResponseEntity<UserResponse> doRemoveTokens(@RequestBody DeleteServiceTokens serviceAndTokens, User user) {
        LOG.info((Object)String.format("Deleted tokens %s from user %s", serviceAndTokens.getTokens(), user.getUsername()));
        List tokens = serviceAndTokens.getTokens();
        if (!CollectionUtils.isEmpty((Collection)tokens)) {
            this.openIDConnect.deleteTokens(tokens);
        }
        return this.userResponseRememberMe(user);
    }

    @GetMapping(value={"/sp/tokens"})
    public ResponseEntity<List<Map<String, Object>>> tokens(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        return ResponseEntity.ok((Object)this.openIDConnect.tokens(user));
    }

    private User userFromAuthentication(Authentication authentication) {
        String id = ((User)authentication.getPrincipal()).getId();
        return (User)this.userRepository.findById((Object)id).orElseThrow(UserNotFoundException::new);
    }

    private ResponseEntity<UserResponse> userResponseRememberMe(User user) {
        List samlAuthenticationRequests = this.authenticationRequestRepository.findByUserIdAndRememberMe(user.getId(), true);
        return ResponseEntity.ok((Object)new UserResponse(user, this.convertEduIdPerServiceProvider(user), !samlAuthenticationRequests.isEmpty()));
    }

    @GetMapping(value={"sp/security/webauthn"})
    public ResponseEntity spStartWebAuthFlow(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String webAuthnIdentifier = this.hash();
        user.setWebAuthnIdentifier(webAuthnIdentifier);
        this.userRepository.save((Object)user);
        return ResponseEntity.status((int)200).body(Collections.singletonMap("token", webAuthnIdentifier));
    }

    @PostMapping(value={"idp/security/webauthn/registration"})
    public ResponseEntity idpWebAuthnRegistration(@RequestBody Map<String, String> body) throws Base64UrlException {
        String token = body.get("token");
        Optional optionalUser = this.userRepository.findUserByWebAuthnIdentifier(token);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        if (StringUtils.isEmpty((Object)user.getUserHandle())) {
            user.setUserHandle(this.hash());
            this.userRepository.save((Object)user);
        }
        PublicKeyCredentialCreationOptions request = this.publicKeyCredentialCreationOptions(this.relyingParty, user);
        String challenge = request.getChallenge().getBase64Url();
        this.challengeRepository.save((Object)new Challenge(token, challenge));
        return ResponseEntity.status((int)200).body((Object)request);
    }

    @PutMapping(value={"idp/security/webauthn/registration"})
    public ResponseEntity idpWebAuthn(@RequestBody Map<String, Object> body) {
        try {
            return this.doIdpWebAuthn(body);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)201).body(Collections.singletonMap("location", this.webAuthnSpRedirectUrl));
        }
    }

    private ResponseEntity doIdpWebAuthn(Map<String, Object> body) throws IOException, Base64UrlException, RegistrationFailedException, NoSuchFieldException, IllegalAccessException {
        String token = (String)body.get("token");
        String name = (String)body.get("name");
        Optional optionalUser = this.userRepository.findUserByWebAuthnIdentifier(token);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        String credentials = (String)body.get("credentials");
        PublicKeyCredential pkc = PublicKeyCredential.parseRegistrationResponseJson((String)credentials);
        User user = (User)optionalUser.get();
        user.setWebAuthnIdentifier(null);
        PublicKeyCredentialCreationOptions request = this.publicKeyCredentialCreationOptions(this.relyingParty, user);
        Challenge challenge = (Challenge)this.challengeRepository.findByToken(token).orElseThrow(ForbiddenException::new);
        UserController.restoreChallenge((Object)request, (ByteArray)ByteArray.fromBase64Url((String)challenge.getChallenge()));
        this.challengeRepository.delete((Object)challenge);
        RegistrationResult result = this.relyingParty.finishRegistration(FinishRegistrationOptions.builder().request(request).response(pkc).build());
        PublicKeyCredentialDescriptor keyId = result.getKeyId();
        ByteArray publicKeyCose = result.getPublicKeyCose();
        user.addPublicKeyCredential(keyId, publicKeyCose, name);
        this.userRepository.save((Object)user);
        return ResponseEntity.status((int)201).body(Collections.singletonMap("location", this.webAuthnSpRedirectUrl));
    }

    @PostMapping(value={"idp/security/webauthn/authentication"})
    public ResponseEntity idpWebAuthnStartAuthentication(@RequestBody Map<String, String> body) throws Base64UrlException {
        String email = body.get("email");
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.userRepository.findUserByEmailIgnoreCase(email);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        AssertionRequest request = this.relyingParty.startAssertion(StartAssertionOptions.builder().username(Optional.of(user.getEmail())).build());
        String authenticationRequestId = body.get("authenticationRequestId");
        String challenge = request.getPublicKeyCredentialRequestOptions().getChallenge().getBase64Url();
        this.challengeRepository.findByToken(authenticationRequestId).ifPresent(existingChallenge -> this.challengeRepository.delete(existingChallenge));
        this.challengeRepository.save((Object)new Challenge(authenticationRequestId, challenge, user.getEmail()));
        return ResponseEntity.status((int)200).body((Object)request);
    }

    @PutMapping(value={"idp/security/webauthn/authentication"})
    public ResponseEntity idpWebAuthnTryAuthentication(@RequestBody Map<String, Object> body) throws Base64UrlException, IOException, AssertionFailedException, NoSuchFieldException, IllegalAccessException {
        String authenticationRequestId = (String)body.get("authenticationRequestId");
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(authenticationRequestId).orElseThrow(ExpiredAuthenticationException::new);
        boolean rememberMe = (Boolean)body.get("rememberMe");
        PublicKeyCredential pkc = PublicKeyCredential.parseAssertionResponseJson((String)((String)body.get("credentials")));
        Challenge challenge = (Challenge)this.challengeRepository.findByToken(authenticationRequestId).orElseThrow(ForbiddenException::new);
        AssertionRequest assertionRequest = this.relyingParty.startAssertion(StartAssertionOptions.builder().username(Optional.of(challenge.getEmail())).build());
        UserController.restoreChallenge((Object)assertionRequest.getPublicKeyCredentialRequestOptions(), (ByteArray)ByteArray.fromBase64Url((String)challenge.getChallenge()));
        AssertionResult result = this.relyingParty.finishAssertion(FinishAssertionOptions.builder().request(assertionRequest).response(pkc).build());
        if (!result.isSuccess()) {
            throw new ForbiddenException();
        }
        this.challengeRepository.delete((Object)challenge);
        Optional optionalUser = this.findUserStoreLanguage(challenge.getEmail());
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        MDCContext.mdcContext(Optional.of(user), (String[])new String[]{"action", "successful login with authn"});
        LOG.info((Object)"successfully logged in with AuthnWeb");
        return this.doMagicLink(user, samlAuthenticationRequest, rememberMe, true);
    }

    private PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions(RelyingParty relyingParty, User user) throws Base64UrlException {
        return relyingParty.startRegistration(StartRegistrationOptions.builder().user(UserIdentity.builder().name(user.getEmail()).displayName(String.format("%s %s", user.getGivenName(), user.getFamilyName())).id(ByteArray.fromBase64Url((String)user.getUserHandle())).build()).build());
    }

    private RelyingParty relyingParty(String rpId, String rpOrigin) {
        RelyingPartyIdentity rpIdentity = RelyingPartyIdentity.builder().id(rpId).name("eduID").build();
        return RelyingParty.builder().identity(rpIdentity).credentialRepository((CredentialRepository)this.userCredentialRepository).origins(Collections.singleton(rpOrigin)).build();
    }

    protected static void restoreChallenge(Object challengeContainer, ByteArray challenge) throws NoSuchFieldException, IllegalAccessException {
        Field challengeField = challengeContainer.getClass().getDeclaredField("challenge");
        challengeField.setAccessible(true);
        challengeField.set(challengeContainer, challenge);
    }

    @GetMapping(value={"/sp/logout"})
    public ResponseEntity logout(HttpServletRequest request) throws URISyntaxException {
        return this.doLogout(request);
    }

    @DeleteMapping(value={"/sp/delete"})
    public ResponseEntity deleteUser(Authentication authentication, HttpServletRequest request) throws URISyntaxException {
        User principal = (User)authentication.getPrincipal();
        this.userRepository.deleteById((Object)principal.getId());
        LOG.info((Object)String.format("Deleted user %s", principal.getEmail()));
        return this.doLogout(request);
    }

    private ResponseEntity doLogout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        return ResponseEntity.ok(Collections.singletonMap("status", "ok"));
    }

    private User verifyAndFetchUser(Authentication authentication, User deltaUser) {
        return this.verifyAndFetchUser(authentication, deltaUser.getId());
    }

    private User verifyAndFetchUser(Authentication authentication, String id) {
        User principal = (User)authentication.getPrincipal();
        if (!principal.getId().equals(id)) {
            throw new ForbiddenException();
        }
        return this.userRepository.findOneUserByEmailIgnoreCase(principal.getEmail());
    }

    private ResponseEntity doMagicLink(User user, SamlAuthenticationRequest samlAuthenticationRequest, boolean rememberMe, boolean passwordOrWebAuthnFlow) {
        samlAuthenticationRequest.setHash(this.hash());
        samlAuthenticationRequest.setUserId(user.getId());
        samlAuthenticationRequest.setPasswordOrWebAuthnFlow(passwordOrWebAuthnFlow);
        samlAuthenticationRequest.setRememberMe(rememberMe);
        if (rememberMe) {
            samlAuthenticationRequest.setRememberMeValue(UUID.randomUUID().toString());
        }
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        String serviceName = this.serviceNameResolver.resolve(samlAuthenticationRequest.getRequesterEntityId());
        if (passwordOrWebAuthnFlow) {
            LOG.info((Object)String.format("Returning passwordOrWebAuthnFlow magic link for existing user %s", user.getUsername()));
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash()));
        }
        if (user.isNewUser()) {
            LOG.info((Object)String.format("Sending account verification mail with magic link for new user %s", user.getUsername()));
            this.mailBox.sendAccountVerification(user, samlAuthenticationRequest.getHash());
        } else {
            MDCContext.mdcContext(Optional.of(user), (String[])new String[]{"action", "Sending magic link email", "service", serviceName});
            LOG.info((Object)"Sending magic link email for existing user");
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), serviceName);
        }
        return ResponseEntity.status((int)201).body(Collections.singletonMap("result", "ok"));
    }

    private Map<String, EduID> convertEduIdPerServiceProvider(User user) {
        return user.getEduIdPerServiceProvider();
    }

    private Optional<User> findUserStoreLanguage(String email) {
        Optional optionalUser = this.userRepository.findUserByEmailIgnoreCase(email);
        optionalUser.ifPresent(user -> {
            String preferredLanguage = user.getPreferredLanguage();
            String language = LocaleContextHolder.getLocale().getLanguage();
            if (StringUtils.isEmpty((Object)preferredLanguage) || !preferredLanguage.equals(language)) {
                user.setPreferredLanguage(language);
                this.userRepository.save(user);
            }
        });
        return optionalUser;
    }

    private ResponseEntity return404() {
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(Collections.singletonMap("status", HttpStatus.NOT_FOUND.value()));
    }

    private String hash() {
        byte[] bytes = new byte[64];
        this.random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

