/*
 * Decompiled with CFR 0.152.
 */
package myconext.oidcng;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import myconext.oidcng.OpenIDConnect;
import myconext.oidcng.OpenIDConnectMock;
import myconext.oidcng.OpenIDConnectRemote;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;

@Configuration
public class OpenIDConnectConfiguration {
    @Bean
    @Profile(value={"dev"})
    @Primary
    public OpenIDConnect openIDConnectMock(ObjectMapper objectMapper) throws IOException {
        List tokens = (List)objectMapper.readValue(new ClassPathResource("oidcng/tokens.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return new OpenIDConnectMock(tokens);
    }

    @Bean
    @Profile(value={"!dev"})
    public OpenIDConnect openIDConnectRemote(@Value(value="${oidc-token-api.token-url}") URI oidcngUri, @Value(value="${oidc-token-api.user}") String user, @Value(value="${oidc-token-api.password}") String password) {
        return new OpenIDConnectRemote(oidcngUri, user, password);
    }
}

