/*
 * Decompiled with CFR 0.152.
 */
package myconext.aa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import myconext.aa.UserAttribute;
import myconext.exceptions.UserNotFoundException;
import myconext.manage.ServiceNameResolver;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api"})
public class AttributeAggregatorController {
    private static final Log LOG = LogFactory.getLog(AttributeAggregatorController.class);
    private final UserRepository userRepository;
    private final ServiceNameResolver serviceNameResolver;

    public AttributeAggregatorController(UserRepository userRepository, ServiceNameResolver serviceNameResolver) {
        this.userRepository = userRepository;
        this.serviceNameResolver = serviceNameResolver;
    }

    @GetMapping(value={"attribute-aggregation"})
    @PreAuthorize(value="hasRole('ROLE_attribute-aggregation')")
    public ResponseEntity<List<UserAttribute>> aggregate(@RequestParam(value="sp_entity_id") String spEntityId, @RequestParam(value="eduperson_principal_name") String eduPersonPrincipalName) {
        Optional userOptional = this.userRepository.findUserByLinkedAccounts_eduPersonPrincipalName(eduPersonPrincipalName);
        ArrayList userAttributes = new ArrayList();
        userOptional.ifPresent(user -> {
            Optional optionalEduID = user.computeEduIdForServiceProviderIfAbsent(spEntityId, this.serviceNameResolver.resolve(spEntityId, "en"), this.serviceNameResolver.resolve(spEntityId, "nl"));
            optionalEduID.ifPresent(eduID -> userAttributes.add(new UserAttribute("urn:mace:eduid.nl:1.1", eduID)));
        });
        LOG.debug((Object)String.format("Attribute aggregation response %s", userAttributes));
        return ResponseEntity.ok(userAttributes);
    }

    @GetMapping(value={"attribute-manipulation"})
    @PreAuthorize(value="hasRole('ROLE_attribute-manipulation')")
    public ResponseEntity<Map> manipulate(@RequestParam(value="sp_entity_id") String spEntityId, @RequestParam(value="uid") String uid, @RequestParam(value="sp_institution_guid", required=false) String spInstitutionGuid) {
        User user = (User)this.userRepository.findUserByUid(uid).orElseThrow(UserNotFoundException::new);
        String serviceProviderName = this.serviceNameResolver.resolve(spEntityId, "en");
        String serviceProviderNameNl = this.serviceNameResolver.resolve(spEntityId, "nl");
        boolean needToSave = user.eduIdForServiceProviderNeedsUpdate(spEntityId, serviceProviderName, serviceProviderNameNl);
        String eduId = (String)user.computeEduIdForServiceProviderIfAbsent(spEntityId, serviceProviderName, serviceProviderNameNl).get();
        if (needToSave) {
            this.userRepository.save((Object)user);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("eduid", eduId);
        if (StringUtils.hasText((String)spInstitutionGuid)) {
            user.getLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.getInstitutionIdentifier().equals(spInstitutionGuid)).findFirst().ifPresent(linkedAccount -> result.put("eduperson_principal_name", linkedAccount.getEduPersonPrincipalName()));
        }
        LOG.debug((Object)String.format("Attribute manipulation response %s", result));
        return ResponseEntity.ok(result);
    }
}

