/*
 * Decompiled with CFR 0.152.
 */
package myconext.shibboleth;

import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import myconext.exceptions.MigrationDuplicateUserEmailException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.model.User;
import myconext.repository.UserRepository;
import myconext.security.CookieResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Log LOG = LogFactory.getLog(ShibbolethPreAuthenticatedProcessingFilter.class);
    public static final String SHIB_GIVEN_NAME = "Shib-givenName";
    public static final String SHIB_SUR_NAME = "Shib-surName";
    public static final String SHIB_EMAIL = "Shib-InetOrgPerson-mail";
    public static final String SHIB_UID = "uid";
    public static final String SHIB_SCHAC_HOME_ORGANIZATION = "schacHomeOrganization";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    private final UserRepository userRepository;
    private final MailBox mailBox;
    private final String oneginiEntityId;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, UserRepository userRepository, String oneginiEntityId, MailBox mailBox) {
        super.setAuthenticationManager(authenticationManager);
        this.userRepository = userRepository;
        this.mailBox = mailBox;
        this.oneginiEntityId = oneginiEntityId;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        Optional optionalUserByEmail;
        String authenticatingAuthorities;
        String familyName;
        String givenName;
        String email;
        String schacHomeOrganization;
        String uid = this.getHeader(SHIB_UID, request);
        boolean valid = Stream.of(uid, schacHomeOrganization = this.getHeader(SHIB_SCHAC_HOME_ORGANIZATION, request), email = this.getHeader(SHIB_EMAIL, request), givenName = this.getHeader(SHIB_GIVEN_NAME, request), familyName = this.getHeader(SHIB_SUR_NAME, request), authenticatingAuthorities = this.getHeader(SHIB_AUTHENTICATING_AUTHORITY, request)).allMatch(StringUtils::hasText);
        if (!valid) {
            LOG.warn((Object)String.format("Missing required attribute(s): uid %s, schacHomeOrganization %s, givenName %s, familyName %s, email %s, authenticatingAuthorities %s", uid, schacHomeOrganization, givenName, familyName, email, authenticatingAuthorities));
            return null;
        }
        Optional optionalUser = this.userRepository.findUserByUid(uid);
        if (!optionalUser.isPresent() && (optionalUserByEmail = this.userRepository.findUserByEmailIgnoreCase(email.trim())).isPresent()) {
            User existingUser = (User)optionalUserByEmail.get();
            String requestURI = request.getRequestURI();
            if (requestURI.endsWith("sp/migrate/merge")) {
                LOG.info((Object)"Migrate oneGini account to eduID account");
                this.userRepository.delete((Object)existingUser);
            } else if (requestURI.endsWith("sp/migrate/proceed")) {
                LOG.info((Object)"Not migrating oneGini account to eduID account");
                optionalUser = optionalUserByEmail;
            } else {
                throw new MigrationDuplicateUserEmailException(email, request.getRequestURI());
            }
        }
        String authenticatingAuthority = authenticatingAuthorities.split(";")[0].trim();
        String preferredLanguage = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        return optionalUser.orElseGet(() -> this.provisionUser(uid, schacHomeOrganization, givenName, familyName, email, authenticatingAuthority, preferredLanguage));
    }

    private User provisionUser(String uid, String schacHomeOrganization, String givenName, String familyName, String email, String authenticatingAuthority, String preferredLanguage) {
        User user = new User(uid, email, givenName, familyName, schacHomeOrganization, authenticatingAuthority, null, null, null, preferredLanguage);
        user.setNewUser(false);
        user = (User)this.userRepository.save((Object)user);
        boolean isOneGini = this.oneginiEntityId.equalsIgnoreCase(user.getAuthenticatingAuthority());
        MDCContext.logWithContext((User)user, (String)"add", (String)"user", (Log)LOG, (String)String.format("Provisioned new user %s from %s", user.getEmail(), authenticatingAuthority));
        if (isOneGini) {
            LOG.info((Object)String.format("Sending account migration mail to %s who migrated from OneGini", user.getEmail()));
            this.mailBox.sendAccountMigration(user);
        }
        return user;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : "";
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

