/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import myconext.exceptions.WeakPasswordException;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.validation.PasswordStrength;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Document(collection="users")
public class User
implements Serializable,
UserDetails {
    @Id
    private String id;
    private String email;
    private String givenName;
    private String familyName;
    private String uid;
    private String schacHomeOrganization;
    private String password;
    private boolean newUser;
    private String preferredLanguage;
    private String webAuthnIdentifier;
    private String userHandle;
    private boolean forgottenPassword;
    private List<LinkedAccount> linkedAccounts = new ArrayList();
    private Map<String, EduID> eduIdPerServiceProvider = new HashMap();
    private List<PublicKeyCredentials> publicKeyCredentials = new ArrayList();
    private Map<String, List<String>> attributes = new HashMap();
    private long created;
    private long updatedAt = System.currentTimeMillis() / 1000L;

    public User(String uid, String email, String givenName, String familyName, String schacHomeOrganization, String serviceProviderEntityId, String serviceProviderName, String serviceProviderNameNl, String preferredLanguage) {
        this.uid = uid;
        this.email = email;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = schacHomeOrganization;
        this.preferredLanguage = preferredLanguage;
        this.computeEduIdForServiceProviderIfAbsent(serviceProviderEntityId, serviceProviderName, serviceProviderNameNl);
        this.newUser = true;
        this.created = System.currentTimeMillis() / 1000L;
    }

    public void validate() {
        Assert.notNull((Object)this.email, (String)"Email is required");
        Assert.notNull((Object)this.givenName, (String)"GivenName is required");
        Assert.notNull((Object)this.familyName, (String)"FamilyName is required");
    }

    public void encryptPassword(String password, PasswordEncoder encoder) {
        if (!PasswordStrength.strongEnough((String)password)) {
            throw new WeakPasswordException();
        }
        this.password = encoder.encode((CharSequence)password);
    }

    @Transient
    public void addPublicKeyCredential(PublicKeyCredentialDescriptor publicKeyCredentialDescriptor, ByteArray publicKeyCredential, String name) {
        this.publicKeyCredentials.add(new PublicKeyCredentials(publicKeyCredentialDescriptor, publicKeyCredential, name));
    }

    @Transient
    public Optional<String> computeEduIdForServiceProviderIfAbsent(String serviceProviderEntityId, String serviceProviderName, String serviceProviderNameNl) {
        Optional<String> result = StringUtils.hasText((String)serviceProviderEntityId) ? Optional.of(this.eduIdPerServiceProvider.computeIfAbsent(serviceProviderEntityId, s -> new EduID(UUID.randomUUID().toString(), serviceProviderName, serviceProviderNameNl, new Date())).getValue()) : Optional.empty();
        this.syncServiceName(serviceProviderEntityId, serviceProviderName, serviceProviderNameNl);
        return result;
    }

    private boolean syncServiceName(String serviceProviderEntityId, String serviceProviderName, String serviceProviderNameNl) {
        boolean needsSyncing;
        EduID eduID = (EduID)this.eduIdPerServiceProvider.get(serviceProviderEntityId);
        boolean bl = needsSyncing = StringUtils.hasText((String)serviceProviderName) && !serviceProviderName.equals(eduID.getServiceName()) || StringUtils.hasText((String)serviceProviderNameNl) && !serviceProviderNameNl.equals(eduID.getServiceNameNl());
        if (needsSyncing) {
            eduID.updateServiceName(serviceProviderName, serviceProviderNameNl);
        }
        return needsSyncing;
    }

    @Transient
    public boolean eduIdForServiceProviderNeedsUpdate(String serviceProviderEntityId, String serviceProviderName, String serviceProviderNameNl) {
        if (!this.eduIdPerServiceProvider.containsKey(serviceProviderEntityId)) {
            return true;
        }
        return this.syncServiceName(serviceProviderEntityId, serviceProviderName, serviceProviderNameNl);
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singletonList(new SimpleGrantedAuthority("ROLE_GUEST"));
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public String getUsername() {
        return this.email;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @Transient
    @JsonIgnore
    public List<LinkedAccount> linkedAccountsSorted() {
        return this.linkedAccounts.stream().sorted(Comparator.comparing(LinkedAccount::getExpiresAt).reversed()).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> allEduPersonAffiliations() {
        return this.linkedAccounts.stream().map(LinkedAccount::getEduPersonAffiliations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getEduPersonPrincipalName() {
        return this.uid + "@" + this.schacHomeOrganization;
    }

    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public void setWebAuthnIdentifier(String webAuthnIdentifier) {
        this.webAuthnIdentifier = webAuthnIdentifier;
    }

    public void setUserHandle(String userHandle) {
        this.userHandle = userHandle;
    }

    public void setLinkedAccounts(List<LinkedAccount> linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public void setEduIdPerServiceProvider(Map<String, EduID> eduIdPerServiceProvider) {
        this.eduIdPerServiceProvider = eduIdPerServiceProvider;
    }

    public void setPublicKeyCredentials(List<PublicKeyCredentials> publicKeyCredentials) {
        this.publicKeyCredentials = publicKeyCredentials;
    }

    public void setForgottenPassword(boolean forgottenPassword) {
        this.forgottenPassword = forgottenPassword;
    }

    public User() {
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getUid() {
        return this.uid;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public boolean isNewUser() {
        return this.newUser;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getWebAuthnIdentifier() {
        return this.webAuthnIdentifier;
    }

    public String getUserHandle() {
        return this.userHandle;
    }

    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public Map<String, EduID> getEduIdPerServiceProvider() {
        return this.eduIdPerServiceProvider;
    }

    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }
}

