/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.util.Date;
import java.util.Optional;
import myconext.model.ServiceProvider;
import org.springframework.util.StringUtils;

public class EduID {
    private String value;
    private String serviceName;
    private String serviceNameNl;
    private String serviceLogoUrl;
    private String serviceHomeUrl;
    private Date createdAt;

    public EduID(String value, String entityId, Optional<ServiceProvider> serviceProviderOptional) {
        this.value = value;
        this.createdAt = new Date();
        if (serviceProviderOptional.isPresent()) {
            ServiceProvider serviceProvider = serviceProviderOptional.get();
            this.serviceName = serviceProvider.getName();
            this.serviceNameNl = StringUtils.hasText((String)serviceProvider.getNameNl()) ? serviceProvider.getNameNl() : this.serviceName;
            this.serviceHomeUrl = serviceProvider.getHomeUrl();
            this.serviceLogoUrl = serviceProvider.getLogoUrl();
        } else {
            this.serviceName = entityId;
            this.serviceNameNl = entityId;
        }
    }

    public void updateServiceProvider(ServiceProvider serviceProvider) {
        this.serviceName = serviceProvider.getName();
        this.serviceNameNl = StringUtils.hasText((String)serviceProvider.getNameNl()) ? serviceProvider.getNameNl() : this.serviceName;
        this.serviceHomeUrl = serviceProvider.getHomeUrl();
        this.serviceLogoUrl = serviceProvider.getLogoUrl();
    }

    public EduID() {
    }

    public String getValue() {
        return this.value;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNameNl() {
        return this.serviceNameNl;
    }

    public String getServiceLogoUrl() {
        return this.serviceLogoUrl;
    }

    public String getServiceHomeUrl() {
        return this.serviceHomeUrl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }
}

