/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.SpringDataMongo3Driver;
import com.github.cloudyrock.spring.v5.MongockSpring5;
import io.changock.driver.api.driver.ConnectionDriver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
public class MongoMapping {
    private final MongoTemplate mongoTemplate;
    private final MongoConverter mongoConverter;

    @Autowired
    public MongoMapping(MongoTemplate mongoTemplate, MongoConverter mongoConverter) {
        this.mongoTemplate = mongoTemplate;
        this.mongoConverter = mongoConverter;
    }

    @Bean
    public MongoTransactionManager transactionManager() {
        return new MongoTransactionManager(this.mongoTemplate.getMongoDbFactory());
    }

    @Bean
    public MongockSpring5.MongockApplicationRunner mongockApplicationRunner(ApplicationContext springContext, MongoTemplate mongoTemplate) {
        SpringDataMongo3Driver driver = SpringDataMongo3Driver.withDefaultLock((MongoTemplate)mongoTemplate);
        driver.disableTransaction();
        return ((MongockSpring5.Builder)((MongockSpring5.Builder)MongockSpring5.builder().setDriver((ConnectionDriver)driver).addChangeLogsScanPackage("myconext.mongo")).setSpringContext(springContext)).buildApplicationRunner();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initIndicesAfterStartup() {
        ((MappingMongoConverter)this.mongoConverter).setMapKeyDotReplacement("@");
        MongoMappingContext mappingContext = (MongoMappingContext)this.mongoConverter.getMappingContext();
        for (BasicMongoPersistentEntity persistentEntity : mappingContext.getPersistentEntities()) {
            Class clazz = persistentEntity.getType();
            if (!clazz.isAnnotationPresent(Document.class)) continue;
            MongoPersistentEntityIndexResolver resolver = new MongoPersistentEntityIndexResolver((MappingContext)mappingContext);
            IndexOperations indexOps = this.mongoTemplate.indexOps(clazz);
            resolver.resolveIndexFor(clazz).forEach(arg_0 -> ((IndexOperations)indexOps).ensureIndex(arg_0));
        }
    }
}

