/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.util.StringUtils;

public class LinkedAccount {
    private String institutionIdentifier;
    private String schacHomeOrganization;
    private String eduPersonPrincipalName;
    private String givenName;
    private String familyName;
    private List<String> eduPersonAffiliations = new ArrayList();
    private Date createdAt;
    private Date expiresAt;

    @Transient
    @JsonIgnore
    public boolean updateExpiresIn(String institutionIdentifier, String eppn, String givenName, String familyName, List<String> eduPersonAffiliations, Date expiresAt) {
        this.institutionIdentifier = institutionIdentifier;
        this.eduPersonPrincipalName = eppn;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.expiresAt = expiresAt;
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean areNamesValidated() {
        return StringUtils.hasText((String)this.givenName) && StringUtils.hasText((String)this.familyName);
    }

    public void setEduPersonAffiliations(List<String> eduPersonAffiliations) {
        this.eduPersonAffiliations = eduPersonAffiliations;
    }

    public LinkedAccount() {
    }

    public LinkedAccount(String institutionIdentifier, String schacHomeOrganization, String eduPersonPrincipalName, String givenName, String familyName, List<String> eduPersonAffiliations, Date createdAt, Date expiresAt) {
        this.institutionIdentifier = institutionIdentifier;
        this.schacHomeOrganization = schacHomeOrganization;
        this.eduPersonPrincipalName = eduPersonPrincipalName;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
    }

    public String getInstitutionIdentifier() {
        return this.institutionIdentifier;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public List<String> getEduPersonAffiliations() {
        return this.eduPersonAffiliations;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }
}

