/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import myconext.exceptions.MigrationDuplicateUserEmailException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
public class DefaultErrorController
implements ErrorController {
    private static final Log LOG = LogFactory.getLog(DefaultErrorController.class);
    private final ErrorAttributes errorAttributes;
    private final String redirectUrl;

    @Autowired
    public DefaultErrorController(ErrorAttributes errorAttributes, @Value(value="${sp_redirect_url}") String redirectUrl) {
        this.errorAttributes = errorAttributes;
        this.redirectUrl = redirectUrl;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity error(HttpServletRequest request) throws URISyntaxException {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.defaults());
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        if (error == null) {
            statusCode = result.containsKey("status") && (Integer)result.get("status") != 999 ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR;
        } else {
            LOG.error((Object)"Error occurred", error);
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            HttpStatus httpStatus = statusCode = annotation != null ? annotation.value() : HttpStatus.BAD_REQUEST;
            if (error instanceof MigrationDuplicateUserEmailException) {
                MigrationDuplicateUserEmailException duplicateUserEmailException = (MigrationDuplicateUserEmailException)error;
                if (duplicateUserEmailException.getRequestUrl().endsWith("startSSO")) {
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)302).location(new URI(this.redirectUrl + "/migration-error"))).build();
                }
                result.put("email", duplicateUserEmailException.getEmail());
            }
        }
        result.remove("message");
        result.put("status", statusCode.value());
        return ResponseEntity.status((HttpStatus)statusCode).body((Object)result);
    }
}

