/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import myconext.model.ChangeEmailHash;
import myconext.model.PasswordForgottenHash;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.User;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.ChangeEmailHashRepository;
import myconext.repository.PasswordForgottenHashRepository;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ResourceCleaner {
    private static final Log LOG = LogFactory.getLog(ResourceCleaner.class);
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final PasswordForgottenHashRepository passwordForgottenHashRepository;
    private final ChangeEmailHashRepository changeEmailHashRepository;
    private final boolean cronJobResponsible;

    @Autowired
    public ResourceCleaner(AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, PasswordForgottenHashRepository passwordForgottenHashRepository, ChangeEmailHashRepository changeEmailHashRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.passwordForgottenHashRepository = passwordForgottenHashRepository;
        this.changeEmailHashRepository = changeEmailHashRepository;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Scheduled(cron="${cron.token-cleaner-expression}")
    public void clean() {
        if (!this.cronJobResponsible) {
            return;
        }
        Date now = new Date();
        this.info(SamlAuthenticationRequest.class, this.authenticationRequestRepository.deleteByExpiresInBeforeAndRememberMe(now, false).longValue());
        this.info(PasswordForgottenHash.class, this.passwordForgottenHashRepository.deleteByExpiresInBefore(now).longValue());
        this.info(ChangeEmailHash.class, this.changeEmailHashRepository.deleteByExpiresInBefore(now).longValue());
        List users = this.userRepository.findByLinkedAccounts_ExpiresAtBefore(now);
        users.forEach(user -> {
            List linkedAccounts = user.getLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.getExpiresAt().toInstant().isAfter(now.toInstant())).collect(Collectors.toList());
            user.setLinkedAccounts(linkedAccounts);
            LOG.info((Object)String.format("Removed expired linked account for user %s", user.getEmail()));
            this.userRepository.save(user);
        });
        long dayAgo = now.toInstant().minus(1L, ChronoUnit.DAYS).toEpochMilli() / 1000L;
        List newUsersExpired = this.userRepository.findByNewUserTrueAndCreatedLessThan(dayAgo);
        if (newUsersExpired.isEmpty()) {
            LOG.info((Object)"No users found that have not finished registration last 24 hours");
        } else {
            LOG.info((Object)String.format("Removing new users that have not finished registration last 24 hours %s", newUsersExpired.stream().map(User::getEmail).collect(Collectors.joining(", "))));
            this.userRepository.deleteAll((Iterable)newUsersExpired);
        }
    }

    private void info(Class clazz, long count) {
        LOG.info((Object)String.format("Deleted %s instances of %s in cleanup", count, clazz));
    }
}

