/*
 * Decompiled with CFR 0.152.
 */
package myconext.eduid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import myconext.exceptions.UserNotFoundException;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api/eduid"}, produces={"application/json"})
public class APIController {
    private final UserRepository userRepository;

    public APIController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/eppn"})
    public List<Map<String, String>> eppn(BearerTokenAuthentication authentication, @RequestParam(value="schachome", required=false) String schachome) {
        ArrayList uids = (ArrayList)authentication.getTokenAttributes().get("uids");
        User user = (User)this.userRepository.findUserByUid((String)uids.get(0)).orElseThrow(UserNotFoundException::new);
        return user.getLinkedAccounts().stream().map(linkedAccount -> {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("eppn", linkedAccount.getEduPersonPrincipalName());
            info.put("schac_home_organization", linkedAccount.getSchacHomeOrganization());
            return info;
        }).filter(info -> !StringUtils.hasText((String)schachome) || schachome.equals(info.get("schac_home_organization"))).collect(Collectors.toList());
    }
}

