/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import myconext.cron.IdPMetaDataResolver;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.ServiceProviderResolver;
import myconext.model.Challenge;
import myconext.model.ChangeEmailHash;
import myconext.model.DeleteServiceTokens;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.LoginStatus;
import myconext.model.MagicLinkRequest;
import myconext.model.PasswordForgottenHash;
import myconext.model.PublicKeyCredentials;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.UpdateUserSecurityRequest;
import myconext.model.User;
import myconext.model.UserResponse;
import myconext.oidcng.OpenIDConnect;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.ChallengeRepository;
import myconext.repository.ChangeEmailHashRepository;
import myconext.repository.PasswordForgottenHashRepository;
import myconext.repository.UserRepository;
import myconext.security.CookieResolver;
import myconext.security.EmailDomainGuard;
import myconext.security.EmailGuessingPrevention;
import myconext.webauthn.UserCredentialRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/myconext/api"})
public class UserController {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final UserRepository userRepository;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final MailBox mailBox;
    private final ServiceProviderResolver serviceProviderResolver;
    private final OpenIDConnect openIDConnect;
    private final String magicLinkUrl;
    private final String schacHomeOrganization;
    private final String webAuthnSpRedirectUrl;
    private final String idpBaseUrl;
    private final RelyingParty relyingParty;
    private final UserCredentialRepository userCredentialRepository;
    private final ChallengeRepository challengeRepository;
    private final PasswordForgottenHashRepository passwordForgottenHashRepository;
    private final ChangeEmailHashRepository changeEmailHashRepository;
    private static final SecureRandom random = new SecureRandom();
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder(-1, random);
    private final EmailGuessingPrevention emailGuessingPreventor;
    private final EmailDomainGuard emailDomainGuard;
    private final IdPMetaDataResolver idPMetaDataResolver;
    private final String spBaseUrl;
    private final ObjectMapper objectMapper;

    public UserController(UserRepository userRepository, UserCredentialRepository userCredentialRepository, ChallengeRepository challengeRepository, PasswordForgottenHashRepository passwordForgottenHashRepository, ChangeEmailHashRepository changeEmailHashRepository, AuthenticationRequestRepository authenticationRequestRepository, MailBox mailBox, ServiceProviderResolver serviceProviderResolver, OpenIDConnect openIDConnect, IdPMetaDataResolver idPMetaDataResolver, EmailDomainGuard emailDomainGuard, @Qualifier(value="jsonMapper") ObjectMapper objectMapper, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${schac_home_organization}") String schacHomeOrganization, @Value(value="${email_guessing_sleep_millis}") int emailGuessingSleepMillis, @Value(value="${sp_redirect_url}") String spBaseUrl, @Value(value="${idp_redirect_url}") String idpBaseUrl, @Value(value="${rp_origin}") String rpOrigin, @Value(value="${rp_id}") String rpId) {
        this.userRepository = userRepository;
        this.userCredentialRepository = userCredentialRepository;
        this.challengeRepository = challengeRepository;
        this.passwordForgottenHashRepository = passwordForgottenHashRepository;
        this.changeEmailHashRepository = changeEmailHashRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.mailBox = mailBox;
        this.serviceProviderResolver = serviceProviderResolver;
        this.openIDConnect = openIDConnect;
        this.idPMetaDataResolver = idPMetaDataResolver;
        this.emailDomainGuard = emailDomainGuard;
        this.objectMapper = objectMapper;
        this.magicLinkUrl = magicLinkUrl;
        this.schacHomeOrganization = schacHomeOrganization;
        this.idpBaseUrl = idpBaseUrl;
        this.spBaseUrl = spBaseUrl;
        this.webAuthnSpRedirectUrl = String.format("%s/security", spBaseUrl);
        this.relyingParty = this.relyingParty(rpId, rpOrigin);
        this.emailGuessingPreventor = new EmailGuessingPrevention(emailGuessingSleepMillis);
    }

    @GetMapping(value={"/idp/email/domain/institutional"})
    public Set<String> institutionalDomains() {
        return this.idPMetaDataResolver.getDomainNames();
    }

    @GetMapping(value={"/idp/email/domain/allowed"})
    public Set<String> allowedDomains() {
        return this.emailDomainGuard.getAllowedDomains();
    }

    @PostMapping(value={"/idp/magic_link_request"})
    public ResponseEntity newMagicLinkRequest(HttpServletRequest request, @Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User user = magicLinkRequest.getUser();
        String email = user.getEmail();
        this.emailDomainGuard.enforceIsAllowed(email);
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        if (optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body(Collections.singletonMap("status", HttpStatus.CONFLICT.value()));
        }
        String preferredLanguage = LocaleContextHolder.getLocale().getLanguage();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        String schacHomeOrganization = this.emailDomainGuard.schacHomeOrganizationByDomain(this.schacHomeOrganization, email);
        User userToSave = new User(UUID.randomUUID().toString(), email, user.getGivenName(), user.getFamilyName(), schacHomeOrganization, preferredLanguage, requesterEntityId, this.serviceProviderResolver);
        userToSave = (User)this.userRepository.save((Object)userToSave);
        return this.doMagicLink(userToSave, samlAuthenticationRequest, magicLinkRequest.isRememberMe(), false, request);
    }

    @PutMapping(value={"/idp/magic_link_request"})
    public ResponseEntity magicLinkRequest(HttpServletRequest request, @Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        User providedUser = magicLinkRequest.getUser();
        String email = providedUser.getEmail();
        this.emailDomainGuard.enforceIsAllowed(email);
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.findUserStoreLanguage(email);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        MDCContext.logWithContext((User)user, (String)"update", (String)"user", (Log)LOG, (String)("Updating user " + user.getEmail()));
        user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, this.serviceProviderResolver);
        this.userRepository.save((Object)user);
        if (magicLinkRequest.isUsePassword()) {
            if (!this.passwordEncoder.matches((CharSequence)providedUser.getPassword(), user.getPassword())) {
                MDCContext.logLoginWithContext((User)user, (String)"password", (boolean)false, (Log)LOG, (String)"Bad attempt to login with password");
                return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(Collections.singletonMap("status", HttpStatus.FORBIDDEN.value()));
            }
            MDCContext.logLoginWithContext((User)user, (String)"password", (boolean)true, (Log)LOG, (String)"Successfully logged in with password");
            LOG.info((Object)"Successfully logged in with password");
        }
        return this.doMagicLink(user, samlAuthenticationRequest, magicLinkRequest.isRememberMe(), magicLinkRequest.isUsePassword(), request);
    }

    @GetMapping(value={"/idp/resend_magic_link_request"})
    public ResponseEntity resendMagicLinkRequest(HttpServletRequest request, @RequestParam(value="id") String authenticationRequestId) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(authenticationRequestId).orElseThrow(ExpiredAuthenticationException::new);
        User user = (User)this.userRepository.findById((Object)samlAuthenticationRequest.getUserId()).orElseThrow(UserNotFoundException::new);
        if (user.isNewUser()) {
            this.mailBox.sendAccountVerification(user, samlAuthenticationRequest.getHash());
        } else {
            String serviceName = this.getServiceName(request, samlAuthenticationRequest);
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), serviceName);
        }
        return ResponseEntity.ok((Object)true);
    }

    private String getServiceName(HttpServletRequest request, SamlAuthenticationRequest samlAuthenticationRequest) {
        String lang = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(cookie -> cookie.getValue()).orElse("en");
        Optional optionalServiceProvider = this.serviceProviderResolver.resolve(samlAuthenticationRequest.getRequesterEntityId());
        String serviceName = optionalServiceProvider.map(serviceProvider -> lang.equals("en") ? serviceProvider.getName() : serviceProvider.getNameNl()).orElse(samlAuthenticationRequest.getRequesterEntityId());
        return serviceName;
    }

    @GetMapping(value={"/idp/security/success"})
    public int successfullyLoggedIn(@RequestParam(value="id") String id) {
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findById((Object)id);
        return optionalSamlAuthenticationRequest.map(samlAuthenticationRequest -> samlAuthenticationRequest.getLoginStatus().ordinal()).orElse(LoginStatus.NOT_LOGGED_IN.ordinal());
    }

    @GetMapping(value={"/sp/me", "sp/migrate/merge", "sp/migrate/proceed"})
    public ResponseEntity<UserResponse> me(Authentication authentication) {
        User user = (User)this.userRepository.findById((Object)((User)authentication.getPrincipal()).getId()).orElseThrow(UserNotFoundException::new);
        return this.userResponseRememberMe(user);
    }

    @DeleteMapping(value={"/sp/forget"})
    public ResponseEntity<Long> forgetMe(Authentication authentication) {
        User user = (User)authentication.getPrincipal();
        String userId = user.getId();
        Long count = this.authenticationRequestRepository.deleteByUserId(userId);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"rememberme", (Log)LOG, (String)"Do not remember user anymore");
        return ResponseEntity.ok((Object)count);
    }

    @PutMapping(value={"/sp/update"})
    public ResponseEntity<UserResponse> updateUserProfile(Authentication authentication, @RequestBody User deltaUser) {
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        user.setFamilyName(deltaUser.getFamilyName());
        user.setGivenName(deltaUser.getGivenName());
        user.validate();
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"update", (String)"name", (Log)LOG, (String)"Update user profile");
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @PutMapping(value={"/sp/email"})
    public ResponseEntity updateEmail(Authentication authentication, @RequestBody User deltaUser) {
        User user = this.userFromAuthentication(authentication);
        this.changeEmailHashRepository.deleteByUserId(user.getId());
        String hashValue = UserController.hash();
        String newEmail = deltaUser.getEmail();
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(newEmail));
        if (optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).body(Collections.singletonMap("status", HttpStatus.CONFLICT.value()));
        }
        this.changeEmailHashRepository.save((Object)new ChangeEmailHash(user, newEmail, hashValue));
        MDCContext.logWithContext((User)user, (String)"update", (String)"update-email", (Log)LOG, (String)"Send update email mail");
        this.mailBox.sendUpdateEmail(user, newEmail, hashValue);
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @GetMapping(value={"/sp/confirm-email"})
    public ResponseEntity<UserResponse> confirmUpdateEmail(Authentication authentication, @RequestParam(value="h") String hash) {
        User user = this.userFromAuthentication(authentication);
        String oldEmail = user.getEmail();
        ChangeEmailHash changeEmailHash = (ChangeEmailHash)this.changeEmailHashRepository.findByHashAndUserId(hash, user.getId()).orElseThrow(() -> new ForbiddenException("wrong_hash"));
        user.setEmail(changeEmailHash.getNewEmail());
        this.userRepository.save((Object)user);
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        this.mailBox.sendUpdateConfirmationEmail(user, oldEmail, user.getEmail());
        return this.returnUserResponse(user);
    }

    @PutMapping(value={"/sp/security"})
    public ResponseEntity updateUserSecurity(Authentication authentication, @RequestBody UpdateUserSecurityRequest updateUserRequest) {
        User deltaUser = (User)this.userRepository.findById((Object)updateUserRequest.getUserId()).orElseThrow(UserNotFoundException::new);
        User user = this.verifyAndFetchUser(authentication, deltaUser);
        String password = user.getPassword();
        boolean existingPassword = StringUtils.hasText((String)password);
        String currentPasswordFromUser = updateUserRequest.getCurrentPassword();
        boolean passwordMatches = currentPasswordFromUser != null && this.passwordEncoder.matches((CharSequence)currentPasswordFromUser, password);
        boolean forgottenPassword = user.isForgottenPassword();
        if (existingPassword && !passwordMatches && !forgottenPassword) {
            throw new ForbiddenException("no_match");
        }
        if (forgottenPassword && !passwordMatches) {
            this.passwordForgottenHashRepository.findByHashAndUserId(updateUserRequest.getHash(), user.getId()).orElseThrow(() -> new ForbiddenException("wrong_hash"));
        }
        user.encryptPassword(updateUserRequest.getNewPassword(), this.passwordEncoder);
        user.setForgottenPassword(false);
        this.userRepository.save((Object)user);
        this.passwordForgottenHashRepository.deleteByUserId(user.getId());
        String action = existingPassword ? "update" : "add";
        MDCContext.logWithContext((User)user, (String)action, (String)"password", (Log)LOG, (String)(action + " password"));
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @PutMapping(value={"/sp/forgot-password"})
    public ResponseEntity<UserResponse> forgotPassword(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        this.passwordForgottenHashRepository.deleteByUserId(user.getId());
        user.setForgottenPassword(true);
        this.userRepository.save((Object)user);
        String hashValue = UserController.hash();
        this.passwordForgottenHashRepository.save((Object)new PasswordForgottenHash(user, hashValue));
        MDCContext.logWithContext((User)user, (String)"update", (String)"forgot-password", (Log)LOG, (String)"Send password forgotten mail");
        this.mailBox.sendForgotPassword(user, hashValue);
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @PutMapping(value={"/sp/institution"})
    public ResponseEntity<UserResponse> removeUserLinkedAccounts(Authentication authentication, @RequestBody LinkedAccount linkedAccount) {
        User user = this.userFromAuthentication(authentication);
        List linkedAccounts = user.getLinkedAccounts().stream().filter(la -> !la.getSchacHomeOrganization().equals(linkedAccount.getSchacHomeOrganization())).collect(Collectors.toList());
        user.setLinkedAccounts(linkedAccounts);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"linked_account", (Log)LOG, (String)("Deleted linked account " + linkedAccount.getSchacHomeOrganization()));
        return this.userResponseRememberMe(user);
    }

    @PostMapping(value={"/sp/credential"})
    public ResponseEntity updatePublicKeyCredential(Authentication authentication, @RequestBody Map<String, String> credential) {
        User user = this.userFromAuthentication(authentication);
        String identifier = credential.get("identifier");
        Optional<PublicKeyCredentials> publicKeyCredentials = user.getPublicKeyCredentials().stream().filter(key -> key.getIdentifier().equals(identifier)).findFirst();
        if (!publicKeyCredentials.isPresent()) {
            return this.return404();
        }
        PublicKeyCredentials credentials = publicKeyCredentials.get();
        credentials.setName(credential.get("name"));
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"update", (String)"webauthn_key", (Log)LOG, (String)("Updated publicKeyCredential " + credential.get("name")));
        return this.userResponseRememberMe(user);
    }

    @PutMapping(value={"/sp/credential"})
    public ResponseEntity removePublicKeyCredential(Authentication authentication, @RequestBody Map<String, String> credential) {
        User user = this.userFromAuthentication(authentication);
        String identifier = credential.get("identifier");
        List publicKeyCredentials = user.getPublicKeyCredentials().stream().filter(key -> !key.getIdentifier().equals(identifier)).collect(Collectors.toList());
        user.setPublicKeyCredentials(publicKeyCredentials);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"webauthn_key", (Log)LOG, (String)("Deleted publicKeyCredential " + credential.get("name")));
        return this.userResponseRememberMe(user);
    }

    @PutMapping(value={"/sp/service"})
    public ResponseEntity<UserResponse> removeUserService(Authentication authentication, @RequestBody DeleteServiceTokens serviceAndTokens) {
        User user = this.userFromAuthentication(authentication);
        String eduIdValue = serviceAndTokens.getEduId();
        List newEduIDs = user.getEduIDS().stream().filter(eduID -> !eduID.getValue().equals(eduIdValue)).collect(Collectors.toList());
        user.setEduIDS(newEduIDs);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"eppn", (Log)LOG, (String)("Deleted eduID " + eduIdValue));
        return this.doRemoveTokens(serviceAndTokens, user);
    }

    @PutMapping(value={"/sp/tokens"})
    public ResponseEntity<UserResponse> removeTokens(Authentication authentication, @RequestBody DeleteServiceTokens serviceAndTokens) {
        User user = this.userFromAuthentication(authentication);
        String eduIdValue = serviceAndTokens.getEduId();
        MDCContext.logWithContext((User)user, (String)"delete", (String)"tokens", (Log)LOG, (String)("Deleted tokens " + eduIdValue));
        return this.doRemoveTokens(serviceAndTokens, user);
    }

    @GetMapping(value={"/sp/testWebAuthnUrl"})
    public ResponseEntity<Map<String, String>> testWebAuthnUrl(Authentication authentication) throws UnsupportedEncodingException {
        User user = this.userFromAuthentication(authentication);
        SamlAuthenticationRequest samlAuthenticationRequest = new SamlAuthenticationRequest(true);
        samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        String email = URLEncoder.encode(user.getEmail(), Charset.defaultCharset().name());
        String loginUrl = String.format("%s/webauthnTest/%s?name=Test-webAuthn&email=%s&testWebAuthn=true", this.idpBaseUrl, samlAuthenticationRequest.getId(), email);
        return ResponseEntity.status((int)200).body(Collections.singletonMap("url", loginUrl));
    }

    private ResponseEntity<UserResponse> doRemoveTokens(@RequestBody DeleteServiceTokens serviceAndTokens, User user) {
        List tokens = serviceAndTokens.getTokens();
        if (!CollectionUtils.isEmpty((Collection)tokens)) {
            this.openIDConnect.deleteTokens(tokens, user);
        }
        return this.userResponseRememberMe(user);
    }

    @GetMapping(value={"/sp/tokens"})
    public ResponseEntity<List<Map<String, Object>>> tokens(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        List tokens = this.openIDConnect.tokens(user);
        return ResponseEntity.ok((Object)tokens);
    }

    private User userFromAuthentication(Authentication authentication) {
        String id = ((User)authentication.getPrincipal()).getId();
        return (User)this.userRepository.findById((Object)id).orElseThrow(UserNotFoundException::new);
    }

    private ResponseEntity<UserResponse> returnUserResponse(User user) {
        return ResponseEntity.status((int)201).body((Object)new UserResponse(user, this.convertEduIdPerServiceProvider(user), false));
    }

    private ResponseEntity<UserResponse> userResponseRememberMe(User user) {
        List samlAuthenticationRequests = this.authenticationRequestRepository.findByUserIdAndRememberMe(user.getId(), true);
        return ResponseEntity.ok((Object)new UserResponse(user, this.convertEduIdPerServiceProvider(user), !samlAuthenticationRequests.isEmpty()));
    }

    @GetMapping(value={"sp/security/webauthn"})
    public ResponseEntity spStartWebAuthFlow(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String webAuthnIdentifier = this.hash();
        user.setWebAuthnIdentifier(webAuthnIdentifier);
        this.userRepository.save((Object)user);
        return ResponseEntity.status((int)200).body(Collections.singletonMap("token", webAuthnIdentifier));
    }

    @PostMapping(value={"idp/security/webauthn/registration"})
    public ResponseEntity idpWebAuthnRegistration(@RequestBody Map<String, String> body) throws Base64UrlException {
        String token = body.get("token");
        Optional optionalUser = this.userRepository.findUserByWebAuthnIdentifier(token);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        if (!StringUtils.hasText((String)user.getUserHandle())) {
            user.setUserHandle(this.hash());
            this.userRepository.save((Object)user);
        }
        PublicKeyCredentialCreationOptions request = this.publicKeyCredentialCreationOptions(this.relyingParty, user);
        String challenge = request.getChallenge().getBase64Url();
        this.challengeRepository.save((Object)new Challenge(token, challenge));
        return ResponseEntity.status((int)200).body((Object)request);
    }

    @PutMapping(value={"idp/security/webauthn/registration"})
    public ResponseEntity idpWebAuthn(@RequestBody Map<String, Object> body) {
        try {
            return this.doIdpWebAuthn(body);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)201).body(Collections.singletonMap("location", this.webAuthnSpRedirectUrl));
        }
    }

    private ResponseEntity doIdpWebAuthn(Map<String, Object> body) throws IOException, Base64UrlException, RegistrationFailedException, NoSuchFieldException, IllegalAccessException {
        String token = (String)body.get("token");
        String name = (String)body.get("name");
        Optional optionalUser = this.userRepository.findUserByWebAuthnIdentifier(token);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        String credentials = (String)body.get("credentials");
        PublicKeyCredential pkc = PublicKeyCredential.parseRegistrationResponseJson((String)credentials);
        User user = (User)optionalUser.get();
        user.setWebAuthnIdentifier(null);
        PublicKeyCredentialCreationOptions request = this.publicKeyCredentialCreationOptions(this.relyingParty, user);
        Challenge challenge = (Challenge)this.challengeRepository.findByToken(token).orElseThrow(ForbiddenException::new);
        UserController.restoreChallenge((Object)request, (ByteArray)ByteArray.fromBase64Url((String)challenge.getChallenge()));
        this.challengeRepository.delete((Object)challenge);
        RegistrationResult result = this.relyingParty.finishRegistration(FinishRegistrationOptions.builder().request(request).response(pkc).build());
        PublicKeyCredentialDescriptor keyId = result.getKeyId();
        ByteArray publicKeyCose = result.getPublicKeyCose();
        user.addPublicKeyCredential(keyId, publicKeyCose, name);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"add", (String)"webauthn_key", (Log)LOG, (String)("Created publicKeyCredential " + name));
        return ResponseEntity.status((int)201).body(Collections.singletonMap("location", this.webAuthnSpRedirectUrl));
    }

    @PostMapping(value={"idp/security/webauthn/authentication"})
    public ResponseEntity idpWebAuthnStartAuthentication(@RequestBody Map<String, String> body) {
        String email = body.get("email");
        this.emailDomainGuard.enforceIsAllowed(email);
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        AssertionRequest request = this.relyingParty.startAssertion(StartAssertionOptions.builder().username(Optional.of(user.getEmail())).build());
        String authenticationRequestId = body.get("authenticationRequestId");
        String challenge = request.getPublicKeyCredentialRequestOptions().getChallenge().getBase64Url();
        this.challengeRepository.findByToken(authenticationRequestId).ifPresent(existingChallenge -> this.challengeRepository.delete(existingChallenge));
        this.challengeRepository.save((Object)new Challenge(authenticationRequestId, challenge, user.getEmail()));
        return ResponseEntity.status((int)200).body((Object)request);
    }

    @PutMapping(value={"idp/security/webauthn/authentication"})
    public ResponseEntity idpWebAuthnTryAuthentication(HttpServletRequest request, @RequestBody Map<String, Object> body) throws Base64UrlException, IOException, AssertionFailedException, NoSuchFieldException, IllegalAccessException {
        String authenticationRequestId = (String)body.get("authenticationRequestId");
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(authenticationRequestId).orElseThrow(ExpiredAuthenticationException::new);
        boolean rememberMe = (Boolean)body.get("rememberMe");
        PublicKeyCredential pkc = PublicKeyCredential.parseAssertionResponseJson((String)((String)body.get("credentials")));
        Challenge challenge = (Challenge)this.challengeRepository.findByToken(authenticationRequestId).orElseThrow(ForbiddenException::new);
        AssertionRequest assertionRequest = this.relyingParty.startAssertion(StartAssertionOptions.builder().username(Optional.of(challenge.getEmail())).build());
        UserController.restoreChallenge((Object)assertionRequest.getPublicKeyCredentialRequestOptions(), (ByteArray)ByteArray.fromBase64Url((String)challenge.getChallenge()));
        AssertionResult result = this.relyingParty.finishAssertion(FinishAssertionOptions.builder().request(assertionRequest).response(pkc).build());
        if (!result.isSuccess()) {
            if (samlAuthenticationRequest.isTestInstance()) {
                String url = String.format("%s/security?success=false", this.spBaseUrl);
                return ResponseEntity.status((int)201).body(Collections.singletonMap("url", url));
            }
            throw new ForbiddenException();
        }
        this.challengeRepository.delete((Object)challenge);
        Optional optionalUser = this.findUserStoreLanguage(challenge.getEmail());
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        MDCContext.logLoginWithContext((User)user, (String)"webauthn", (boolean)true, (Log)LOG, (String)"Successfully logged in with webauthn");
        if (samlAuthenticationRequest.isTestInstance()) {
            String url = String.format("%s/security?success=true", this.spBaseUrl);
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", url));
        }
        return this.doMagicLink(user, samlAuthenticationRequest, rememberMe, true, request);
    }

    private PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions(RelyingParty relyingParty, User user) throws Base64UrlException {
        return relyingParty.startRegistration(StartRegistrationOptions.builder().user(UserIdentity.builder().name(user.getEmail()).displayName(String.format("%s %s", user.getGivenName(), user.getFamilyName())).id(ByteArray.fromBase64Url((String)user.getUserHandle())).build()).build());
    }

    private RelyingParty relyingParty(String rpId, String rpOrigin) {
        RelyingPartyIdentity rpIdentity = RelyingPartyIdentity.builder().id(rpId).name("eduID").build();
        return RelyingParty.builder().identity(rpIdentity).credentialRepository((CredentialRepository)this.userCredentialRepository).origins(Collections.singleton(rpOrigin)).build();
    }

    protected static void restoreChallenge(Object challengeContainer, ByteArray challenge) throws NoSuchFieldException, IllegalAccessException {
        Field challengeField = challengeContainer.getClass().getDeclaredField("challenge");
        challengeField.setAccessible(true);
        challengeField.set(challengeContainer, challenge);
    }

    @GetMapping(value={"sp/personal"})
    public ResponseEntity personal(Authentication authentication) throws JsonProcessingException {
        User user = this.userFromAuthentication(authentication);
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)user));
    }

    @GetMapping(value={"/sp/logout"})
    public ResponseEntity logout(HttpServletRequest request, Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        MDCContext.logWithContext((User)user, (String)"logout", (String)"user", (Log)LOG, (String)"Logout");
        return this.doLogout(request);
    }

    @DeleteMapping(value={"/sp/delete"})
    public ResponseEntity deleteUser(Authentication authentication, HttpServletRequest request) {
        User user = this.userFromAuthentication(authentication);
        this.userRepository.delete((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"account", (Log)LOG, (String)"Delete account");
        return this.doLogout(request);
    }

    private ResponseEntity doLogout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        return ResponseEntity.ok(Collections.singletonMap("status", "ok"));
    }

    private User verifyAndFetchUser(Authentication authentication, User deltaUser) {
        return this.verifyAndFetchUser(authentication, deltaUser.getId());
    }

    private User verifyAndFetchUser(Authentication authentication, String id) {
        User principal = (User)authentication.getPrincipal();
        if (!principal.getId().equals(id)) {
            throw new ForbiddenException();
        }
        return (User)this.userRepository.findUserByUid(principal.getUid()).orElseThrow(UserNotFoundException::new);
    }

    private ResponseEntity doMagicLink(User user, SamlAuthenticationRequest samlAuthenticationRequest, boolean rememberMe, boolean passwordOrWebAuthnFlow, HttpServletRequest request) {
        samlAuthenticationRequest.setHash(UserController.hash());
        samlAuthenticationRequest.setUserId(user.getId());
        samlAuthenticationRequest.setPasswordOrWebAuthnFlow(passwordOrWebAuthnFlow);
        samlAuthenticationRequest.setRememberMe(rememberMe);
        if (rememberMe) {
            samlAuthenticationRequest.setRememberMeValue(UUID.randomUUID().toString());
        }
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        String serviceName = this.getServiceName(request, samlAuthenticationRequest);
        if (passwordOrWebAuthnFlow) {
            LOG.debug((Object)String.format("Returning passwordOrWebAuthnFlow magic link for existing user %s", user.getUsername()));
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash()));
        }
        if (user.isNewUser()) {
            LOG.debug((Object)String.format("Sending account verification mail with magic link for new user %s", user.getUsername()));
            this.mailBox.sendAccountVerification(user, samlAuthenticationRequest.getHash());
        } else {
            LOG.debug((Object)"Sending magic link email for existing user");
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), serviceName);
        }
        return ResponseEntity.status((int)201).body(Collections.singletonMap("result", "ok"));
    }

    private Map<String, EduID> convertEduIdPerServiceProvider(User user) {
        return user.getEduIDS().stream().collect(Collectors.toMap(EduID::getServiceProviderEntityId, eduID -> eduID));
    }

    private Optional<User> findUserStoreLanguage(String email) {
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        optionalUser.ifPresent(user -> {
            String preferredLanguage = user.getPreferredLanguage();
            String language = LocaleContextHolder.getLocale().getLanguage();
            if (!StringUtils.hasText((String)preferredLanguage) || !preferredLanguage.equals(language)) {
                user.setPreferredLanguage(language);
                this.userRepository.save(user);
            }
        });
        return optionalUser;
    }

    private ResponseEntity return404() {
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(Collections.singletonMap("status", HttpStatus.NOT_FOUND.value()));
    }

    public static String hash() {
        byte[] bytes = new byte[64];
        random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }
}

