/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import myconext.model.User;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="password_forgotten_hashes")
public class PasswordForgottenHash
implements Serializable {
    @Id
    private String id;
    private String hash;
    private Date expiresIn;
    private String userId;

    public PasswordForgottenHash(User user, String hash) {
        this.userId = user.getId();
        this.hash = hash;
        this.expiresIn = Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneId.systemDefault()).toInstant());
    }

    public PasswordForgottenHash() {
    }

    public String getId() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public Date getExpiresIn() {
        return this.expiresIn;
    }

    public String getUserId() {
        return this.userId;
    }
}

