/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import myconext.manage.ServiceProviderResolver;
import myconext.model.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MetaDataServiceProviderResolver
implements ServiceProviderResolver {
    private static final Log LOG = LogFactory.getLog(MetaDataServiceProviderResolver.class);
    private final Resource metaDataResource;
    private final ObjectMapper objectMapper;
    private Map<String, ServiceProvider> serviceProviders = new HashMap();

    @Autowired
    public MetaDataServiceProviderResolver(@Value(value="${metadata_sp_url}") Resource metaDataResource, @Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this(metaDataResource, objectMapper, true);
    }

    public MetaDataServiceProviderResolver(@Value(value="${metadata_sp_url}") Resource metaDataResource, ObjectMapper objectMapper, boolean lazy) {
        this.metaDataResource = metaDataResource;
        this.objectMapper = objectMapper;
        if (!lazy) {
            this.refresh();
        }
    }

    @Scheduled(initialDelayString="${cron.service-name-resolver-initial-delay-milliseconds}", fixedRateString="${cron.service-name-resolver-fixed-rate-milliseconds}")
    public void refresh() {
        long start = System.currentTimeMillis();
        try {
            this.serviceProviders = ((List)this.objectMapper.readValue(this.metaDataResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).stream().collect(Collectors.toMap(m -> (String)m.keySet().iterator().next(), m -> this.serviceProvider(m)));
            LOG.info((Object)("Refreshed all " + this.serviceProviders.size() + " Service provders" + this.metaDataResource + "in " + (System.currentTimeMillis() - start) + " ms"));
        }
        catch (Throwable t) {
            LOG.error((Object)("Error in refreshing service names from " + this.metaDataResource), t);
        }
    }

    private ServiceProvider serviceProvider(Map<String, Map<String, String>> map) {
        Map<String, String> values = map.values().iterator().next();
        return new ServiceProvider(values.get("en"), values.get("nl"), values.get("logo_url"), values.get("home_url"));
    }

    public Optional<ServiceProvider> resolve(String entityId) {
        return Optional.ofNullable((ServiceProvider)this.serviceProviders.get(entityId));
    }
}

