/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import myconext.model.ServiceProvider;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.util.StringUtils;

public class EduID {
    private String serviceProviderEntityId;
    @Indexed
    private String value;
    private String serviceName;
    private String serviceNameNl;
    private String serviceLogoUrl;
    private String serviceHomeUrl;
    private Date createdAt;

    public EduID(String value, String serviceProviderEntityId, Optional<ServiceProvider> serviceProviderOptional) {
        this.value = value;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.createdAt = new Date();
        if (serviceProviderOptional.isPresent()) {
            ServiceProvider serviceProvider = serviceProviderOptional.get();
            this.serviceName = serviceProvider.getName();
            this.serviceNameNl = StringUtils.hasText((String)serviceProvider.getNameNl()) ? serviceProvider.getNameNl() : this.serviceName;
            this.serviceHomeUrl = serviceProvider.getHomeUrl();
            this.serviceLogoUrl = serviceProvider.getLogoUrl();
        } else {
            this.serviceName = serviceProviderEntityId;
            this.serviceNameNl = serviceProviderEntityId;
        }
    }

    public EduID(String serviceProviderEntityId, Map<String, Object> values) {
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.value = (String)values.get("value");
        this.serviceName = (String)values.get("serviceName");
        this.serviceNameNl = (String)values.get("serviceNameNl");
        this.serviceLogoUrl = (String)values.get("serviceLogoUrl");
        this.serviceHomeUrl = (String)values.get("serviceHomeUrl");
        Object createdAt = values.get("createdAt");
        if (createdAt instanceof Date) {
            this.createdAt = (Date)createdAt;
        } else if (createdAt instanceof String) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            this.createdAt = formatter.parse((String)createdAt);
        } else {
            this.createdAt = new Date();
        }
    }

    public void updateServiceProvider(ServiceProvider serviceProvider) {
        this.serviceName = serviceProvider.getName();
        this.serviceNameNl = StringUtils.hasText((String)serviceProvider.getNameNl()) ? serviceProvider.getNameNl() : this.serviceName;
        this.serviceHomeUrl = serviceProvider.getHomeUrl();
        this.serviceLogoUrl = serviceProvider.getLogoUrl();
    }

    public void replaceAtWithDot() {
        if (this.serviceProviderEntityId.contains("@")) {
            this.serviceProviderEntityId = this.serviceProviderEntityId.replaceAll("@", ".");
        }
    }

    public String toString() {
        return "EduID{serviceProviderEntityId='" + this.serviceProviderEntityId + '\'' + ", value='" + this.value + '\'' + ", createdAt=" + this.createdAt + '}';
    }

    public EduID() {
    }

    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    public String getValue() {
        return this.value;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNameNl() {
        return this.serviceNameNl;
    }

    public String getServiceLogoUrl() {
        return this.serviceLogoUrl;
    }

    public String getServiceHomeUrl() {
        return this.serviceHomeUrl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }
}

