/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import myconext.manage.ServiceProviderResolver;
import myconext.model.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Profile(value={"!test"})
public class ManageServiceProviderResolver
implements ServiceProviderResolver {
    private static final Log LOG = LogFactory.getLog(ManageServiceProviderResolver.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final String manageBaseUrl;
    private Map<String, ServiceProvider> serviceProviders = new HashMap();
    private final HttpHeaders headers = new HttpHeaders();
    private final Map<String, Object> body = new HashMap();
    private final ParameterizedTypeReference<List<Map<String, Object>>> typeReference = new /* Unavailable Anonymous Inner Class!! */;

    public ManageServiceProviderResolver(@Value(value="${manage.username}") String userName, @Value(value="${manage.password}") String password, @Value(value="${manage.base_url}") String baseUrl) {
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(userName, password));
        this.manageBaseUrl = baseUrl;
        this.headers.add("Content-Type", "application/json");
        this.body.put("state", "prodaccepted");
        this.body.put("REQUESTED_ATTRIBUTES", Arrays.asList("metaDataFields.coin:application_url", "metaDataFields.logo:0:url", "metaDataFields.coin:institution_guid"));
    }

    @Scheduled(initialDelayString="${cron.service-name-resolver-initial-delay-milliseconds}", fixedRateString="${cron.service-name-resolver-fixed-rate-milliseconds}")
    public void refresh() {
        this.doRefresh(Optional.empty());
    }

    private void doRefresh(Optional<String> optionalEntityId) {
        long start = System.currentTimeMillis();
        try {
            HashMap<String, String> requestBody = this.body;
            if (optionalEntityId.isPresent()) {
                requestBody = new HashMap<String, String>(this.body);
                requestBody.put("entityid", optionalEntityId.get());
            }
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)this.headers);
            Map newServiceProviders = this.exchangeAndParse(requestEntity, "saml20_sp");
            Map relyingParties = this.exchangeAndParse(requestEntity, "oidc10_rp");
            LOG.info((Object)String.format("Refreshed %s Service providers and %s Relying parties in %s ms", newServiceProviders.size(), relyingParties.size(), System.currentTimeMillis() - start));
            newServiceProviders.putAll(relyingParties);
            if (optionalEntityId.isPresent()) {
                this.serviceProviders.putAll(newServiceProviders);
            } else {
                this.serviceProviders = newServiceProviders;
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Error in refreshing metadata from " + this.manageBaseUrl), t);
        }
    }

    private Map<String, ServiceProvider> exchangeAndParse(HttpEntity<Map<String, Object>> requestEntity, String entityType) {
        return ((List)this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + entityType, HttpMethod.POST, requestEntity, this.typeReference, new Object[0]).getBody()).stream().collect(Collectors.toMap(arg_0 -> this.entityId(arg_0), arg_0 -> this.serviceProvider(arg_0)));
    }

    private String entityId(Map<String, Object> map) {
        Map data = (Map)map.get("data");
        return (String)data.get("entityid");
    }

    private ServiceProvider serviceProvider(Map<String, Object> map) {
        Map data = (Map)map.get("data");
        Map metaDataFields = (Map)data.get("metaDataFields");
        return new ServiceProvider((String)metaDataFields.get("name:en"), (String)metaDataFields.get("name:nl"), (String)metaDataFields.get("logo:0:url"), (String)metaDataFields.get("coin:application_url"), (String)metaDataFields.get("coin:institution_guid"));
    }

    public Optional<ServiceProvider> resolve(String entityId) {
        Optional<ServiceProvider> optionalServiceProvider;
        if (this.serviceProviders.isEmpty()) {
            this.refresh();
        }
        if (!(optionalServiceProvider = Optional.ofNullable((ServiceProvider)this.serviceProviders.get(entityId))).isPresent()) {
            this.doRefresh(Optional.of(entityId));
            return Optional.ofNullable((ServiceProvider)this.serviceProviders.get(entityId));
        }
        return optionalServiceProvider;
    }
}

