/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import myconext.api.AccountLinkerController;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.manage.ServiceProviderResolver;
import myconext.model.LinkedAccount;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.StepUpStatus;
import myconext.model.User;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserRepository;
import myconext.security.ACR;
import myconext.security.GuestIdpAuthenticationRequestFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/myconext/api"})
public class AccountLinkerController {
    private static final Log LOG = LogFactory.getLog(AccountLinkerController.class);
    private final String oidcBaseUrl;
    private final String clientId;
    private final String clientSecret;
    private final String idpFlowRedirectUri;
    private final String spFlowRedirectUri;
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders headers = new HttpHeaders();
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final ServiceProviderResolver serviceProviderResolver;
    private final UserRepository userRepository;
    private final String magicLinkUrl;
    private final String idpErrorRedirectUrl;
    private final String spRedirectUrl;
    private final long expiryNonValidatedDurationDays;
    private final long expiryValidatedDurationDays;
    private final String idpExternalValidationEntityId;
    private final String myConextSpEntityId;
    private final boolean useExternalValidationFeature;
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    public AccountLinkerController(AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, ServiceProviderResolver serviceProviderResolver, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${idp_redirect_url}") String idpErrorRedirectUrl, @Value(value="${sp_redirect_url}") String spRedirectUrl, @Value(value="${oidc.client-id}") String clientId, @Value(value="${oidc.secret}") String clientSecret, @Value(value="${oidc.idp-flow-redirect-url}") String idpFlowRedirectUri, @Value(value="${oidc.sp-flow-redirect-url}") String spFlowRedirectUri, @Value(value="${oidc.base-url}") String oidcBaseUrl, @Value(value="${oidc.expiry-duration-days-non-validated}") long expiryNonValidatedDurationDays, @Value(value="${oidc.expiry-duration-days-validated}") long expiryValidatedDurationDays, @Value(value="${account_linking.idp_external_validation_entity_id}") String idpExternalValidationEntityId, @Value(value="${account_linking.myconext_sp_entity_id}") String myConextSpEntityId, @Value(value="${feature.use_external_validation}") boolean useExternalValidationFeature) {
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.serviceProviderResolver = serviceProviderResolver;
        this.magicLinkUrl = magicLinkUrl;
        this.idpErrorRedirectUrl = idpErrorRedirectUrl;
        this.spRedirectUrl = spRedirectUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.idpFlowRedirectUri = idpFlowRedirectUri;
        this.spFlowRedirectUri = spFlowRedirectUri;
        this.oidcBaseUrl = oidcBaseUrl;
        this.expiryNonValidatedDurationDays = expiryNonValidatedDurationDays;
        this.expiryValidatedDurationDays = expiryValidatedDurationDays;
        this.idpExternalValidationEntityId = idpExternalValidationEntityId;
        this.myConextSpEntityId = myConextSpEntityId;
        this.useExternalValidationFeature = useExternalValidationFeature;
        this.headers.set("Accept", "application/json");
    }

    @GetMapping(value={"/idp/oidc/account/{id}"})
    public ResponseEntity startIdPLinkAccountFlow(@PathVariable(value="id") String id, @RequestParam(value="forceAuth", required=false, defaultValue="false") boolean forceAuth, @RequestParam(value="useExternalValidation", required=false, defaultValue="false") boolean useExternalValidation) throws UnsupportedEncodingException {
        LOG.debug((Object)"Start IdP link account flow");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpErrorRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        if (useExternalValidation && this.useExternalValidationFeature && !samlAuthenticationRequest.isUseExternalValidation()) {
            samlAuthenticationRequest.setUseExternalValidation(true);
            this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        }
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        String state = String.format("id=%s&user_uid=%s", id, this.passwordEncoder.encode((CharSequence)user.getUid()));
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, this.idpFlowRedirectUri, forceAuth, samlAuthenticationRequest.isUseExternalValidation(), samlAuthenticationRequest.getRequesterEntityId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(uriComponents.toUri())).build();
    }

    @GetMapping(value={"/sp/oidc/link"})
    public ResponseEntity startSPLinkAccountFlow(Authentication authentication) throws UnsupportedEncodingException {
        LOG.debug((Object)"Start link account flow");
        User principal = (User)authentication.getPrincipal();
        String state = this.passwordEncoder.encode((CharSequence)principal.getUid());
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, this.spFlowRedirectUri, true, false, this.myConextSpEntityId);
        return ResponseEntity.ok(Collections.singletonMap("url", uriComponents.toUriString()));
    }

    private UriComponents doStartLinkAccountFlow(String state, String redirectUri, boolean forceAuth, boolean useExternalValidation, String requesterEntityId) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("response_type", "code");
        params.put("scope", "openid");
        params.put("redirect_uri", redirectUri);
        params.put("state", URLEncoder.encode(state, "UTF-8"));
        if (forceAuth) {
            params.put("prompt", "login");
        }
        if (useExternalValidation) {
            params.put("login_hint", this.idpExternalValidationEntityId);
            params.put("acr_values", requesterEntityId);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.oidcBaseUrl + "/oidc/authorize"));
        params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        return builder.build();
    }

    @GetMapping(value={"/sp/oidc/redirect"})
    public ResponseEntity spFlowRedirect(Authentication authentication, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        User principal = (User)authentication.getPrincipal();
        String uid = principal.getUid();
        Optional userOptional = this.userRepository.findUserByUid(uid);
        User user = (User)userOptional.orElseThrow(() -> new UserNotFoundException(uid));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), URLDecoder.decode(state, "UTF-8"))) {
            throw new ForbiddenException("Non matching user");
        }
        LOG.debug((Object)"In SP redirect link account");
        return this.doRedirect(code, user, this.spFlowRedirectUri, this.spRedirectUrl + "/personal", false, false, null, null, this.spRedirectUrl + "/eppn-already-linked");
    }

    @GetMapping(value={"/idp/oidc/redirect"})
    public ResponseEntity idpFlowRedirect(HttpServletRequest request, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        String decodedState = URLDecoder.decode(state, "UTF-8");
        MultiValueMap params = UriComponentsBuilder.fromHttpUrl((String)("http://localhost?" + decodedState)).build().getQueryParams();
        String id = (String)params.getFirst((Object)"id");
        String encodedUserUid = (String)params.getFirst((Object)"user_uid");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpErrorRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), encodedUserUid)) {
            throw new ForbiddenException("Non matching user");
        }
        boolean validateNames = samlAuthenticationRequest.getAuthenticationContextClassReferences().contains(ACR.VALIDATE_NAMES);
        boolean studentAffiliationRequired = samlAuthenticationRequest.getAuthenticationContextClassReferences().contains(ACR.AFFILIATION_STUDENT);
        LOG.debug((Object)"In IdP redirect link account");
        String location = this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash();
        String charSet = Charset.defaultCharset().name();
        String idpStudentAffiliationRequiredUri = this.idpErrorRedirectUrl + "/affiliation-missing/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        String idpValidNamesRequiredUri = this.idpErrorRedirectUrl + "/valid-name-missing/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        String eppnAlreadyLinkedRequiredUri = this.idpErrorRedirectUrl + "/eppn-already-linked/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        ResponseEntity redirect = this.doRedirect(code, user, this.idpFlowRedirectUri, location, validateNames, studentAffiliationRequired, idpStudentAffiliationRequiredUri, idpValidNamesRequiredUri, eppnAlreadyLinkedRequiredUri);
        StepUpStatus stepUpStatus = redirect.getHeaders().getLocation().toString().contains("affiliation-missing") ? StepUpStatus.MISSING_AFFILIATION : StepUpStatus.IN_STEP_UP;
        samlAuthenticationRequest.setSteppedUp(stepUpStatus);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return redirect;
    }

    private ResponseEntity doRedirect(@RequestParam(value="code") String code, User user, String oidcRedirectUri, String clientRedirectUri, boolean validateNames, boolean studentAffiliationRequired, String idpStudentAffiliationRequiredUri, String idpValidNamesRequiredUri, String eppnAlreadyLinkedRequiredUri) throws UnsupportedEncodingException {
        List<String> affiliations;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"redirect_uri", (Object)oidcRedirectUri);
        map.add((Object)"scope", (Object)"openid");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        1 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        Map body = (Map)this.restTemplate.exchange(this.oidcBaseUrl + "/oidc/token", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        map = new LinkedMultiValueMap();
        map.add((Object)"access_token", (Object)((String)body.get("access_token")));
        request = new HttpEntity((Object)map, (MultiValueMap)headers);
        body = (Map)this.restTemplate.exchange(this.oidcBaseUrl + "/oidc/userinfo", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        String eppn = (String)body.get("eduperson_principal_name");
        String surfCrmId = (String)body.get("surf-crm-id");
        String schacHomeOrganization = (String)body.get("schac_home_organization");
        String givenName = (String)body.get("given_name");
        String familyName = (String)body.get("family_name");
        String institutionIdentifier = StringUtils.hasText((String)surfCrmId) ? surfCrmId : schacHomeOrganization;
        List eduPersonAffiliations = body.getOrDefault("eduperson_affiliation", new ArrayList());
        List<String> eduPersonScopedAffiliations = body.getOrDefault("eduperson_scoped_affiliation", eduPersonAffiliations);
        List<String> list = affiliations = CollectionUtils.isEmpty((Collection)eduPersonScopedAffiliations) ? Arrays.asList("affiliate") : eduPersonScopedAffiliations;
        if (StringUtils.hasText((String)schacHomeOrganization)) {
            Date expiresAt = Date.from(new Date().toInstant().plus(validateNames ? this.expiryValidatedDurationDays : this.expiryNonValidatedDurationDays, ChronoUnit.DAYS));
            List linkedAccounts = user.getLinkedAccounts();
            Optional<LinkedAccount> optionalLinkedAccount = linkedAccounts.stream().filter(linkedAccount -> linkedAccount.getSchacHomeOrganization().equals(schacHomeOrganization)).findFirst();
            if (optionalLinkedAccount.isPresent()) {
                optionalLinkedAccount.get().updateExpiresIn(institutionIdentifier, eppn, givenName, familyName, affiliations, expiresAt);
            } else {
                List optionalUsers;
                if (StringUtils.hasText((String)eppn) && (optionalUsers = this.userRepository.findByLinkedAccounts_EduPersonPrincipalName(eppn)).size() > 0) {
                    String charSet = Charset.defaultCharset().name();
                    eppnAlreadyLinkedRequiredUri = eppnAlreadyLinkedRequiredUri + (eppnAlreadyLinkedRequiredUri.contains("?") ? "&" : "?");
                    eppnAlreadyLinkedRequiredUri = eppnAlreadyLinkedRequiredUri + "email=" + URLEncoder.encode(((User)optionalUsers.get(0)).getEmail(), charSet);
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(eppnAlreadyLinkedRequiredUri))).build();
                }
                linkedAccounts.add(new LinkedAccount(institutionIdentifier, schacHomeOrganization, eppn, givenName, familyName, affiliations, new Date(), expiresAt));
            }
            String action = optionalLinkedAccount.isPresent() ? "updated" : "add";
            String eppnValue = StringUtils.hasText((String)eppn) ? String.format("eppn %s", eppn) : "NO eppn";
            MDCContext.logWithContext((User)user, (String)action, (String)"linked_accounts", (Log)LOG, (String)String.format("Account link with EPPN %s for institution %s with the affiliations %s", eppnValue, institutionIdentifier, affiliations));
            this.userRepository.save((Object)user);
        } else {
            LOG.error((Object)"Account linking requested, but no schacHomeOrganization provided by the IdP");
        }
        boolean hasStudentAffiliation = user.getLinkedAccounts().stream().anyMatch(linkedAccount -> GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)linkedAccount.getEduPersonAffiliations()));
        if (studentAffiliationRequired && !hasStudentAffiliation) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(idpStudentAffiliationRequiredUri))).build();
        }
        boolean hasValidNames = GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        if (validateNames && !hasValidNames) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(idpValidNamesRequiredUri))).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(clientRedirectUri))).build();
    }
}

