/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import myconext.model.LoginStatus;
import myconext.model.StepUpStatus;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.CollectionUtils;

@Document(collection="authentication_requests")
public class SamlAuthenticationRequest {
    @Id
    private String id;
    private String requestId;
    private String issuer;
    private String consumerAssertionServiceURL;
    private String relayState;
    @Indexed
    private String hash;
    private Date expiresIn;
    private String userId;
    private String requesterEntityId;
    private boolean accountLinkingRequired;
    private List<String> authenticationContextClassReferences;
    private boolean passwordOrWebAuthnFlow;
    private boolean rememberMe;
    private String rememberMeValue;
    private StepUpStatus steppedUp = StepUpStatus.NONE;
    private boolean testInstance;
    private LoginStatus loginStatus = LoginStatus.NOT_LOGGED_IN;
    private String verificationCode;
    private int retryVerificationCode;
    private String serviceName;
    private boolean useExternalValidation;

    public SamlAuthenticationRequest(boolean testInstance) {
        this.id = UUID.randomUUID().toString();
        this.testInstance = testInstance;
        this.requesterEntityId = "test";
        this.authenticationContextClassReferences = new ArrayList();
        this.expiresIn = Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneId.systemDefault()).toInstant());
    }

    public SamlAuthenticationRequest(String requestId, String issuer, String consumerAssertionServiceURL, String relayState, String requesterEntityId, boolean accountLinkingRequired, List<String> authenticationContextClassReferences) {
        this.id = UUID.randomUUID().toString();
        this.requestId = requestId;
        this.issuer = issuer;
        this.consumerAssertionServiceURL = consumerAssertionServiceURL;
        this.relayState = relayState;
        this.expiresIn = Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneId.systemDefault()).toInstant());
        this.requesterEntityId = requesterEntityId;
        this.accountLinkingRequired = accountLinkingRequired;
        this.authenticationContextClassReferences = authenticationContextClassReferences;
        this.invariant();
    }

    @Transient
    private void invariant() {
        if (this.isAccountLinkingRequired() && CollectionUtils.isEmpty((Collection)this.authenticationContextClassReferences)) {
            throw new IllegalArgumentException("authenticationContextClassReference is required when account linking is required");
        }
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public void setRememberMeValue(String rememberMeValue) {
        this.rememberMeValue = rememberMeValue;
    }

    public void setPasswordOrWebAuthnFlow(boolean passwordOrWebAuthnFlow) {
        this.passwordOrWebAuthnFlow = passwordOrWebAuthnFlow;
    }

    public void setSteppedUp(StepUpStatus steppedUp) {
        this.steppedUp = steppedUp;
    }

    public void setLoginStatus(LoginStatus loginStatus) {
        this.loginStatus = loginStatus;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setRetryVerificationCode(int retryVerificationCode) {
        this.retryVerificationCode = retryVerificationCode;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setUseExternalValidation(boolean useExternalValidation) {
        this.useExternalValidation = useExternalValidation;
    }

    public String getId() {
        return this.id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getConsumerAssertionServiceURL() {
        return this.consumerAssertionServiceURL;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getHash() {
        return this.hash;
    }

    public Date getExpiresIn() {
        return this.expiresIn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getRequesterEntityId() {
        return this.requesterEntityId;
    }

    public boolean isAccountLinkingRequired() {
        return this.accountLinkingRequired;
    }

    public List<String> getAuthenticationContextClassReferences() {
        return this.authenticationContextClassReferences;
    }

    public boolean isPasswordOrWebAuthnFlow() {
        return this.passwordOrWebAuthnFlow;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public String getRememberMeValue() {
        return this.rememberMeValue;
    }

    public StepUpStatus getSteppedUp() {
        return this.steppedUp;
    }

    public boolean isTestInstance() {
        return this.testInstance;
    }

    public LoginStatus getLoginStatus() {
        return this.loginStatus;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public int getRetryVerificationCode() {
        return this.retryVerificationCode;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isUseExternalValidation() {
        return this.useExternalValidation;
    }

    public SamlAuthenticationRequest() {
    }
}

