/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import myconext.api.UserController;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.ServiceProviderResolver;
import myconext.model.LinkedAccount;
import myconext.model.LoginStatus;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.StepUpStatus;
import myconext.model.User;
import myconext.model.UserLogin;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserLoginRepository;
import myconext.repository.UserRepository;
import myconext.security.ACR;
import myconext.security.CookieResolver;
import myconext.security.VerificationCodeGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SamlMessageStore;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.provider.identity.IdentityProviderService;
import org.springframework.security.saml.provider.identity.IdpAuthenticationRequestFilter;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.saml2.Saml2Object;
import org.springframework.security.saml.saml2.attribute.Attribute;
import org.springframework.security.saml.saml2.attribute.AttributeNameFormat;
import org.springframework.security.saml.saml2.authentication.Assertion;
import org.springframework.security.saml.saml2.authentication.AuthenticationContextClassReference;
import org.springframework.security.saml.saml2.authentication.AuthenticationRequest;
import org.springframework.security.saml.saml2.authentication.AuthenticationStatement;
import org.springframework.security.saml.saml2.authentication.Issuer;
import org.springframework.security.saml.saml2.authentication.Response;
import org.springframework.security.saml.saml2.authentication.Scoping;
import org.springframework.security.saml.saml2.authentication.Status;
import org.springframework.security.saml.saml2.authentication.StatusCode;
import org.springframework.security.saml.saml2.metadata.Binding;
import org.springframework.security.saml.saml2.metadata.Endpoint;
import org.springframework.security.saml.saml2.metadata.NameId;
import org.springframework.security.saml.saml2.metadata.ServiceProviderMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuestIdpAuthenticationRequestFilter
extends IdpAuthenticationRequestFilter {
    public static final String GUEST_IDP_REMEMBER_ME_COOKIE_NAME = "guest-idp-remember-me";
    public static final String TRACKING_DEVICE_COOKIE_NAME = "TRACKING_DEVICE";
    public static final String BROWSER_SESSION_COOKIE_NAME = "BROWSER_SESSION";
    public static final String REGISTER_MODUS_COOKIE_NAME = "REGISTER_MODUS";
    private static final Log LOG = LogFactory.getLog(GuestIdpAuthenticationRequestFilter.class);
    private final SamlRequestMatcher ssoSamlRequestMatcher;
    private final SamlRequestMatcher magicSamlRequestMatcher;
    private final SamlRequestMatcher continueAfterloginSamlRequestMatcher;
    private final String redirectUrl;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final UserLoginRepository userLoginRepository;
    private final List<String> accountLinkingContextClassReferences;
    private final int rememberMeMaxAge;
    private final boolean secureCookie;
    private final String magicLinkUrl;
    private final MailBox mailBox;
    private final ServiceProviderResolver serviceProviderResolver;
    private final ExecutorService executor;

    public GuestIdpAuthenticationRequestFilter(SamlProviderProvisioning<IdentityProviderService> provisioning, SamlMessageStore<Assertion, HttpServletRequest> assertionStore, String redirectUrl, ServiceProviderResolver serviceProviderResolver, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, UserLoginRepository userLoginRepository, int rememberMeMaxAge, boolean secureCookie, String magicLinkUrl, MailBox mailBox) {
        super(provisioning, assertionStore);
        this.ssoSamlRequestMatcher = new SamlRequestMatcher(provisioning, "SSO");
        this.magicSamlRequestMatcher = new SamlRequestMatcher(provisioning, "magic");
        this.continueAfterloginSamlRequestMatcher = new SamlRequestMatcher(provisioning, "continue");
        this.redirectUrl = redirectUrl;
        this.serviceProviderResolver = serviceProviderResolver;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.userLoginRepository = userLoginRepository;
        this.accountLinkingContextClassReferences = ACR.all();
        this.rememberMeMaxAge = rememberMeMaxAge;
        this.secureCookie = secureCookie;
        this.magicLinkUrl = magicLinkUrl;
        this.mailBox = mailBox;
        this.executor = Executors.newSingleThreadExecutor();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.ssoSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting SSO filter");
            this.sso(request, response);
            return;
        }
        if (this.magicSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting magic filter");
            this.magic(request, response);
            return;
        }
        if (this.continueAfterloginSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting continue after login filter");
            this.continueAfterLogin(request, response);
            return;
        }
        super.doFilterInternal(request, response, filterChain);
    }

    private void sso(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IdentityProviderService provider = (IdentityProviderService)this.getProvisioning().getHostedProvider();
        String samlRequest = request.getParameter("SAMLRequest");
        String relayState = request.getParameter("RelayState");
        if (!StringUtils.hasText((String)samlRequest)) {
            return;
        }
        AuthenticationRequest authenticationRequest = (AuthenticationRequest)provider.fromXml(samlRequest, true, this.isDeflated(request), AuthenticationRequest.class);
        provider.validate((Saml2Object)authenticationRequest);
        String requesterEntityId = this.requesterId(authenticationRequest);
        String issuer = authenticationRequest.getIssuer().getValue();
        List authenticationContextClassReferenceValues = this.getAuthenticationContextClassReferenceValues(authenticationRequest);
        boolean accountLinkingRequired = this.accountLinkingContextClassReferences.stream().anyMatch(authenticationContextClassReferenceValues::contains);
        SamlAuthenticationRequest samlAuthenticationRequest = new SamlAuthenticationRequest(authenticationRequest.getId(), issuer, authenticationRequest.getAssertionConsumerService().getLocation(), relayState, StringUtils.hasText((String)requesterEntityId) ? requesterEntityId : "", accountLinkingRequired, authenticationContextClassReferenceValues);
        Optional rememberMeCookieOptional = CookieResolver.cookieByName((HttpServletRequest)request, (String)"guest-idp-remember-me");
        Optional userRememberedOptional = rememberMeCookieOptional.map(arg_0 -> this.userFromCookie(arg_0)).flatMap(Function.identity());
        Optional userFromAuthentication = this.userFromAuthentication();
        User previousAuthenticatedUser = userRememberedOptional.orElse(userFromAuthentication.orElse(null));
        String serviceName = this.getServiceName(request, samlAuthenticationRequest);
        samlAuthenticationRequest.setServiceName(serviceName);
        samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        if (previousAuthenticatedUser != null && !authenticationRequest.isForceAuth().booleanValue()) {
            if (accountLinkingRequired && !GuestIdpAuthenticationRequestFilter.isUserVerifiedByInstitution((User)previousAuthenticatedUser, (List)authenticationContextClassReferenceValues)) {
                boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)previousAuthenticatedUser.allEduPersonAffiliations());
                String explanation = ACR.explanationKeyWord((List)authenticationContextClassReferenceValues, (boolean)hasStudentAffiliation);
                samlAuthenticationRequest.setUserId(previousAuthenticatedUser.getId());
                samlAuthenticationRequest.setHash(UserController.hash());
                this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
                this.addBrowserIdentificationCookie(response);
                response.sendRedirect(this.redirectUrl + "/stepup/" + samlAuthenticationRequest.getId() + "?explanation=" + explanation);
            } else {
                ServiceProviderMetadata serviceProviderMetadata = (ServiceProviderMetadata)provider.getRemoteProvider(samlAuthenticationRequest.getIssuer());
                this.sendAssertion(request, response, samlAuthenticationRequest, previousAuthenticatedUser, provider, serviceProviderMetadata, authenticationRequest);
            }
        } else {
            this.addBrowserIdentificationCookie(response);
            Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"REGISTER_MODUS");
            LOG.debug((Object)("Cookie REGISTER_MODUS_COOKIE_NAME is: " + optionalCookie.map(Cookie::getValue).orElse("Null")));
            String modus = optionalCookie.map(c -> "&modus=cr").orElse("");
            String stepUp = accountLinkingRequired ? "&stepup=true" : "";
            String separator = StringUtils.hasText((String)modus) || StringUtils.hasText((String)stepUp) ? "?n=1" : "";
            response.sendRedirect(this.redirectUrl + "/login/" + samlAuthenticationRequest.getId() + separator + modus + stepUp);
        }
    }

    private String getServiceName(HttpServletRequest request, SamlAuthenticationRequest samlAuthenticationRequest) {
        String lang = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(cookie -> cookie.getValue()).orElse("en");
        Optional optionalServiceProvider = this.serviceProviderResolver.resolve(samlAuthenticationRequest.getRequesterEntityId());
        String serviceName = optionalServiceProvider.map(serviceProvider -> lang.equals("en") ? serviceProvider.getName() : serviceProvider.getNameNl()).orElse(samlAuthenticationRequest.getRequesterEntityId());
        return serviceName;
    }

    public static boolean isUserVerifiedByInstitution(User user, List<String> authenticationContextClassReferenceValues) {
        Date now = new Date();
        List linkedAccounts = user.getLinkedAccounts();
        if (CollectionUtils.isEmpty((Collection)linkedAccounts)) {
            return false;
        }
        authenticationContextClassReferenceValues = authenticationContextClassReferenceValues == null ? Collections.emptyList() : authenticationContextClassReferenceValues;
        List nonExpiredLinkedAccounts = linkedAccounts.stream().filter(linkedAccount -> now.toInstant().isBefore(linkedAccount.getExpiresAt().toInstant())).collect(Collectors.toList());
        boolean atLeastOneNotExpired = !CollectionUtils.isEmpty(nonExpiredLinkedAccounts);
        boolean hasRequiredStudentAffiliation = !authenticationContextClassReferenceValues.contains(ACR.AFFILIATION_STUDENT) || nonExpiredLinkedAccounts.stream().anyMatch(linkedAccount -> GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)linkedAccount.getEduPersonAffiliations()));
        boolean hasValidatedNames = !authenticationContextClassReferenceValues.contains(ACR.VALIDATE_NAMES) || GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        return atLeastOneNotExpired && hasRequiredStudentAffiliation && hasValidatedNames;
    }

    public static boolean hasValidatedName(User user) {
        return GuestIdpAuthenticationRequestFilter.hasValidatedName((List)user.getLinkedAccounts());
    }

    private static boolean hasValidatedName(List<LinkedAccount> linkedAccounts) {
        return linkedAccounts.stream().anyMatch(LinkedAccount::areNamesValidated);
    }

    public static boolean hasRequiredStudentAffiliation(List<String> affiliations) {
        return !CollectionUtils.isEmpty(affiliations) && affiliations.stream().anyMatch(affiliation -> affiliation.startsWith("student@"));
    }

    private List<String> getAuthenticationContextClassReferenceValues(AuthenticationRequest authenticationRequest) {
        List authenticationContextClassReferences = authenticationRequest.getAuthenticationContextClassReferences();
        if (authenticationContextClassReferences == null) {
            return Collections.emptyList();
        }
        return authenticationContextClassReferences.stream().map(AuthenticationContextClassReference::getValue).collect(Collectors.toList());
    }

    private Optional<User> userFromCookie(Cookie remembered) {
        LOG.debug((Object)"Returning user from rememberMe cookie");
        return this.authenticationRequestRepository.findByRememberMeValue(remembered.getValue()).map(req -> this.userRepository.findById((Object)req.getUserId())).flatMap(Function.identity());
    }

    private Optional<User> userFromAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        LOG.debug((Object)("Attempting user authentication from security context: " + authentication));
        if (authentication != null && authentication.isAuthenticated() && authentication instanceof UsernamePasswordAuthenticationToken) {
            User user = (User)authentication.getPrincipal();
            return this.userRepository.findById((Object)user.getId());
        }
        return Optional.empty();
    }

    private void addBrowserIdentificationCookie(HttpServletResponse response) {
        response.setHeader("Set-Cookie", "BROWSER_SESSION=true; SameSite=Lax" + (this.secureCookie ? "; Secure" : ""));
    }

    private boolean isDeflated(HttpServletRequest request) {
        return HttpMethod.GET.name().equalsIgnoreCase(request.getMethod());
    }

    private String requesterId(AuthenticationRequest authenticationRequest) {
        Issuer issuer = authenticationRequest.getIssuer();
        String issuerValue = issuer != null ? issuer.getValue() : "";
        Scoping scoping = authenticationRequest.getScoping();
        List requesterIds = scoping != null ? scoping.getRequesterIds() : null;
        return CollectionUtils.isEmpty((Collection)requesterIds) ? issuerValue : (String)requesterIds.get(0);
    }

    private void magic(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String hash = request.getParameter("h");
        if (!StringUtils.hasText((String)hash)) {
            Map<String, String> headerMap = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(headerName -> headerName, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            LOG.warn((Object)("Magic endpoint without 'h' parameter. Headers: " + headerMap));
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByHash(hash);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        boolean accountLinkingRequired = samlAuthenticationRequest.isAccountLinkingRequired() && !GuestIdpAuthenticationRequestFilter.isUserVerifiedByInstitution((User)user, (List)authenticationContextClassReferences);
        String charSet = Charset.defaultCharset().name();
        boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
        String explanation = ACR.explanationKeyWord((List)authenticationContextClassReferences, (boolean)hasStudentAffiliation);
        if (accountLinkingRequired && StepUpStatus.NONE.equals((Object)samlAuthenticationRequest.getSteppedUp())) {
            response.sendRedirect(this.redirectUrl + "/stepup/" + samlAuthenticationRequest.getId() + "?explanation=" + explanation);
            return;
        }
        Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"BROWSER_SESSION");
        if (!optionalCookie.isPresent()) {
            samlAuthenticationRequest.setLoginStatus(LoginStatus.LOGGED_IN_DIFFERENT_DEVICE);
            samlAuthenticationRequest.setVerificationCode(VerificationCodeGenerator.generate());
            if (this.incrementVerificationCodeRetry(samlAuthenticationRequest)) {
                response.sendRedirect(this.redirectUrl + "/max-attempts");
                return;
            }
            this.mailBox.sendVerificationCode(user, samlAuthenticationRequest.getVerificationCode());
            response.sendRedirect(this.redirectUrl + "/success");
            return;
        }
        boolean proceed = this.checkStepUp(response, hash, samlAuthenticationRequest, user, charSet, explanation);
        if (!proceed) {
            return;
        }
        samlAuthenticationRequest.setLoginStatus(LoginStatus.LOGGED_IN_SAME_DEVICE);
        this.doSendAssertion(request, response, samlAuthenticationRequest, user);
    }

    private boolean incrementVerificationCodeRetry(SamlAuthenticationRequest samlAuthenticationRequest) {
        int retryVerificationCode = samlAuthenticationRequest.getRetryVerificationCode();
        samlAuthenticationRequest.setRetryVerificationCode(retryVerificationCode + 1);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return retryVerificationCode > 2;
    }

    private boolean checkStepUp(HttpServletResponse response, String hash, SamlAuthenticationRequest samlAuthenticationRequest, User user, String charSet, String explanation) throws IOException {
        boolean missingValidName;
        boolean inStepUpFlow = StepUpStatus.IN_STEP_UP.equals((Object)samlAuthenticationRequest.getSteppedUp());
        boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        boolean missingStudentAffiliation = authenticationContextClassReferences.contains(ACR.AFFILIATION_STUDENT) && !hasStudentAffiliation;
        boolean bl = missingValidName = authenticationContextClassReferences.contains(ACR.VALIDATE_NAMES) && !GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        if (user.isNewUser()) {
            user.setNewUser(false);
            this.userRepository.save((Object)user);
            MDCContext.logWithContext((User)user, (String)"add", (String)"account", (Log)LOG, (String)"Saving user after new registration and magic link");
            this.mailBox.sendAccountConfirmation(user);
            if (inStepUpFlow) {
                this.finishStepUp(samlAuthenticationRequest);
            }
            if (missingStudentAffiliation || missingValidName) {
                return true;
            }
            String url = this.redirectUrl + "/confirm?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet) + "&email=" + URLEncoder.encode(user.getEmail(), charSet);
            if (!StepUpStatus.NONE.equals((Object)samlAuthenticationRequest.getSteppedUp())) {
                url = url + "&explanation=" + explanation;
            }
            response.sendRedirect(url);
            return false;
        }
        if (inStepUpFlow) {
            this.finishStepUp(samlAuthenticationRequest);
            if (missingStudentAffiliation || missingValidName) {
                return true;
            }
            response.sendRedirect(this.redirectUrl + "/confirm-stepup?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet) + "&explanation=" + explanation);
            return false;
        }
        return true;
    }

    private void continueAfterLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("id");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findById((Object)id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String verificationCode = request.getParameter("verificationCode");
        if (!StringUtils.hasText((String)verificationCode) || !verificationCode.equals(samlAuthenticationRequest.getVerificationCode())) {
            if (this.incrementVerificationCodeRetry(samlAuthenticationRequest)) {
                response.sendRedirect(this.redirectUrl + "/max-attempts");
                return;
            }
            String currentUrl = URLDecoder.decode(request.getParameter("currentUrl"), Charset.defaultCharset().name());
            response.sendRedirect(currentUrl + "&mismatch=true");
            return;
        }
        if (samlAuthenticationRequest.getLoginStatus().equals((Object)LoginStatus.NOT_LOGGED_IN)) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        String charSet = Charset.defaultCharset().name();
        boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        String explanation = ACR.explanationKeyWord((List)authenticationContextClassReferences, (boolean)hasStudentAffiliation);
        boolean proceed = this.checkStepUp(response, samlAuthenticationRequest.getHash(), samlAuthenticationRequest, user, charSet, explanation);
        if (!proceed) {
            return;
        }
        this.doSendAssertion(request, response, samlAuthenticationRequest, user);
    }

    private void doSendAssertion(HttpServletRequest request, HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest, User user) {
        samlAuthenticationRequest.setHash(null);
        LOG.debug((Object)String.format("Disabling magic link after use by %s ", user.getUsername()));
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        IdentityProviderService provider = (IdentityProviderService)this.getProvisioning().getHostedProvider();
        ServiceProviderMetadata serviceProviderMetadata = (ServiceProviderMetadata)provider.getRemoteProvider(samlAuthenticationRequest.getIssuer());
        AuthenticationRequest authenticationRequest = new AuthenticationRequest();
        authenticationRequest.setId(samlAuthenticationRequest.getRequestId());
        authenticationRequest.setAssertionConsumerService(new Endpoint().setLocation(samlAuthenticationRequest.getConsumerAssertionServiceURL()));
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        if (samlAuthenticationRequest.isRememberMe()) {
            LOG.info((Object)String.format("Remember me functionality activated for %s ", user.getUsername()));
            this.addRememberMeCookie(response, samlAuthenticationRequest);
        }
        MDCContext.logLoginWithContext((User)user, (String)"magiclink", (boolean)true, (Log)LOG, (String)"Successfully logged in with magiclink");
        this.sendAssertion(request, response, samlAuthenticationRequest, user, provider, serviceProviderMetadata, authenticationRequest);
    }

    private void finishStepUp(SamlAuthenticationRequest samlAuthenticationRequest) {
        samlAuthenticationRequest.setSteppedUp(StepUpStatus.FINISHED_STEP_UP);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
    }

    private void addRememberMeCookie(HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest) {
        Cookie cookie = new Cookie("guest-idp-remember-me", samlAuthenticationRequest.getRememberMeValue());
        cookie.setMaxAge(this.rememberMeMaxAge);
        cookie.setSecure(this.secureCookie);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    private void addTrackingCookie(HttpServletRequest request, HttpServletResponse response, User user) {
        Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"TRACKING_DEVICE");
        String trackingUuid = user.getTrackingUuid();
        if (trackingUuid == null) {
            user.setTrackingUuid(UUID.randomUUID().toString());
            this.userRepository.save((Object)user);
        }
        if (!optionalCookie.isPresent() || !user.getTrackingUuid().equalsIgnoreCase(((Cookie)optionalCookie.get()).getValue())) {
            Cookie cookie = new Cookie("TRACKING_DEVICE", user.getTrackingUuid());
            cookie.setMaxAge(0x7FFFFFFE);
            cookie.setSecure(this.secureCookie);
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
            Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(s -> s, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            headers.put("ipAddress", request.getRemoteAddr());
            this.executor.submit(() -> (UserLogin)this.userLoginRepository.save((Object)new UserLogin(user, headers)));
        }
    }

    private void sendAssertion(HttpServletRequest request, HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest, User user, IdentityProviderService provider, ServiceProviderMetadata serviceProviderMetadata, AuthenticationRequest authenticationRequest) {
        String relayState = samlAuthenticationRequest.getRelayState();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        Assertion assertion = provider.assertion(serviceProviderMetadata, authenticationRequest, user.getUid(), NameId.PERSISTENT);
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        this.attributes(user, requesterEntityId, authenticationContextClassReferences).forEach(arg_0 -> ((Assertion)assertion).addAttribute(arg_0));
        Response samlResponse = provider.response(authenticationRequest, assertion, serviceProviderMetadata);
        if (samlAuthenticationRequest.isAccountLinkingRequired()) {
            boolean missingValidName;
            boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
            boolean missingStudentAffiliation = authenticationContextClassReferences.contains(ACR.AFFILIATION_STUDENT) && !hasStudentAffiliation;
            boolean bl = missingValidName = authenticationContextClassReferences.contains(ACR.VALIDATE_NAMES) && !GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
            if (missingStudentAffiliation || missingValidName) {
                String msg = missingValidName ? "The requesting service has indicated that the authenticated user is required to have a first_name and last_name. Your institution has not provided those attributes." : "The requesting service has indicated that the authenticated user is required to have an affiliation Student. Your institution has not provided this affiliation.";
                samlResponse.setStatus(new Status().setCode(StatusCode.NO_AUTH_CONTEXT).setMessage(msg).setDetail(msg));
            } else {
                ((AuthenticationStatement)((Assertion)samlResponse.getAssertions().get(0)).getAuthenticationStatements().get(0)).getAuthenticationContext().setClassReference(AuthenticationContextClassReference.fromUrn((String)ACR.selectACR((List)authenticationContextClassReferences, (boolean)hasStudentAffiliation)));
            }
        } else if (!CollectionUtils.isEmpty((Collection)authenticationContextClassReferences)) {
            String msg = String.format("The specified authentication context requirements '%s' cannot be met by the responder.", String.join((CharSequence)", ", authenticationContextClassReferences));
            samlResponse.setStatus(new Status().setCode(StatusCode.NO_AUTH_CONTEXT).setMessage(msg).setDetail(msg));
        }
        Endpoint acsUrl = provider.getPreferredEndpoint(serviceProviderMetadata.getServiceProvider().getAssertionConsumerService(), Binding.POST, -1);
        String encoded = provider.toEncodedXml((Saml2Object)samlResponse, false);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("action", acsUrl.getLocation());
        model.put("SAMLResponse", encoded);
        if (StringUtils.hasText((String)relayState)) {
            model.put("RelayState", HtmlUtils.htmlEscape((String)relayState));
        }
        Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"BROWSER_SESSION");
        optionalCookie.ifPresent(cookie -> {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        });
        this.addTrackingCookie(request, response, user);
        this.processHtml(request, response, this.getPostBindingTemplate(), model);
    }

    protected List<Attribute> attributes(User user, String requesterEntityId, List<String> authenticationContextClassReferences) {
        Optional<LinkedAccount> first;
        List linkedAccounts = this.safeSortedAffiliations(user);
        String givenName = user.getGivenName();
        String familyName = user.getFamilyName();
        if (authenticationContextClassReferences.contains(ACR.VALIDATE_NAMES) && !CollectionUtils.isEmpty((Collection)linkedAccounts) && (first = linkedAccounts.stream().filter(LinkedAccount::areNamesValidated).findFirst()).isPresent()) {
            LinkedAccount linkedAccount2 = first.get();
            givenName = linkedAccount2.getGivenName();
            familyName = linkedAccount2.getFamilyName();
        }
        String displayName = String.format("%s %s", givenName, familyName);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(Arrays.asList(this.attribute("urn:mace:dir:attribute-def:cn", new String[]{displayName}), this.attribute("urn:mace:dir:attribute-def:displayName", new String[]{displayName}), this.attribute("urn:mace:dir:attribute-def:eduPersonPrincipalName", new String[]{user.getEduPersonPrincipalName()}), this.attribute("urn:mace:dir:attribute-def:givenName", new String[]{givenName}), this.attribute("urn:mace:dir:attribute-def:mail", new String[]{user.getEmail()}), this.attribute("urn:mace:dir:attribute-def:sn", new String[]{familyName}), this.attribute("urn:mace:dir:attribute-def:uid", new String[]{user.getUid()}), this.attribute("urn:mace:terena.org:attribute-def:schacHomeOrganization", new String[]{user.getSchacHomeOrganization()})));
        String eduIDValue = user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, this.serviceProviderResolver);
        this.userRepository.save((Object)user);
        attributes.add(this.attribute("urn:mace:eduid.nl:1.1", new String[]{eduIDValue}));
        user.getAttributes().forEach((key, value) -> attributes.add(this.attribute(key, value.toArray(new String[0]))));
        List<String> scopedAffiliations = linkedAccounts.stream().map(linkedAccount -> linkedAccount.getEduPersonAffiliations().stream().map(affiliation -> affiliation.contains("@") ? affiliation : String.format("%s@%s", affiliation, linkedAccount.getSchacHomeOrganization())).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        scopedAffiliations.add("affiliate@eduid.nl");
        attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonScopedAffiliation", scopedAffiliations.toArray(new String[0])));
        List<String> affiliations = scopedAffiliations.stream().map(affiliation -> affiliation.substring(0, affiliation.indexOf("@"))).distinct().collect(Collectors.toList());
        attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonAffiliation", affiliations.toArray(new String[0])));
        return attributes;
    }

    private List<LinkedAccount> safeSortedAffiliations(User user) {
        List linkedAccounts = user.linkedAccountsSorted();
        List<LinkedAccount> linkedAccountsEmptyAffiliations = linkedAccounts.stream().filter(linkedAccount -> CollectionUtils.isEmpty((Collection)linkedAccount.getEduPersonAffiliations())).collect(Collectors.toList());
        linkedAccountsEmptyAffiliations.forEach(linkedAccount -> linkedAccount.setEduPersonAffiliations(Collections.singletonList("affiliation@" + linkedAccount.getSchacHomeOrganization())));
        if (!linkedAccountsEmptyAffiliations.isEmpty()) {
            this.userRepository.save((Object)user);
        }
        return user.linkedAccountsSorted();
    }

    private Attribute attribute(String name, String ... value) {
        return new Attribute().setName(name).setNameFormat(AttributeNameFormat.URI).addValues((Object[])value);
    }
}

