/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class IdPMetaDataResolver {
    private static final Log LOG = LogFactory.getLog(IdPMetaDataResolver.class);
    private final Resource metaDataResource;
    private Set<String> domainNames = new HashSet();

    @Autowired
    public IdPMetaDataResolver(@Value(value="${cron.metadata-resolver-url}") Resource metaDataResource) {
        this.metaDataResource = metaDataResource;
    }

    @Scheduled(initialDelayString="${cron.metadata-resolver-initial-delay-milliseconds}", fixedRateString="${cron.metadata-resolver-fixed-rate-milliseconds}")
    public void resolveIdpMetaData() {
        long start = System.currentTimeMillis();
        HashSet<String> newDomainNames = new HashSet<String>();
        try {
            XMLStreamReader reader = this.getXMLStreamReader(this.metaDataResource);
            while (reader.hasNext()) {
                String elementText;
                if (reader.next() != 1 || !"Scope".equals(reader.getLocalName()) || !StringUtils.hasText((String)(elementText = reader.getElementText()))) continue;
                newDomainNames.add(elementText.trim().replaceAll("\\n\\t ", "").toLowerCase());
            }
            this.domainNames = newDomainNames;
            LOG.info((Object)String.format("Parsed %s institution domain names from %s in %s ms", this.domainNames.size(), this.metaDataResource.getDescription(), System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in resolveIdpMetaData", (Throwable)e);
        }
    }

    public Set<String> getDomainNames() {
        if (this.domainNames.isEmpty()) {
            this.resolveIdpMetaData();
        }
        return this.domainNames;
    }

    private XMLStreamReader getXMLStreamReader(Resource xml) throws IOException, XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory.createXMLStreamReader(xml.getInputStream());
    }
}

