/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.github.cloudyrock.mongock.ChangeLog;
import com.github.cloudyrock.mongock.ChangeSet;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator.impl.MongockTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import myconext.manage.ServiceProviderResolver;
import myconext.model.EduID;
import myconext.model.PublicKeyCredentials;
import myconext.model.ServiceProvider;
import myconext.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

@ChangeLog(order="001")
public class Migrations {
    private static final Log LOG = LogFactory.getLog(Migrations.class);

    @ChangeSet(order="001", id="transformUserPublicKeyCredentials", author="okke.harsta@surf.nl")
    public void transformUserPublicKeyCredentials(MongockTemplate mongoTemplate) {
        List usersAsMaps = mongoTemplate.findAll(Map.class, "users");
        usersAsMaps.forEach(userAsMap -> {
            Map credentials;
            Object o;
            if (userAsMap.containsKey("publicKeyCredentials") && (o = userAsMap.get("publicKeyCredentials")) instanceof Map && !(credentials = (Map)userAsMap.get("publicKeyCredentials")).containsKey("name")) {
                List publicKeyCredentials = credentials.entrySet().stream().map(entry -> new PublicKeyCredentials((String)entry.getKey(), (String)entry.getValue(), "key-" + UUID.randomUUID().toString())).collect(Collectors.toList());
                userAsMap.put("publicKeyCredentials", publicKeyCredentials);
                mongoTemplate.save(userAsMap, "users");
            }
        });
    }

    @ChangeSet(order="002", id="transformEduIdPerServiceProvider", author="okke.harsta@surf.nl")
    public void transformEduIdPerServiceProvider(MongockTemplate mongoTemplate) {
        List usersAsMaps = mongoTemplate.findAll(Map.class, "users");
        usersAsMaps.forEach(userAsMap -> {
            if (userAsMap.containsKey("eduIdPerServiceProvider")) {
                Map eduIdPerServiceProvider = (Map)userAsMap.get("eduIdPerServiceProvider");
                ArrayList eduIDS = new ArrayList();
                eduIdPerServiceProvider.forEach((serviceProviderEntityId, values) -> eduIDS.add(new EduID(serviceProviderEntityId, values)));
                userAsMap.put("eduIDS", eduIDS);
                userAsMap.remove("eduIdPerServiceProvider");
                mongoTemplate.save(userAsMap, "users");
            }
        });
    }

    @ChangeSet(order="003", id="bugfixForDotReplacement", author="okke.harsta@surf.nl")
    public void bugfixForDotReplacement(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            this.mergeEduIDs(user);
            mongoTemplate.save(user);
        });
    }

    @ChangeSet(order="004", id="addServiceProviderInstitutionGuid", author="okke.harsta@surf.nl")
    public void addServiceProviderInstitutionGuid(MongockTemplate mongoTemplate, ServiceProviderResolver serviceProviderResolver) {
        List users = mongoTemplate.findAll(User.class, "users");
        serviceProviderResolver.refresh();
        users.forEach(user -> user.getEduIDS().forEach(eduID -> {
            Optional optionalServiceProvider = serviceProviderResolver.resolve(eduID.getServiceProviderEntityId());
            if (optionalServiceProvider.isPresent()) {
                ServiceProvider serviceProvider = (ServiceProvider)optionalServiceProvider.get();
                if (StringUtils.hasText((String)serviceProvider.getInstitutionGuid())) {
                    eduID.updateServiceProvider(serviceProvider);
                    mongoTemplate.save(user);
                    LOG.info((Object)("Added institutionGuid to " + eduID.getServiceProviderEntityId()));
                }
            } else {
                LOG.info((Object)("Unknown serviceProvider: " + eduID.getServiceProviderEntityId()));
            }
        }));
    }

    @ChangeSet(order="005", id="addTrackingGuid", author="okke.harsta@surf.nl")
    public void addTrackingGuid(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            if (!StringUtils.hasText((String)user.getTrackingUuid())) {
                user.setTrackingUuid(UUID.randomUUID().toString());
                mongoTemplate.save(user);
            }
        });
    }

    protected User mergeEduIDs(User user) {
        List eduIDS = user.getEduIDS();
        ArrayList copiedEduIDs = new ArrayList(eduIDS);
        List<EduID> eduIDSFiltered = eduIDS.stream().filter(eduID -> {
            String entityId = eduID.getServiceProviderEntityId();
            boolean remove = false;
            boolean hasDot = entityId.contains(".");
            if (hasDot) {
                String oldEntityId = entityId.replaceAll("\\.", "@");
                remove = copiedEduIDs.stream().anyMatch(someEduID -> someEduID.getServiceProviderEntityId().equals(oldEntityId));
            }
            if (remove) {
                LOG.info((Object)("Removing " + eduID + " for user: " + user.getEmail()));
            }
            return !remove;
        }).collect(Collectors.toList());
        eduIDSFiltered.forEach(eduID -> eduID.replaceAtWithDot());
        user.setEduIDS(eduIDSFiltered);
        return user;
    }
}

