/*
 * Decompiled with CFR 0.152.
 */
package myconext.sms;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import myconext.sms.SMSService;
import org.apache.commons.io.IOUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SMSServiceImpl
implements SMSService {
    private final String url;
    private final String template;
    private final RestTemplate restTemplate = new RestTemplate();
    private final MultiValueMap<String, String> headers = new HttpHeaders();

    public SMSServiceImpl(String url, String bearer) {
        this.url = url;
        this.template = IOUtil.toString((InputStream)new ClassPathResource("sms/template.txt").getInputStream());
        this.headers.add((Object)"Accept", (Object)"application/json");
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.headers.add((Object)"Authorization", (Object)("Bearer " + bearer));
    }

    public void send(String mobile, String code) {
        Map<String, List<String>> body = Map.of("encoding", "auto", "body", String.format(this.template, code), "route", "business", "originator", "eduID", "recipients", List.of(mobile));
        RequestEntity requestEntity = new RequestEntity(body, this.headers, HttpMethod.POST, URI.create(this.url));
        this.restTemplate.exchange(requestEntity, Void.class);
    }
}

