/*
 * Decompiled with CFR 0.152.
 */
package myconext.tiqr;

import com.google.zxing.WriterException;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import myconext.crypto.HashGenerator;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.manage.ServiceProviderResolver;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.User;
import myconext.repository.AuthenticationRepository;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.EnrollmentRepository;
import myconext.repository.RegistrationRepository;
import myconext.repository.UserRepository;
import myconext.security.CookieResolver;
import myconext.security.VerificationCodeGenerator;
import myconext.sms.SMSService;
import myconext.tiqr.RateLimitEnforcer;
import myconext.tiqr.TiqrConfiguration;
import myconext.tiqr.TiqrRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;
import tiqr.org.DefaultTiqrService;
import tiqr.org.TiqrException;
import tiqr.org.TiqrService;
import tiqr.org.model.Authentication;
import tiqr.org.model.AuthenticationData;
import tiqr.org.model.AuthenticationStatus;
import tiqr.org.model.Enrollment;
import tiqr.org.model.EnrollmentStatus;
import tiqr.org.model.MetaData;
import tiqr.org.model.Registration;
import tiqr.org.model.Service;
import tiqr.org.secure.QRCodeGenerator;

@RestController
@RequestMapping(value={"/tiqr"})
public class TiqrController {
    private static final Log LOG = LogFactory.getLog(TiqrController.class);
    private final TiqrService tiqrService;
    private final TiqrConfiguration tiqrConfiguration;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final EnrollmentRepository enrollmentRepository;
    private final ServiceProviderResolver serviceProviderResolver;
    private final SMSService smsService;
    private final String magicLinkUrl;
    private final RegistrationRepository registrationRepository;
    private final RateLimitEnforcer rateLimitEnforcer;

    @Autowired
    public TiqrController(@Value(value="${tiqr_configuration}") Resource resource, EnrollmentRepository enrollmentRepository, RegistrationRepository registrationRepository, AuthenticationRepository authenticationRepository, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, ServiceProviderResolver serviceProviderResolver, SMSService smsService, Environment environment, @Value(value="${email.magic-link-url}") String magicLinkUrl) throws IOException {
        this.tiqrConfiguration = (TiqrConfiguration)new Yaml().loadAs(resource.getInputStream(), TiqrConfiguration.class);
        String baseUrl = this.getEduIDServerBaseUrl();
        Service service = new Service(this.tiqrConfiguration.getDisplayName(), this.tiqrConfiguration.getIdentifier(), this.tiqrConfiguration.getVersion(), this.tiqrConfiguration.getLogoUrl(), this.tiqrConfiguration.getInfoUrl(), String.format("%s/tiqr/authentication", baseUrl), this.tiqrConfiguration.isPushNotificationsEnabled(), String.format("%s/tiqr/enrollment", baseUrl));
        if (environment.getActiveProfiles().length > 0) {
            this.tiqrConfiguration.getGcm().setAppName(UUID.randomUUID().toString());
        }
        this.tiqrService = new DefaultTiqrService((tiqr.org.repo.EnrollmentRepository)enrollmentRepository, (tiqr.org.repo.RegistrationRepository)registrationRepository, (tiqr.org.repo.AuthenticationRepository)authenticationRepository, service, this.tiqrConfiguration.getEncryptionSecret(), this.tiqrConfiguration.getApns(), this.tiqrConfiguration.getGcm());
        this.enrollmentRepository = enrollmentRepository;
        this.registrationRepository = registrationRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.serviceProviderResolver = serviceProviderResolver;
        this.smsService = smsService;
        this.magicLinkUrl = magicLinkUrl;
        this.rateLimitEnforcer = new RateLimitEnforcer(userRepository, this.tiqrConfiguration);
    }

    private String getEduIDServerBaseUrl() {
        String baseUrl = this.tiqrConfiguration.getBaseUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    @GetMapping(value={"/sp/start-enrollment"})
    public ResponseEntity<Map<String, String>> startEnrollment(org.springframework.security.core.Authentication authentication) throws IOException, WriterException {
        User user = this.userFromAuthentication(authentication);
        return this.doStartEnrollmentForUser(user);
    }

    @GetMapping(value={"/sp/finish-enrollment"})
    public ResponseEntity<Map<String, Object>> finishEnrollment(org.springframework.security.core.Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String enrollmentVerificationKey = UUID.randomUUID().toString();
        user.setEnrollmentVerificationKey(enrollmentVerificationKey);
        this.userRepository.save((Object)user);
        return ResponseEntity.ok(Map.of("enrollmentVerificationKey", enrollmentVerificationKey));
    }

    @GetMapping(value={"/start-enrollment"})
    public ResponseEntity<Map<String, String>> startEnrollment(@RequestParam(value="hash", required=false) String hash) throws IOException, WriterException {
        if (!StringUtils.hasText((String)hash)) {
            throw new ForbiddenException("No hash parameter");
        }
        User user = this.getUserFromAuthenticationRequest(hash);
        return this.doStartEnrollmentForUser(user);
    }

    private ResponseEntity<Map<String, String>> doStartEnrollmentForUser(User user) throws WriterException, IOException {
        Enrollment enrollment = this.tiqrService.startEnrollment(user.getId(), String.format("%s %s", user.getGivenName(), user.getFamilyName()));
        String enrollmentKey = enrollment.getKey();
        String metaDataUrl = String.format("%s/tiqr/metadata?enrollment_key=%s", this.getEduIDServerBaseUrl(), enrollmentKey);
        String url = String.format("%s/tiqrenroll/?metadata=%s", this.tiqrConfiguration.getEduIdAppBaseUrl(), this.encode(metaDataUrl));
        Map<String, String> results = Map.of("enrollmentKey", enrollmentKey, "url", url, "qrcode", QRCodeGenerator.generateQRCodeImage((String)url));
        LOG.info((Object)String.format("Started enrollment for %s", user.getEmail()));
        return ResponseEntity.ok(results);
    }

    @GetMapping(value={"/metadata"})
    public ResponseEntity<MetaData> metaData(@RequestParam(value="enrollment_key") String enrollmentKey) throws TiqrException {
        MetaData metaData = this.tiqrService.getMetaData(enrollmentKey);
        LOG.info((Object)String.format("Returning metaData for %s", metaData.getIdentity().getDisplayName()));
        return ResponseEntity.ok((Object)metaData);
    }

    @GetMapping(value={"/poll-enrollment"})
    public ResponseEntity<EnrollmentStatus> enrollmentStatus(@RequestParam(value="enrollmentKey") String enrollmentKey) throws TiqrException {
        Enrollment enrollment = this.tiqrService.enrollmentStatus(enrollmentKey);
        LOG.debug((Object)String.format("Polling enrollment for %s with status %s", enrollment.getUserDisplayName(), enrollment.getStatus()));
        return ResponseEntity.ok((Object)enrollment.getStatus());
    }

    @GetMapping(value={"/sp/generate-backup-code"})
    public ResponseEntity<Map<String, String>> generateBackupCodeForSp(org.springframework.security.core.Authentication authentication) throws TiqrException {
        User user = this.userFromAuthentication(authentication);
        return this.doGenerateBackupCode(user);
    }

    @GetMapping(value={"/generate-backup-code"})
    public ResponseEntity<Map<String, String>> generateBackupCode(@RequestParam(value="hash") String hash) throws TiqrException {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Unknown hash"));
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        samlAuthenticationRequest.setTiqrFlow(true);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return this.doGenerateBackupCode(user);
    }

    private ResponseEntity<Map<String, String>> doGenerateBackupCode(User user) throws TiqrException {
        String recoveryCode = VerificationCodeGenerator.generateBackupCode();
        user.getSurfSecureId().put("recovery-code", recoveryCode.replaceAll(" ", ""));
        this.userRepository.save((Object)user);
        this.tiqrService.finishRegistration(user.getId());
        Map<String, String> body = Map.of("redirect", this.magicLinkUrl, "recoveryCode", recoveryCode);
        return this.getSuccessResponseEntity(body);
    }

    @PostMapping(value={"/sp/send-phone-code"})
    public ResponseEntity<Map<String, String>> sendPhoneCodeForSp(org.springframework.security.core.Authentication authentication, @RequestBody Map<String, String> requestBody) {
        User user = this.userFromAuthentication(authentication);
        String phoneNumber = requestBody.get("phoneNumber");
        return this.doSendPhoneCode(user, phoneNumber);
    }

    @PostMapping(value={"/send-phone-code"})
    public ResponseEntity<Map<String, String>> sendPhoneCode(@RequestParam(value="hash") String hash, @RequestBody Map<String, String> requestBody) {
        User user = this.getUserFromAuthenticationRequest(hash);
        String phoneNumber = requestBody.get("phoneNumber");
        return this.doSendPhoneCode(user, phoneNumber);
    }

    private ResponseEntity<Map<String, String>> doSendPhoneCode(User user, String phoneNumber) {
        String phoneVerification = VerificationCodeGenerator.generatePhoneVerification();
        this.smsService.send(phoneNumber, phoneVerification);
        Map surfSecureId = user.getSurfSecureId();
        surfSecureId.put("phone-verification-code", phoneVerification);
        surfSecureId.put("phone-number", phoneNumber);
        surfSecureId.remove("rate-limit");
        this.userRepository.save((Object)user);
        return ResponseEntity.ok(Collections.singletonMap("status", "ok"));
    }

    @PostMapping(value={"/sp/verify-phone-code"})
    public ResponseEntity<Map<String, String>> doVerifyPhoneCode(org.springframework.security.core.Authentication authentication, @RequestBody Map<String, String> requestBody) throws TiqrException {
        User user = this.userFromAuthentication(authentication);
        return this.doVerifyPhoneCode(requestBody, user);
    }

    @PostMapping(value={"/verify-phone-code"})
    public ResponseEntity<Map<String, String>> verifyPhoneCode(@RequestParam(value="hash") String hash, @RequestBody Map<String, String> requestBody) throws TiqrException {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Unknown hash"));
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        ResponseEntity results = this.doVerifyPhoneCode(requestBody, user);
        samlAuthenticationRequest.setTiqrFlow(true);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return results;
    }

    private ResponseEntity<Map<String, String>> doVerifyPhoneCode(Map<String, String> requestBody, User user) throws TiqrException {
        String phoneVerification = requestBody.get("phoneVerification");
        Map surfSecureId = user.getSurfSecureId();
        String phoneVerificationStored = (String)surfSecureId.get("phone-verification-code");
        this.rateLimitEnforcer.checkRateLimit(user);
        if (!MessageDigest.isEqual(phoneVerification.getBytes(StandardCharsets.UTF_8), phoneVerificationStored.getBytes(StandardCharsets.UTF_8))) {
            throw new ForbiddenException();
        }
        surfSecureId.remove("phone-verification-code");
        surfSecureId.put("phone-verified", true);
        surfSecureId.remove("rate-limit");
        this.userRepository.save((Object)user);
        this.tiqrService.finishRegistration(user.getId());
        return this.getSuccessResponseEntity(Collections.singletonMap("redirect", this.magicLinkUrl));
    }

    @PostMapping(value={"/sp/start-authentication"})
    public ResponseEntity<Map<String, Object>> startAuthenticationForSP(HttpServletRequest request, org.springframework.security.core.Authentication authentication) throws IOException, WriterException, TiqrException {
        User user = this.userFromAuthentication(authentication);
        return this.doStartAuthentication(request, user);
    }

    @PostMapping(value={"/start-authentication"})
    public ResponseEntity<Map<String, Object>> startAuthentication(HttpServletRequest request, @Valid @RequestBody TiqrRequest tiqrRequest) throws IOException, WriterException, TiqrException {
        this.authenticationRequestRepository.findByIdAndNotExpired(tiqrRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        String email = tiqrRequest.getEmail().trim();
        User user = (User)this.userRepository.findUserByEmail(email).orElseThrow(() -> new UserNotFoundException(String.format("User %s not found", email)));
        return this.doStartAuthentication(request, user);
    }

    private ResponseEntity<Map<String, Object>> doStartAuthentication(HttpServletRequest request, User user) throws WriterException, IOException, TiqrException {
        Optional optionalTiqrCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"TIQR_COOKIE");
        boolean tiqrCookiePresent = optionalTiqrCookie.isPresent();
        boolean sendPushNotification = tiqrCookiePresent && this.tiqrConfiguration.isPushNotificationsEnabled();
        Authentication authentication = this.tiqrService.startAuthentication(user.getId(), String.format("%s %s", user.getGivenName(), user.getFamilyName()), this.tiqrConfiguration.getEduIdAppBaseUrl(), sendPushNotification);
        String authenticationUrl = authentication.getAuthenticationUrl();
        String qrCode = QRCodeGenerator.generateQRCodeImage((String)authenticationUrl);
        Map<String, Boolean> body = Map.of("sessionKey", authentication.getSessionKey(), "url", authenticationUrl, "qr", qrCode, "tiqrCookiePresent", sendPushNotification && authentication.isPushNotificationSend());
        return ResponseEntity.ok(body);
    }

    @GetMapping(value={"/poll-authentication"})
    public ResponseEntity<Map<String, String>> authenticationStatus(@RequestParam(value="sessionKey") String sessionKey, @RequestParam(value="id") String authenticationRequestId) throws TiqrException {
        Authentication authentication = this.tiqrService.authenticationStatus(sessionKey);
        AuthenticationStatus status = authentication.getStatus();
        LOG.debug((Object)String.format("Polling authentication for %s with status %s", authentication.getUserDisplayName(), authentication.getStatus()));
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("status", status.name());
        if (status.equals((Object)AuthenticationStatus.SUCCESS)) {
            SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findById((Object)authenticationRequestId).orElseThrow(ExpiredAuthenticationException::new);
            String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
            String userID = authentication.getUserID();
            User user = (User)this.userRepository.findById((Object)userID).orElseThrow(() -> new UserNotFoundException(String.format("User %s not found", authentication.getUserDisplayName())));
            MDCContext.logWithContext((User)user, (String)"update", (String)"user", (Log)LOG, (String)("Updating user " + user.getEmail()));
            user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, this.serviceProviderResolver);
            this.userRepository.save((Object)user);
            samlAuthenticationRequest.setHash(HashGenerator.hash());
            samlAuthenticationRequest.setTiqrFlow(true);
            samlAuthenticationRequest.setUserId(userID);
            this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
            body.put("redirect", this.magicLinkUrl);
            body.put("hash", samlAuthenticationRequest.getHash());
        }
        return ResponseEntity.ok(body);
    }

    @PostMapping(value={"/manual-response"})
    public ResponseEntity<Map<String, String>> manualResponse(@RequestBody Map<String, String> requestBody) throws TiqrException {
        String sessionKey = requestBody.get("sessionKey");
        String response = requestBody.get("response");
        this.tiqrService.postAuthentication(new AuthenticationData(sessionKey, response));
        return ResponseEntity.ok(Map.of("status", "ok"));
    }

    @PostMapping(value={"/enrollment"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Object> doEnrollment(@ModelAttribute Registration registration, @RequestParam(value="enrollment_secret") String enrollmentSecret) {
        registration.setEnrollmentSecret(enrollmentSecret);
        try {
            Registration savedRegistration = this.tiqrService.enrollData(registration);
            LOG.debug((Object)("Successful enrollment for user " + savedRegistration.getUserId()));
            return ResponseEntity.ok((Object)"OK");
        }
        catch (RuntimeException | TiqrException e) {
            LOG.error((Object)("Exception during enrollment for user: " + registration.getUserId()), e);
            return ResponseEntity.ok((Object)"ERROR");
        }
    }

    @PostMapping(value={"/authentication"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<Object> doAuthentication(@ModelAttribute AuthenticationData authenticationData) {
        try {
            this.tiqrService.postAuthentication(authenticationData);
            LOG.debug((Object)("Successful authentication for user " + authenticationData.getUserId()));
            return ResponseEntity.ok((Object)"OK");
        }
        catch (RuntimeException | TiqrException e) {
            LOG.error((Object)("Exception during authentication for user: " + authenticationData.getUserId()), e);
            return ResponseEntity.ok((Object)"ERROR");
        }
    }

    @PutMapping(value={"/remember-me"})
    public ResponseEntity<Map<String, String>> rememberMe(@RequestBody Map<String, String> body) {
        String hash = body.get("hash");
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(ExpiredAuthenticationException::new);
        samlAuthenticationRequest.setRememberMe(true);
        samlAuthenticationRequest.setRememberMeValue(UUID.randomUUID().toString());
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return ResponseEntity.ok(Collections.singletonMap("status", "ok"));
    }

    @GetMapping(value={"/sp/send-deactivation-phone-code"})
    public ResponseEntity<Map<String, String>> sendDeactivationPhoneCodeForSp(org.springframework.security.core.Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String phoneNumber = (String)user.getSurfSecureId().get("phone-number");
        if (!StringUtils.hasText((String)phoneNumber)) {
            throw new ForbiddenException();
        }
        return this.doSendPhoneCode(user, phoneNumber);
    }

    @PostMapping(value={"/sp/deactivate-app"})
    public ResponseEntity<Map<String, String>> deactivateApp(org.springframework.security.core.Authentication authentication, @RequestBody Map<String, String> requestBody) {
        User user = this.userFromAuthentication(authentication);
        Map surfSecureId = user.getSurfSecureId();
        String verificationCodeKey = surfSecureId.containsKey("recovery-code") ? "recovery-code" : "phone-verification-code";
        byte[] verificationCode = ((String)surfSecureId.get(verificationCodeKey)).replaceAll(" ", "").getBytes(StandardCharsets.UTF_8);
        byte[] userVerificationCode = requestBody.get("verificationCode").replaceAll(" ", "").getBytes(StandardCharsets.UTF_8);
        this.rateLimitEnforcer.checkRateLimit(user);
        if (!MessageDigest.isEqual(userVerificationCode, verificationCode)) {
            throw new ForbiddenException();
        }
        user.getSurfSecureId().clear();
        this.userRepository.save((Object)user);
        Registration registration = (Registration)this.registrationRepository.findRegistrationByUserId(user.getId()).orElseThrow(IllegalArgumentException::new);
        this.registrationRepository.delete((Object)registration);
        return ResponseEntity.ok(Collections.singletonMap("status", "ok"));
    }

    private User userFromAuthentication(org.springframework.security.core.Authentication authentication) {
        String userId = ((User)authentication.getPrincipal()).getId();
        return (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
    }

    private ResponseEntity<Map<String, String>> getSuccessResponseEntity(Map<String, String> body) {
        return ResponseEntity.ok(body);
    }

    private User getUserFromAuthenticationRequest(String hash) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Unknown hash"));
        String userId = samlAuthenticationRequest.getUserId();
        return (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
    }

    private String encode(String s) {
        return URLEncoder.encode(s, Charset.defaultCharset());
    }
}

