/*
 * Decompiled with CFR 0.152.
 */
package myconext.mail;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import myconext.model.EmailsSend;
import myconext.model.User;
import myconext.repository.EmailsSendRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class MailBox {
    private static final Log LOG = LogFactory.getLog(MailBox.class);
    private static final String SANITIZE_NAME = "[^\\p{L} '-]";
    private final JavaMailSender mailSender;
    private final String magicLinkUrl;
    private final String mySURFconextURL;
    private final String emailFrom;
    private final Map<String, Map<String, String>> subjects;
    private final MustacheFactory mustacheFactory;
    private final EmailsSendRepository emailsSendRepository;
    private final long emailSpamThresholdSeconds;

    public MailBox(JavaMailSender mailSender, String emailFrom, String magicLinkUrl, String mySURFconextURL, ObjectMapper objectMapper, Resource mailTemplatesDirectory, EmailsSendRepository emailsSendRepository, long emailSpamThresholdSeconds) throws IOException {
        this.mailSender = mailSender;
        this.emailFrom = emailFrom;
        this.magicLinkUrl = magicLinkUrl;
        this.mySURFconextURL = mySURFconextURL;
        this.emailsSendRepository = emailsSendRepository;
        this.emailSpamThresholdSeconds = emailSpamThresholdSeconds;
        if (mailTemplatesDirectory.isFile()) {
            LOG.info((Object)("Initializing mail templates from file system: " + mailTemplatesDirectory.getFile().getAbsolutePath()));
            this.mustacheFactory = new DefaultMustacheFactory(mailTemplatesDirectory.getFile());
        } else {
            LOG.info((Object)("Initializing mail templates from JAR resoruce: " + mailTemplatesDirectory.getFilename()));
            this.mustacheFactory = new DefaultMustacheFactory(mailTemplatesDirectory.getFilename());
        }
        this.subjects = (Map)objectMapper.readValue(this.inputStream("subjects.json", mailTemplatesDirectory), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sendMagicLink(User user, String hash, String requesterId) {
        String title = this.getTitle("magic_link", user);
        Map variables = this.variables(user, title);
        variables.put("destination", requesterId);
        variables.put("hash", hash);
        variables.put("magicLinkUrl", this.magicLinkUrl);
        this.sendMail("magic_link", title, variables, this.preferredLanguage(user), user.getEmail(), true);
    }

    public void sendAccountVerification(User user, String hash) {
        String title = this.getTitle("account_verification", user);
        Map variables = this.variables(user, title);
        variables.put("hash", hash);
        variables.put("magicLinkUrl", this.magicLinkUrl);
        this.sendMail("account_verification", title, variables, this.preferredLanguage(user), user.getEmail(), true);
    }

    public void sendAccountConfirmation(User user) {
        String title = this.getTitle("account_confirmation", user);
        Map variables = this.variables(user, title);
        variables.put("mySurfConextURL", this.mySURFconextURL);
        this.sendMail("account_confirmation", title, variables, this.preferredLanguage(user), user.getEmail(), false);
    }

    public void sendForgotPassword(User user, String hash) {
        String title = this.getTitle("forgot_password", user);
        Map variables = this.variables(user, title);
        variables.put("mySurfConextURL", this.mySURFconextURL);
        variables.put("hash", hash);
        this.sendMail("forgot_password", title, variables, this.preferredLanguage(user), user.getEmail(), false);
    }

    public void sendUpdateEmail(User user, String newMail, String hash) {
        String title = this.getTitle("update_email", user);
        Map variables = this.variables(user, title);
        variables.put("mySurfConextURL", this.mySURFconextURL);
        variables.put("hash", hash);
        this.sendMail("update_email", title, variables, this.preferredLanguage(user), newMail, false);
    }

    public void sendUpdateConfirmationEmail(User user, String oldEmail, String newEmail) {
        String title = this.getTitle("confirmation_update_email", user);
        Map variables = this.variables(user, title);
        variables.put("oldEmail", oldEmail);
        variables.put("newEmail", newEmail);
        variables.put("mySurfConextURL", this.mySURFconextURL);
        this.sendMail("confirmation_update_email", title, variables, this.preferredLanguage(user), oldEmail, false);
        this.sendMail("confirmation_update_email", title, variables, this.preferredLanguage(user), newEmail, false);
    }

    public void sendVerificationCode(User user, String verificationCode) {
        String title = this.getTitle("verification_code", user);
        Map variables = this.variables(user, title);
        variables.put("mySurfConextURL", this.mySURFconextURL);
        variables.put("verificationCode", verificationCode);
        this.sendMail("verification_code", title, variables, this.preferredLanguage(user), user.getEmail(), true);
    }

    private Map<String, Object> variables(User user, String title) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("title", title);
        String fullName = user.getGivenName() + " " + user.getFamilyName();
        String fullNameSanitized = fullName.replaceAll(SANITIZE_NAME, "");
        variables.put("name", fullNameSanitized);
        return variables;
    }

    private void sendMail(String templateName, String subject, Map<String, Object> variables, String language, String to, boolean checkSpam) {
        Optional byEmail;
        if (checkSpam && (byEmail = this.emailsSendRepository.findByEmail(to)).isPresent() && ((EmailsSend)byEmail.get()).getSendAt().toInstant().isAfter(Instant.now().minus(this.emailSpamThresholdSeconds, ChronoUnit.SECONDS))) {
            throw new IllegalArgumentException(String.format("Not sending email to %s because email was already send at %s", to, ((EmailsSend)byEmail.get()).getSendAt()));
        }
        String html = this.mailTemplate(String.format("%s_%s.html", templateName, language), variables);
        String text = this.mailTemplate(String.format("%s_%s.txt", templateName, language), variables);
        MimeMessage message = this.mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setSubject(subject);
            helper.setTo(to);
            this.setText(html, text, helper);
            helper.setFrom(this.emailFrom);
            this.doSendMail(message);
        }
        catch (MessagingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void setText(String html, String text, MimeMessageHelper helper) throws MessagingException {
        helper.setText(text, html);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }

    private String mailTemplate(String name, Map<String, Object> context) {
        return this.mustacheFactory.compile(name).execute((Writer)new StringWriter(), context).toString();
    }

    private String getTitle(String templateName, User user) {
        return (String)((Map)this.subjects.get(templateName)).get(this.preferredLanguage(user));
    }

    private String preferredLanguage(User user) {
        String preferredLanguage = user.getPreferredLanguage();
        return StringUtils.hasText((String)preferredLanguage) ? preferredLanguage : LocaleContextHolder.getLocale().getLanguage();
    }

    private InputStream inputStream(String name, Resource mailTemplatesDirectory) {
        if (mailTemplatesDirectory.isFile()) {
            FilenameFilter filter = (dir, fileName) -> name.equals(fileName);
            File[] files = mailTemplatesDirectory.getFile().listFiles(filter);
            File file = files[0];
            return new FileInputStream(file);
        }
        return new ClassPathResource(mailTemplatesDirectory.getFilename() + "/" + name).getInputStream();
    }
}

