/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.User;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tiqr.org.model.Registration;

public class UserResponse
implements Serializable {
    private final String id;
    private final String email;
    private final String givenName;
    private final String familyName;
    private final boolean usePassword;
    private final boolean usePublicKey;
    private final boolean forgottenPassword;
    private final List<PublicKeyCredentials> publicKeyCredentials;
    private final List<LinkedAccount> linkedAccounts;
    private final String schacHomeOrganization;
    private final String uid;
    private final boolean rememberMe;
    private final long created;
    private final Map<String, EduID> eduIdPerServiceProvider;
    private final List<String> loginOptions;
    private final Map<String, Object> registration = new HashMap();

    public UserResponse(User user, Map<String, EduID> eduIdPerServiceProvider, Optional<Registration> optionalRegistration, boolean rememberMe) {
        this.id = user.getId();
        this.email = user.getEmail();
        this.givenName = user.getGivenName();
        this.familyName = user.getFamilyName();
        this.schacHomeOrganization = user.getSchacHomeOrganization();
        this.uid = user.getUid();
        this.usePassword = StringUtils.hasText((String)user.getPassword());
        this.publicKeyCredentials = user.getPublicKeyCredentials();
        this.linkedAccounts = user.getLinkedAccounts();
        this.usePublicKey = !CollectionUtils.isEmpty((Collection)this.publicKeyCredentials);
        this.forgottenPassword = user.isForgottenPassword();
        this.rememberMe = rememberMe;
        this.created = user.getCreated();
        this.eduIdPerServiceProvider = eduIdPerServiceProvider;
        this.loginOptions = user.loginOptions();
        optionalRegistration.ifPresent(reg -> {
            this.registration.put("created", reg.getCreated().toEpochMilli());
            this.registration.put("status", reg.getStatus());
            this.registration.put("notificationType", reg.getNotificationType());
            this.registration.put("notificationAddress", reg.getNotificationAddress());
            this.registration.put("phoneVerified", user.getSurfSecureId().containsKey("phone-verified"));
            this.registration.put("recoveryCode", user.getSurfSecureId().containsKey("recovery-code"));
            this.registration.put("updated", reg.getUpdated().toEpochMilli());
        });
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public boolean isUsePassword() {
        return this.usePassword;
    }

    public boolean isUsePublicKey() {
        return this.usePublicKey;
    }

    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public long getCreated() {
        return this.created;
    }

    public Map<String, EduID> getEduIdPerServiceProvider() {
        return this.eduIdPerServiceProvider;
    }

    public List<String> getLoginOptions() {
        return this.loginOptions;
    }

    public Map<String, Object> getRegistration() {
        return this.registration;
    }
}

