/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import myconext.exceptions.WeakPasswordException;
import myconext.manage.ServiceProviderResolver;
import myconext.model.CreateInstitutionEduID;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.LoginOptions;
import myconext.model.PublicKeyCredentials;
import myconext.model.ServiceProvider;
import myconext.validation.PasswordStrength;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Document(collection="users")
public class User
implements Serializable,
UserDetails {
    @Id
    private String id;
    private String email;
    private String givenName;
    private String familyName;
    @Indexed
    private String uid;
    private String schacHomeOrganization;
    private String password;
    private boolean newUser;
    private String preferredLanguage;
    private String webAuthnIdentifier;
    private String userHandle;
    private boolean forgottenPassword;
    @Indexed
    private String enrollmentVerificationKey;
    @Indexed
    private String createFromInstitutionKey;
    private Map<String, List<String>> attributes = new HashMap();
    private Map<String, Object> surfSecureId = new HashMap();
    private List<PublicKeyCredentials> publicKeyCredentials = new ArrayList();
    private List<LinkedAccount> linkedAccounts = new ArrayList();
    private List<EduID> eduIDS = new ArrayList();
    private long created;
    private long updatedAt = System.currentTimeMillis() / 1000L;
    private String trackingUuid;
    private long lastSeenAppNudge;

    public User(CreateInstitutionEduID createInstitutionEduID, Map<String, Object> userInfo) {
        this.email = createInstitutionEduID.getEmail();
        this.givenName = (String)userInfo.get("given_name");
        this.familyName = (String)userInfo.get("family_name");
    }

    public User(String uid, String email, String givenName, String familyName, String schacHomeOrganization, String preferredLanguage, String serviceProviderEntityId, ServiceProviderResolver serviceProviderResolver) {
        this.uid = uid;
        this.email = email;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = schacHomeOrganization;
        this.preferredLanguage = preferredLanguage;
        this.computeEduIdForServiceProviderIfAbsent(serviceProviderEntityId, serviceProviderResolver);
        this.newUser = true;
        this.updatedAt = this.created = System.currentTimeMillis() / 1000L;
    }

    public void validate() {
        Assert.notNull((Object)this.email, (String)"Email is required");
        Assert.notNull((Object)this.givenName, (String)"GivenName is required");
        Assert.notNull((Object)this.familyName, (String)"FamilyName is required");
    }

    public void encryptPassword(String password, PasswordEncoder encoder) {
        if (!PasswordStrength.strongEnough((String)password)) {
            throw new WeakPasswordException();
        }
        this.password = encoder.encode((CharSequence)password);
    }

    public void deletePassword() {
        this.password = null;
    }

    @Transient
    public void addPublicKeyCredential(PublicKeyCredentialDescriptor publicKeyCredentialDescriptor, ByteArray publicKeyCredential, String name) {
        this.publicKeyCredentials.add(new PublicKeyCredentials(publicKeyCredentialDescriptor, publicKeyCredential, name));
    }

    private boolean eduIDEquals(EduID eduID, Optional<ServiceProvider> optionalServiceProvider, String serviceProviderEntityId) {
        ServiceProvider serviceProvider;
        if (eduID.getServiceProviderEntityId().equalsIgnoreCase(serviceProviderEntityId)) {
            return true;
        }
        if (optionalServiceProvider.isPresent() && StringUtils.hasText((String)(serviceProvider = optionalServiceProvider.get()).getInstitutionGuid())) {
            return serviceProvider.getInstitutionGuid().equalsIgnoreCase(eduID.getServiceInstutionGuid());
        }
        return false;
    }

    @Transient
    public String computeEduIdForServiceProviderIfAbsent(String serviceProviderEntityId, ServiceProviderResolver serviceProviderResolver) {
        Optional optionalServiceProvider = serviceProviderResolver.resolve(serviceProviderEntityId);
        Optional<EduID> optionalEduID = this.eduIDS.stream().filter(eduID -> this.eduIDEquals(eduID, optionalServiceProvider, serviceProviderEntityId)).findFirst();
        if (optionalEduID.isPresent()) {
            EduID eduID2 = optionalEduID.get();
            optionalServiceProvider.ifPresent(arg_0 -> ((EduID)eduID2).updateServiceProvider(arg_0));
            return eduID2.getValue();
        }
        EduID eduID3 = new EduID(UUID.randomUUID().toString(), serviceProviderEntityId, optionalServiceProvider);
        this.eduIDS.add(eduID3);
        return eduID3.getValue();
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singletonList(new SimpleGrantedAuthority("ROLE_GUEST"));
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public String getUsername() {
        return this.email;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @Transient
    @JsonIgnore
    public List<LinkedAccount> linkedAccountsSorted() {
        return this.linkedAccounts.stream().sorted(Comparator.comparing(LinkedAccount::getExpiresAt).reversed()).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> allEduPersonAffiliations() {
        return this.linkedAccounts.stream().map(LinkedAccount::getEduPersonAffiliations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> loginOptions() {
        ArrayList<LoginOptions> result = new ArrayList<LoginOptions>();
        if (!CollectionUtils.isEmpty((Map)this.surfSecureId) && (this.surfSecureId.containsKey("phone-verified") || this.surfSecureId.containsKey("recovery-code"))) {
            result.add(LoginOptions.APP);
        }
        if (!CollectionUtils.isEmpty((Collection)this.publicKeyCredentials)) {
            result.add(LoginOptions.FIDO);
        }
        if (StringUtils.hasText((String)this.password)) {
            result.add(LoginOptions.PASSWORD);
        }
        result.add(LoginOptions.MAGIC);
        return result.stream().map(LoginOptions::getValue).collect(Collectors.toList());
    }

    public String getEduPersonPrincipalName() {
        return this.uid + "@" + this.schacHomeOrganization;
    }

    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public void setWebAuthnIdentifier(String webAuthnIdentifier) {
        this.webAuthnIdentifier = webAuthnIdentifier;
    }

    public void setUserHandle(String userHandle) {
        this.userHandle = userHandle;
    }

    public void setLinkedAccounts(List<LinkedAccount> linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public void setEduIDS(List<EduID> eduIDS) {
        this.eduIDS = eduIDS;
    }

    public void setPublicKeyCredentials(List<PublicKeyCredentials> publicKeyCredentials) {
        this.publicKeyCredentials = publicKeyCredentials;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setForgottenPassword(boolean forgottenPassword) {
        this.forgottenPassword = forgottenPassword;
    }

    public void setTrackingUuid(String trackingUuid) {
        this.trackingUuid = trackingUuid;
    }

    public void setLastSeenAppNudge(long lastSeenAppNudge) {
        this.lastSeenAppNudge = lastSeenAppNudge;
    }

    public void setEnrollmentVerificationKey(String enrollmentVerificationKey) {
        this.enrollmentVerificationKey = enrollmentVerificationKey;
    }

    public void setCreateFromInstitutionKey(String createFromInstitutionKey) {
        this.createFromInstitutionKey = createFromInstitutionKey;
    }

    public User() {
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getUid() {
        return this.uid;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public boolean isNewUser() {
        return this.newUser;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getWebAuthnIdentifier() {
        return this.webAuthnIdentifier;
    }

    public String getUserHandle() {
        return this.userHandle;
    }

    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    public String getEnrollmentVerificationKey() {
        return this.enrollmentVerificationKey;
    }

    public String getCreateFromInstitutionKey() {
        return this.createFromInstitutionKey;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public Map<String, Object> getSurfSecureId() {
        return this.surfSecureId;
    }

    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public List<EduID> getEduIDS() {
        return this.eduIDS;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getTrackingUuid() {
        return this.trackingUuid;
    }

    public long getLastSeenAppNudge() {
        return this.lastSeenAppNudge;
    }
}

