/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.util.StringUtils;

public class LinkedAccount
implements Serializable {
    private String institutionIdentifier;
    private String schacHomeOrganization;
    @Indexed
    private String eduPersonPrincipalName;
    private String subjectId;
    private String givenName;
    private String familyName;
    private List<String> eduPersonAffiliations = new ArrayList();
    private Date createdAt;
    private Date expiresAt;

    @Transient
    @JsonIgnore
    public boolean updateExpiresIn(String institutionIdentifier, String eppn, String subjectId, String givenName, String familyName, List<String> eduPersonAffiliations, Date expiresAt) {
        this.institutionIdentifier = institutionIdentifier;
        this.eduPersonPrincipalName = eppn;
        this.subjectId = subjectId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.expiresAt = expiresAt;
        this.createdAt = new Date();
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean areNamesValidated() {
        return StringUtils.hasText((String)this.givenName) && StringUtils.hasText((String)this.familyName);
    }

    public void setEduPersonAffiliations(List<String> eduPersonAffiliations) {
        this.eduPersonAffiliations = eduPersonAffiliations;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public LinkedAccount() {
    }

    public LinkedAccount(String institutionIdentifier, String schacHomeOrganization, String eduPersonPrincipalName, String subjectId, String givenName, String familyName, List<String> eduPersonAffiliations, Date createdAt, Date expiresAt) {
        this.institutionIdentifier = institutionIdentifier;
        this.schacHomeOrganization = schacHomeOrganization;
        this.eduPersonPrincipalName = eduPersonPrincipalName;
        this.subjectId = subjectId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
    }

    public String getInstitutionIdentifier() {
        return this.institutionIdentifier;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public List<String> getEduPersonAffiliations() {
        return this.eduPersonAffiliations;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }
}

