/*
 * Decompiled with CFR 0.152.
 */
package myconext.config;

import javax.servlet.Filter;
import myconext.config.NoopFilter;
import myconext.geo.GeoLocation;
import myconext.mail.MailBox;
import myconext.manage.ServiceProviderResolver;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserLoginRepository;
import myconext.repository.UserRepository;
import myconext.saml.ImmutableSamlConfigurationRepository;
import myconext.security.ACR;
import myconext.security.GuestIdpAuthenticationRequestFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.saml.SamlMessageStore;
import org.springframework.security.saml.provider.SamlServerConfiguration;
import org.springframework.security.saml.provider.config.SamlConfigurationRepository;
import org.springframework.security.saml.provider.identity.config.SamlIdentityProviderServerBeanConfiguration;

@Configuration
public class BeanConfig
extends SamlIdentityProviderServerBeanConfiguration {
    private final String redirectUrl;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final UserLoginRepository userLoginRepository;
    private final int rememberMeMaxAge;
    private final int nudgeAppDays;
    private final int rememberMeQuestionAskedDays;
    private final long expiryNonValidatedDurationDays;
    private final long ssoMFADurationSeconds;
    private final boolean secureCookie;
    private final String magicLinkUrl;
    private final MailBox mailBox;
    private final ServiceProviderResolver serviceProviderResolver;
    private final GeoLocation geoLocation;
    private final ImmutableSamlConfigurationRepository immutableSamlConfigurationRepository;

    public BeanConfig(@Value(value="${saml_metadata_base_path}") String samlMetadataBasePath, @Value(value="${idp_redirect_url}") String redirectUrl, @Value(value="${remember_me_max_age_seconds}") int rememberMeMaxAge, @Value(value="${nudge_eduid_app_days}") int nudgeAppDays, @Value(value="${remember_me_question_asked_days}") int rememberMeQuestionAskedDays, @Value(value="${secure_cookie}") boolean secureCookie, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${account_linking_context_class_ref.linked_institution}") String linkedInstitution, @Value(value="${account_linking_context_class_ref.validate_names}") String validateNames, @Value(value="${account_linking_context_class_ref.affiliation_student}") String affiliationStudent, @Value(value="${account_linking_context_class_ref.profile_mfa}") String profileMfa, @Value(value="${linked_accounts.expiry-duration-days-non-validated}") long expiryNonValidatedDurationDays, @Value(value="${sso_mfa_duration_seconds}") long ssoMFADurationSeconds, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, UserLoginRepository userLoginRepository, GeoLocation geoLocation, MailBox mailBox, ServiceProviderResolver serviceProviderResolver) {
        this.immutableSamlConfigurationRepository = new ImmutableSamlConfigurationRepository(samlMetadataBasePath);
        this.redirectUrl = redirectUrl;
        this.rememberMeMaxAge = rememberMeMaxAge;
        this.nudgeAppDays = nudgeAppDays;
        this.rememberMeQuestionAskedDays = rememberMeQuestionAskedDays;
        this.secureCookie = secureCookie;
        this.expiryNonValidatedDurationDays = expiryNonValidatedDurationDays;
        this.ssoMFADurationSeconds = ssoMFADurationSeconds;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.userLoginRepository = userLoginRepository;
        this.geoLocation = geoLocation;
        this.magicLinkUrl = magicLinkUrl;
        this.mailBox = mailBox;
        this.serviceProviderResolver = serviceProviderResolver;
        ACR.initialize((String)linkedInstitution, (String)validateNames, (String)affiliationStudent, (String)profileMfa);
    }

    protected SamlServerConfiguration getDefaultHostSamlServerConfiguration() {
        return new SamlServerConfiguration();
    }

    public Filter idpAuthnRequestFilter() {
        return new GuestIdpAuthenticationRequestFilter(this.getSamlProvisioning(), (SamlMessageStore)this.samlAssertionStore(), this.redirectUrl, this.serviceProviderResolver, this.authenticationRequestRepository, this.userRepository, this.userLoginRepository, this.geoLocation, this.rememberMeMaxAge, this.nudgeAppDays, this.rememberMeQuestionAskedDays, this.secureCookie, this.magicLinkUrl, this.mailBox, this.expiryNonValidatedDurationDays, this.ssoMFADurationSeconds);
    }

    public Filter samlConfigurationFilter(SamlServerConfiguration serverConfig) {
        this.immutableSamlConfigurationRepository.setConfiguration(serverConfig);
        return new NoopFilter();
    }

    public SamlConfigurationRepository samlConfigurationRepository() {
        return this.immutableSamlConfigurationRepository;
    }
}

