/*
 * Decompiled with CFR 0.152.
 */
package myconext.tiqr;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import myconext.exceptions.TooManyRequestsException;
import myconext.model.User;
import myconext.repository.UserRepository;
import myconext.tiqr.TiqrConfiguration;

public class RateLimitEnforcer {
    private final UserRepository userRepository;
    private final TiqrConfiguration tiqrConfiguration;

    public RateLimitEnforcer(UserRepository userRepository, TiqrConfiguration tiqrConfiguration) {
        this.userRepository = userRepository;
        this.tiqrConfiguration = tiqrConfiguration;
    }

    public void checkRateLimit(User user) {
        Map surfSecureId = user.getSurfSecureId();
        int rateLimit = (Integer)surfSecureId.merge("rate-limit", 1, (i, j) -> Integer.sum((Integer)i, (Integer)j));
        if (rateLimit >= this.tiqrConfiguration.getRateLimitThreshold()) {
            boolean resetRateLimit;
            Long rateLimitUpdated = (Long)surfSecureId.get("rate-limit-updated");
            boolean bl = resetRateLimit = System.currentTimeMillis() - rateLimitUpdated > (long)this.tiqrConfiguration.getRateLimitResetMinutes() * 1000L * 60L;
            if (resetRateLimit) {
                surfSecureId.put("rate-limit", 0);
            } else {
                throw new TooManyRequestsException();
            }
        }
        surfSecureId.put("rate-limit-updated", System.currentTimeMillis());
        this.userRepository.save((Object)user);
    }

    public void suspendUserAfterTiqrFailure(User user) {
        Map surfSecureId = user.getSurfSecureId();
        int attempts = (Integer)surfSecureId.merge("suspended-attempts", 1, (i, j) -> (Integer)i + 1);
        surfSecureId.put("suspended-until", Instant.now().plus((long)((int)Math.pow(attempts - 1, 2.0)), ChronoUnit.MINUTES));
        this.userRepository.save((Object)user);
    }

    public void unsuspendUserAfterTiqrSuccess(User user) {
        Map surfSecureId = user.getSurfSecureId();
        if (surfSecureId.containsKey("suspended-until")) {
            surfSecureId.remove("suspended-attempts");
            surfSecureId.remove("suspended-until");
            this.userRepository.save((Object)user);
        }
    }

    public boolean isUserAllowedTiqrVerification(User user) {
        Map surfSecureId = user.getSurfSecureId();
        if (surfSecureId.containsKey("suspended-until")) {
            Object suspendedUntil = surfSecureId.get("suspended-until");
            Instant suspendedUntilInstant = suspendedUntil instanceof Date ? ((Date)suspendedUntil).toInstant() : (Instant)suspendedUntil;
            return Instant.now().isAfter(suspendedUntilInstant);
        }
        return true;
    }
}

