/*
 * Decompiled with CFR 0.152.
 */
package myconext.oidcng;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import myconext.log.MDCContext;
import myconext.model.TokenRepresentation;
import myconext.model.User;
import myconext.oidcng.OpenIDConnect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OpenIDConnectRemote
implements OpenIDConnect {
    private static final Log LOG = LogFactory.getLog(OpenIDConnectRemote.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders headers;
    private final URI oidcngUri;
    private final boolean featureOidcTokenAPI;

    public OpenIDConnectRemote(URI oidcngUri, String user, String password, boolean featureOidcTokenAPI) {
        this.oidcngUri = oidcngUri;
        this.featureOidcTokenAPI = featureOidcTokenAPI;
        this.headers = new HttpHeaders();
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        this.headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        this.headers.setBasicAuth(user, password);
    }

    public List<Map<String, Object>> tokens(User user) {
        if (!this.featureOidcTokenAPI) {
            return Collections.emptyList();
        }
        String unspecifiedID = String.format("urn:collab:person:%s:%s", user.getSchacHomeOrganization(), user.getUid());
        LOG.info((Object)String.format("Fetching tokens from oidc-ng for %s", user.getEmail()));
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.headers);
        String uriString = UriComponentsBuilder.fromUri((URI)this.oidcngUri).queryParam("unspecifiedID", new Object[]{unspecifiedID}).toUriString();
        ResponseEntity responseEntity = this.restTemplate.exchange(uriString, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        List body = (List)responseEntity.getBody();
        LOG.debug((Object)String.format("Tokens result from oidc-ng %s", body));
        return body;
    }

    public HttpStatus deleteTokens(List<TokenRepresentation> tokenIdentifiers, User user) {
        if (!this.featureOidcTokenAPI) {
            return HttpStatus.OK;
        }
        MDCContext.logWithContext((User)user, (String)"delete", (String)"tokens", (Log)LOG, (String)"Deleting oidcng tokens");
        HttpEntity requestEntity = new HttpEntity(tokenIdentifiers, (MultiValueMap)this.headers);
        String uriString = UriComponentsBuilder.fromUri((URI)this.oidcngUri).toUriString();
        ResponseEntity responseEntity = this.restTemplate.exchange(uriString, HttpMethod.PUT, requestEntity, Void.class, new Object[0]);
        return responseEntity.getStatusCode();
    }
}

