/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import myconext.model.User;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="change_email_hashes")
public class ChangeEmailHash
implements Serializable {
    @Id
    private String id;
    private String hash;
    private Date expiresIn;
    private String userId;
    private String newEmail;

    public ChangeEmailHash(User user, String newEmail, String hash) {
        this.userId = user.getId();
        this.hash = hash;
        this.newEmail = newEmail;
        this.expiresIn = Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneId.systemDefault()).toInstant());
    }

    public ChangeEmailHash() {
    }

    public String getId() {
        return this.id;
    }

    public String getHash() {
        return this.hash;
    }

    public Date getExpiresIn() {
        return this.expiresIn;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNewEmail() {
        return this.newEmail;
    }
}

