/*
 * Decompiled with CFR 0.152.
 */
package myconext.aa;

import io.swagger.v3.oas.annotations.Hidden;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import myconext.aa.UserAttribute;
import myconext.manage.ServiceProviderResolver;
import myconext.model.EduID;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api"})
@Hidden
public class AttributeAggregatorController {
    private static final Log LOG = LogFactory.getLog(AttributeAggregatorController.class);
    private final UserRepository userRepository;
    private final ServiceProviderResolver serviceProviderResolver;

    public AttributeAggregatorController(UserRepository userRepository, MongoTemplate mongoTemplate, ServiceProviderResolver serviceProviderResolver) {
        this.userRepository = userRepository;
        this.serviceProviderResolver = serviceProviderResolver;
    }

    @GetMapping(value={"attribute-aggregation"})
    @PreAuthorize(value="hasRole('ROLE_attribute-aggregation')")
    public ResponseEntity<List<UserAttribute>> aggregate(@RequestParam(value="sp_entity_id") String spEntityId, @RequestParam(value="eduperson_principal_name") String eduPersonPrincipalName) {
        Optional userOptional = this.userRepository.findUserByLinkedAccounts_eduPersonPrincipalName(eduPersonPrincipalName);
        ArrayList userAttributes = new ArrayList();
        userOptional.ifPresent(user -> {
            String eduID = user.computeEduIdForServiceProviderIfAbsent(spEntityId, this.serviceProviderResolver);
            this.userRepository.save(user);
            userAttributes.add(new UserAttribute("urn:mace:eduid.nl:1.1", eduID));
        });
        LOG.debug((Object)String.format("Attribute aggregation response %s", userAttributes));
        return ResponseEntity.ok(userAttributes);
    }

    @GetMapping(value={"attribute-manipulation"})
    @PreAuthorize(value="hasRole('ROLE_attribute-manipulation')")
    public ResponseEntity<Map> manipulate(@RequestParam(value="sp_entity_id") String spEntityId, @RequestParam(value="eduid") String eduid, @RequestParam(value="sp_institution_guid", required=false) String spInstitutionGuid) {
        Optional userOptional = this.userRepository.findByEduIDS_value(eduid);
        if (!userOptional.isPresent()) {
            LOG.warn((Object)String.format("Attribute manipulation request for %s with an eduID %s that is not present", spEntityId, eduid));
            return ResponseEntity.ok(new HashMap());
        }
        User user = (User)userOptional.get();
        String eduId = user.computeEduIdForServiceProviderIfAbsent(spEntityId, this.serviceProviderResolver);
        this.userRepository.save((Object)user);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("eduid", eduId);
        if (StringUtils.hasText((String)spInstitutionGuid)) {
            user.getLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.getInstitutionIdentifier().equals(spInstitutionGuid)).findFirst().ifPresent(linkedAccount -> {
                result.put("eduperson_principal_name", linkedAccount.getEduPersonPrincipalName());
                if (StringUtils.hasText((String)linkedAccount.getSubjectId())) {
                    result.put("subject_id", linkedAccount.getSubjectId());
                }
            });
        }
        LOG.debug((Object)String.format("Attribute manipulation response %s", result));
        return ResponseEntity.ok(result);
    }

    @GetMapping(value={"system/eduid-duplicates"})
    @PreAuthorize(value="hasRole('ROLE_system')")
    public ResponseEntity<Map<String, List<EduID>>> eduIdDuplicates() {
        List eduIDs = this.userRepository.findAll().stream().map(User::getEduIDS).flatMap(Collection::stream).collect(Collectors.toList()).stream().filter(eduID -> StringUtils.hasText((String)eduID.getServiceInstutionGuid())).collect(Collectors.toList());
        TreeSet<EduID> uniqueSet = new TreeSet<EduID>(Comparator.comparing(EduID::getServiceProviderEntityId));
        uniqueSet.addAll(eduIDs);
        Map<String, List<EduID>> eduIdValuesGroupedBy = uniqueSet.stream().collect(Collectors.groupingBy(EduID::getServiceInstutionGuid));
        eduIdValuesGroupedBy.values().removeIf(l -> l.size() < 2);
        return ResponseEntity.ok(eduIdValuesGroupedBy);
    }
}

