/*
 * Decompiled with CFR 0.152.
 */
package myconext.log;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import myconext.model.User;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class MDCFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        PreAuthenticatedAuthenticationToken token;
        Object principal;
        Authentication authentication;
        MDCAdapter mdcAdapter = MDC.getMDCAdapter();
        mdcAdapter.clear();
        HttpSession session = request.getSession(false);
        if (session != null) {
            mdcAdapter.put("session_id", session.getId());
        }
        if ((authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof PreAuthenticatedAuthenticationToken && (principal = (token = (PreAuthenticatedAuthenticationToken)authentication).getPrincipal()) instanceof User) {
            User user = (User)principal;
            mdcAdapter.put("userid", user.getEmail());
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            mdcAdapter.clear();
        }
    }
}

