/*
 * Decompiled with CFR 0.152.
 */
package myconext.session;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.User;
import myconext.session.SessionConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.saml.saml2.authentication.Assertion;
import org.springframework.session.data.mongo.config.annotation.web.http.EnableMongoHttpSession;
import org.springframework.session.web.context.AbstractHttpSessionApplicationInitializer;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
@EnableMongoHttpSession
public class SessionConfig
extends AbstractHttpSessionApplicationInitializer {
    @Bean(name={"jsonMapper"})
    @Primary
    public ObjectMapper jsonMapper() {
        return new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).addMixIn(Assertion.class, AssertionMixin.class).addMixIn(HashSet.class, HashSetMixin.class).addMixIn(User.class, UserMixin.class).addMixIn(LinkedAccount.class, LinkedAccountMixin.class).addMixIn(EduID.class, EduIDMixin.class).addMixIn(PublicKeyCredentials.class, PublicKeyCredentialsMixin.class).addMixIn(LinkedHashMap.class, LinkedHashMapMixin.class).addMixIn(HashMap.class, HashMapMixin.class);
    }

    @Bean
    CookieSerializer cookieSerializer(@Value(value="${secure_cookie}") boolean secureCookie) {
        DefaultCookieSerializer defaultCookieSerializer = new DefaultCookieSerializer();
        defaultCookieSerializer.setSameSite(secureCookie ? "None" : "Lax");
        defaultCookieSerializer.setUseSecureCookie(secureCookie);
        return defaultCookieSerializer;
    }
}

