/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import myconext.api.AccountLinkerController;
import myconext.cron.DisposableEmailProviders;
import myconext.crypto.HashGenerator;
import myconext.exceptions.DuplicateUserEmailException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.ServiceProviderResolver;
import myconext.model.AuthorizationURL;
import myconext.model.CreateInstitutionEduID;
import myconext.model.LinkedAccount;
import myconext.model.LoginStatus;
import myconext.model.MobileLinkAccountRequest;
import myconext.model.RequestInstitutionEduID;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.StepUpStatus;
import myconext.model.User;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.MobileLinkAccountRequestRepository;
import myconext.repository.RequestInstitutionEduIDRepository;
import myconext.repository.UserRepository;
import myconext.security.ACR;
import myconext.security.CookieResolver;
import myconext.security.EmailGuessingPrevention;
import myconext.security.GuestIdpAuthenticationRequestFilter;
import myconext.security.UserAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/myconext/api", "/mobile/api"})
public class AccountLinkerController
implements UserAuthentication {
    private static final Log LOG = LogFactory.getLog(AccountLinkerController.class);
    private final String oidcBaseUrl;
    private final String clientId;
    private final String clientSecret;
    private final String idpFlowRedirectUri;
    private final String spFlowRedirectUri;
    private final String mobileFlowRedirectUri;
    private final String spCreateFromInstitutionRedirectUri;
    private final RestTemplate restTemplate = new RestTemplate();
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final RequestInstitutionEduIDRepository requestInstitutionEduIDRepository;
    private final MobileLinkAccountRequestRepository mobileLinkAccountRequestRepository;
    private final UserRepository userRepository;
    private final MailBox mailBox;
    private final String magicLinkUrl;
    private final String idpBaseRedirectUrl;
    private final String spRedirectUrl;
    private final String basePath;
    private final long removalValidatedDurationDays;
    private final String idpExternalValidationEntityId;
    private final String myConextSpEntityId;
    private final boolean useExternalValidationFeature;
    private final ServiceProviderResolver serviceProviderResolver;
    private final String mijnEduIDEntityId;
    private final String schacHomeOrganization;
    private final boolean createEduIDInstitutionEnabled;
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private final EmailGuessingPrevention emailGuessingPreventor;
    private final DisposableEmailProviders disposableEmailProviders;

    public AccountLinkerController(AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, RequestInstitutionEduIDRepository requestInstitutionEduIDRepository, MobileLinkAccountRequestRepository mobileLinkAccountRequestRepository, MailBox mailBox, ServiceProviderResolver serviceProviderResolver, DisposableEmailProviders disposableEmailProviders, @Value(value="${mijn_eduid_entity_id}") String mijnEduIDEntityId, @Value(value="${schac_home_organization}") String schacHomeOrganization, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${idp_redirect_url}") String idpBaseRedirectUrl, @Value(value="${sp_redirect_url}") String spRedirectUrl, @Value(value="${email.idp-surfconext-url}") String loginSURFconextURL, @Value(value="${oidc.client-id}") String clientId, @Value(value="${oidc.secret}") String clientSecret, @Value(value="${oidc.idp-flow-redirect-url}") String idpFlowRedirectUri, @Value(value="${oidc.sp-flow-redirect-url}") String spFlowRedirectUri, @Value(value="${oidc.mobile-flow-redirect-url}") String mobileFlowRedirectUri, @Value(value="${oidc.sp-create-from-institution-redirect-url}") String spCreateFromInstitutionRedirectUri, @Value(value="${oidc.base-url}") String oidcBaseUrl, @Value(value="${base_path}") String basePath, @Value(value="${linked_accounts.removal-duration-days-validated}") long removalValidatedDurationDays, @Value(value="${account_linking.idp_external_validation_entity_id}") String idpExternalValidationEntityId, @Value(value="${account_linking.myconext_sp_entity_id}") String myConextSpEntityId, @Value(value="${feature.use_external_validation}") boolean useExternalValidationFeature, @Value(value="${feature.create_eduid_institution_enabled}") boolean createEduIDInstitutionEnabled, @Value(value="${email_guessing_sleep_millis}") int emailGuessingSleepMillis) {
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.requestInstitutionEduIDRepository = requestInstitutionEduIDRepository;
        this.mobileLinkAccountRequestRepository = mobileLinkAccountRequestRepository;
        this.mailBox = mailBox;
        this.serviceProviderResolver = serviceProviderResolver;
        this.disposableEmailProviders = disposableEmailProviders;
        this.schacHomeOrganization = schacHomeOrganization;
        this.mijnEduIDEntityId = mijnEduIDEntityId;
        this.magicLinkUrl = magicLinkUrl;
        this.idpBaseRedirectUrl = idpBaseRedirectUrl;
        this.spRedirectUrl = spRedirectUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.idpFlowRedirectUri = idpFlowRedirectUri;
        this.spFlowRedirectUri = spFlowRedirectUri;
        this.mobileFlowRedirectUri = mobileFlowRedirectUri;
        this.spCreateFromInstitutionRedirectUri = spCreateFromInstitutionRedirectUri;
        this.basePath = basePath;
        this.oidcBaseUrl = oidcBaseUrl;
        this.removalValidatedDurationDays = removalValidatedDurationDays;
        this.idpExternalValidationEntityId = idpExternalValidationEntityId;
        this.myConextSpEntityId = myConextSpEntityId;
        this.useExternalValidationFeature = useExternalValidationFeature;
        this.createEduIDInstitutionEnabled = createEduIDInstitutionEnabled;
        this.emailGuessingPreventor = new EmailGuessingPrevention(emailGuessingSleepMillis);
    }

    @GetMapping(value={"/idp/oidc/account/{id}"})
    @Hidden
    public ResponseEntity startIdPLinkAccountFlow(@PathVariable(value="id") String id, @RequestParam(value="forceAuth", required=false, defaultValue="false") boolean forceAuth, @RequestParam(value="useExternalValidation", required=false, defaultValue="false") boolean useExternalValidation) throws UnsupportedEncodingException {
        LOG.debug((Object)"Start IdP link account flow");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        if (useExternalValidation && this.useExternalValidationFeature && !samlAuthenticationRequest.isUseExternalValidation()) {
            samlAuthenticationRequest.setUseExternalValidation(true);
            this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        }
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        String state = String.format("id=%s&user_uid=%s", id, this.passwordEncoder.encode((CharSequence)user.getUid()));
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, this.idpFlowRedirectUri, forceAuth, samlAuthenticationRequest.isUseExternalValidation(), samlAuthenticationRequest.getRequesterEntityId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(uriComponents.toUri())).build();
    }

    @GetMapping(value={"/sp/create-from-institution"})
    @Hidden
    public ResponseEntity<Map<String, String>> createFromInstitution(HttpServletRequest request, @RequestParam(value="forceAuth", required=false, defaultValue="false") boolean forceAuth) throws UnsupportedEncodingException {
        LOG.debug((Object)"Start create from institution");
        String state = request.getSession(true).getId();
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, this.spCreateFromInstitutionRedirectUri, forceAuth, false, this.myConextSpEntityId);
        return ResponseEntity.ok(Collections.singletonMap("url", uriComponents.toUriString()));
    }

    @GetMapping(value={"/sp/create-from-institution/oidc-redirect"})
    @Hidden
    public ResponseEntity spCreateFromInstitutionRedirect(HttpServletRequest request, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        LOG.debug((Object)"In redirect for create-institution-flow");
        HttpSession session = request.getSession(false);
        if (session == null || !this.createEduIDInstitutionEnabled) {
            throw new ForbiddenException("No session enabled");
        }
        String storedState = session.getId();
        if (!MessageDigest.isEqual(storedState.getBytes(StandardCharsets.UTF_8), URLDecoder.decode(state, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8))) {
            throw new ForbiddenException("No session enabled");
        }
        Map userInfo = this.requestUserInfo(code, this.spCreateFromInstitutionRedirectUri);
        String eppn = (String)userInfo.get("eduperson_principal_name");
        String eppnAlreadyLinkedRequiredUri = this.spRedirectUrl + "/create-from-institution/eppn-already-linked?fromInstitution=true";
        Optional eppnAlreadyLinkedOptional = this.checkEppnAlreadyLinked(eppnAlreadyLinkedRequiredUri, eppn);
        if (eppnAlreadyLinkedOptional.isPresent()) {
            LOG.debug((Object)("EPPN already linked in create-institution-flow for " + eppn));
            return (ResponseEntity)eppnAlreadyLinkedOptional.get();
        }
        RequestInstitutionEduID requestInstitutionEduID = new RequestInstitutionEduID(HashGenerator.hash(), userInfo);
        this.requestInstitutionEduIDRepository.save((Object)requestInstitutionEduID);
        String returnUri = this.spRedirectUrl + "/create-from-institution/link/" + requestInstitutionEduID.getHash();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(returnUri))).build();
    }

    @GetMapping(value={"/sp/create-from-institution/info"})
    @Hidden
    public Map<String, Object> createFromInstitutionInfo(@RequestParam(value="hash") String hash) {
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        LOG.debug((Object)"Info details for create-institution-flow");
        return requestInstitutionEduID.getUserInfo();
    }

    @PostMapping(value={"/sp/create-from-institution/email"})
    @Hidden
    public ResponseEntity<Map<String, String>> linkFromInstitution(@Valid @RequestBody CreateInstitutionEduID createInstitutionEduID) {
        LOG.debug((Object)"Post details for account verification in create-institution-flow");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(createInstitutionEduID.getHash()).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        String email = createInstitutionEduID.getEmail();
        this.disposableEmailProviders.verifyDisposableEmailProviders(email);
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional userByEmail = this.userRepository.findUserByEmail(email);
        boolean newUser = createInstitutionEduID.isNewUser();
        if (newUser && userByEmail.isPresent()) {
            throw new DuplicateUserEmailException();
        }
        if (!newUser && userByEmail.isEmpty()) {
            throw new UserNotFoundException("User not found: " + email);
        }
        User user = userByEmail.orElse(new User(createInstitutionEduID, requestInstitutionEduID.getUserInfo()));
        requestInstitutionEduID.setUserId(user.getId());
        requestInstitutionEduID.setCreateInstitutionEduID(createInstitutionEduID);
        requestInstitutionEduID.setEmailHash(HashGenerator.hash());
        this.requestInstitutionEduIDRepository.save((Object)requestInstitutionEduID);
        String uri = this.basePath + "/myconext/api/sp/create-from-institution/finish";
        this.mailBox.sendAccountVerificationCreateFromInstitution(user, requestInstitutionEduID.getEmailHash(), uri);
        return ResponseEntity.ok(Map.of("status", "ok"));
    }

    @GetMapping(value={"/sp/create-from-institution/poll"})
    @Hidden
    public int pollCreateFromInstitution(@RequestParam(value="hash") String hash) {
        LOG.debug((Object)"Poll login status for create-institution-flow");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        return requestInstitutionEduID.getLoginStatus().ordinal();
    }

    @GetMapping(value={"/sp/create-from-institution/resendMail"})
    @Hidden
    public void resendMailCreateFromInstitution(@RequestParam(value="hash") String hash) {
        LOG.debug((Object)"Resend mail for create-institution-flow");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        if (!requestInstitutionEduID.getLoginStatus().equals((Object)LoginStatus.NOT_LOGGED_IN)) {
            throw new ForbiddenException("User status is not NOT_LOGGED_IN, but " + requestInstitutionEduID.getLoginStatus());
        }
        String uri = this.basePath + "/myconext/api/sp/create-from-institution/finish";
        User user = new User(requestInstitutionEduID.getCreateInstitutionEduID(), requestInstitutionEduID.getUserInfo());
        this.mailBox.sendAccountVerificationCreateFromInstitution(user, requestInstitutionEduID.getEmailHash(), uri);
    }

    @GetMapping(value={"/sp/create-from-institution/finish"})
    @Hidden
    public ResponseEntity createFromInstitutionFinish(HttpServletRequest request, @RequestParam(value="h") String emailHash) throws UnsupportedEncodingException {
        LOG.debug((Object)"Finish create-institution-flow flow and create account");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByEmailHashAndLoginStatus(emailHash, LoginStatus.NOT_LOGGED_IN).orElseThrow(() -> new ForbiddenException("Wrong emailHash"));
        CreateInstitutionEduID createInstitutionEduID = requestInstitutionEduID.getCreateInstitutionEduID();
        if (createInstitutionEduID == null) {
            throw new ForbiddenException("Tampering");
        }
        Map userInfo = requestInstitutionEduID.getUserInfo();
        String preferredLanguage = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        boolean existingUser = !createInstitutionEduID.isNewUser() && StringUtils.hasText((String)requestInstitutionEduID.getUserId());
        User user = existingUser ? (User)this.userRepository.findById((Object)requestInstitutionEduID.getUserId()).orElseThrow(() -> new UserNotFoundException("User not found")) : new User(UUID.randomUUID().toString(), createInstitutionEduID.getEmail(), (String)userInfo.get("given_name"), (String)userInfo.get("family_name"), this.schacHomeOrganization, preferredLanguage, this.mijnEduIDEntityId, this.serviceProviderResolver);
        user.setCreateFromInstitutionKey(HashGenerator.hash());
        ResponseEntity responseEntity = this.saveOrUpdateLinkedAccountToUser(user, this.idpBaseRedirectUrl + "/create-from-institution-login?key=" + user.getCreateFromInstitutionKey(), false, false, null, null, null, userInfo);
        requestInstitutionEduID.setLoginStatus(LoginStatus.LOGGED_IN_SAME_DEVICE);
        this.requestInstitutionEduIDRepository.save((Object)requestInstitutionEduID);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)authentication);
        HttpSession session = request.getSession();
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)context);
        return responseEntity;
    }

    @GetMapping(value={"/sp/oidc/link"})
    @Operation(summary="Start link account flow", description="Start the link account flow for the current user.<br/>After the account has been linked the user is redirect to one the following URL's:<ul><li>Success: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/account-linked</a></li><li>Failure, EPPN already linked: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/eppn-already-linked?email=jdoe%40example.com</a></li><li>Failure, session expired: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/expired</a></li></ul>", responses={@ApiResponse(responseCode="200", description="Url for authentication", useReturnTypeSchema=true, content={@Content(schema=@Schema(implementation=AuthorizationURL.class), examples={@ExampleObject(value="{\"url\":\"https://connect.test2.surfconext.nl/oidc/authorize?scope=openid&response_type=code&redirect_uri=https://mijn.test2.eduid.nl/myconext/api/sp/oidc/redirect&state=%242a%2410%249cyC3mjeJW0ljb%2FmPAGj0O4DVXz9LPw5U%2Fthl110BVYWFpMhjwKyK&prompt=login&client_id=myconext.ala.eduid\"}")})})})
    public ResponseEntity<AuthorizationURL> startSPLinkAccountFlow(Authentication authentication) throws UnsupportedEncodingException {
        String redirectUri;
        String state;
        LOG.debug((Object)"Start link account flow");
        User user = this.userFromAuthentication(authentication);
        if (this.isMobileRequest(authentication)) {
            MobileLinkAccountRequest mobileLinkAccountRequest = (MobileLinkAccountRequest)this.mobileLinkAccountRequestRepository.save((Object)new MobileLinkAccountRequest(HashGenerator.hash(), user.getId()));
            state = mobileLinkAccountRequest.getHash();
            redirectUri = this.mobileFlowRedirectUri;
        } else {
            state = this.passwordEncoder.encode((CharSequence)user.getUid());
            redirectUri = this.spFlowRedirectUri;
        }
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, redirectUri, true, false, this.myConextSpEntityId);
        return ResponseEntity.ok((Object)new AuthorizationURL(uriComponents.toUriString()));
    }

    private UriComponents doStartLinkAccountFlow(String state, String redirectUri, boolean forceAuth, boolean useExternalValidation, String requesterEntityId) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("response_type", "code");
        params.put("scope", "openid");
        params.put("redirect_uri", redirectUri);
        params.put("state", URLEncoder.encode(state, StandardCharsets.UTF_8));
        if (forceAuth) {
            params.put("prompt", "login");
        }
        if (useExternalValidation) {
            params.put("login_hint", this.idpExternalValidationEntityId);
            params.put("acr_values", requesterEntityId);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.oidcBaseUrl + "/oidc/authorize"));
        params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        return builder.build();
    }

    @GetMapping(value={"/sp/oidc/redirect"})
    @Hidden
    public ResponseEntity spFlowRedirect(Authentication authentication, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        LOG.debug((Object)"In SP redirect link account");
        User principal = this.userFromAuthentication(authentication);
        String uid = principal.getUid();
        Optional userOptional = this.userRepository.findUserByUid(uid);
        User user = (User)userOptional.orElseThrow(() -> new UserNotFoundException(uid));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), URLDecoder.decode(state, StandardCharsets.UTF_8))) {
            throw new ForbiddenException("Non matching user");
        }
        return this.doRedirect(code, user, this.spFlowRedirectUri, this.spRedirectUrl + "/personal", false, false, null, null, this.spRedirectUrl + "/eppn-already-linked");
    }

    @GetMapping(value={"/mobile/oidc/redirect"})
    @Hidden
    public ResponseEntity mobileFlowRedirect(@RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        LOG.debug((Object)"In Mobile redirect link account");
        String decodedState = URLDecoder.decode(state, StandardCharsets.UTF_8);
        Optional optionalMobileLinkAccountRequest = this.mobileLinkAccountRequestRepository.findByHash(decodedState);
        if (!optionalMobileLinkAccountRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/client/mobile/expired"))).build();
        }
        MobileLinkAccountRequest mobileLinkAccountRequest = (MobileLinkAccountRequest)optionalMobileLinkAccountRequest.get();
        String userId = mobileLinkAccountRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        this.mobileLinkAccountRequestRepository.delete((Object)mobileLinkAccountRequest);
        return this.doRedirect(code, user, this.mobileFlowRedirectUri, this.idpBaseRedirectUrl + "/client/mobile/account-linked", false, false, null, null, this.idpBaseRedirectUrl + "/client/mobile/eppn-already-linked");
    }

    @GetMapping(value={"/idp/oidc/redirect"})
    @Hidden
    public ResponseEntity idpFlowRedirect(@RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        String decodedState = URLDecoder.decode(state, StandardCharsets.UTF_8);
        MultiValueMap params = UriComponentsBuilder.fromHttpUrl((String)("http://localhost?" + decodedState)).build().getQueryParams();
        String id = (String)params.getFirst((Object)"id");
        String encodedUserUid = (String)params.getFirst((Object)"user_uid");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), encodedUserUid)) {
            throw new ForbiddenException("Non matching user");
        }
        boolean validateNames = samlAuthenticationRequest.getAuthenticationContextClassReferences().contains(ACR.VALIDATE_NAMES);
        boolean studentAffiliationRequired = samlAuthenticationRequest.getAuthenticationContextClassReferences().contains(ACR.AFFILIATION_STUDENT);
        LOG.debug((Object)"In IdP redirect link account");
        String location = this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash();
        String charSet = Charset.defaultCharset().name();
        String idpStudentAffiliationRequiredUri = this.idpBaseRedirectUrl + "/affiliation-missing/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        String idpValidNamesRequiredUri = this.idpBaseRedirectUrl + "/valid-name-missing/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        String eppnAlreadyLinkedRequiredUri = this.idpBaseRedirectUrl + "/eppn-already-linked/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        ResponseEntity redirect = this.doRedirect(code, user, this.idpFlowRedirectUri, location, validateNames, studentAffiliationRequired, idpStudentAffiliationRequiredUri, idpValidNamesRequiredUri, eppnAlreadyLinkedRequiredUri);
        StepUpStatus stepUpStatus = redirect.getHeaders().getLocation().toString().contains("affiliation-missing") ? StepUpStatus.MISSING_AFFILIATION : StepUpStatus.IN_STEP_UP;
        samlAuthenticationRequest.setSteppedUp(stepUpStatus);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return redirect;
    }

    private ResponseEntity doRedirect(@RequestParam(value="code") String code, User user, String oidcRedirectUri, String clientRedirectUri, boolean validateNames, boolean studentAffiliationRequired, String idpStudentAffiliationRequiredUri, String idpValidNamesRequiredUri, String eppnAlreadyLinkedRequiredUri) throws UnsupportedEncodingException {
        Map body = this.requestUserInfo(code, oidcRedirectUri);
        return this.saveOrUpdateLinkedAccountToUser(user, clientRedirectUri, validateNames, studentAffiliationRequired, idpStudentAffiliationRequiredUri, idpValidNamesRequiredUri, eppnAlreadyLinkedRequiredUri, body);
    }

    private ResponseEntity<Object> saveOrUpdateLinkedAccountToUser(User user, String clientRedirectUri, boolean validateNames, boolean studentAffiliationRequired, String idpStudentAffiliationRequiredUri, String idpValidNamesRequiredUri, String eppnAlreadyLinkedRequiredUri, Map<String, Object> body) throws UnsupportedEncodingException {
        String eppn = (String)body.get("eduperson_principal_name");
        String subjectId = (String)body.get("subject_id");
        String surfCrmId = (String)body.get("surf-crm-id");
        String schacHomeOrganization = (String)body.get("schac_home_organization");
        String givenName = (String)body.get("given_name");
        String familyName = (String)body.get("family_name");
        String institutionIdentifier = StringUtils.hasText((String)surfCrmId) ? surfCrmId : schacHomeOrganization;
        List affiliations = AccountLinkerController.parseAffiliations(body, (String)schacHomeOrganization);
        if (StringUtils.hasText((String)schacHomeOrganization)) {
            Date expiresAt = Date.from(new Date().toInstant().plus(this.removalValidatedDurationDays, ChronoUnit.DAYS));
            List linkedAccounts = user.getLinkedAccounts();
            Optional<LinkedAccount> optionalLinkedAccount = linkedAccounts.stream().filter(linkedAccount -> linkedAccount.getSchacHomeOrganization().equals(schacHomeOrganization)).findFirst();
            if (optionalLinkedAccount.isPresent()) {
                optionalLinkedAccount.get().updateExpiresIn(institutionIdentifier, eppn, subjectId, givenName, familyName, affiliations, expiresAt);
            } else {
                Optional eppnAlreadyLinkedOptional = this.checkEppnAlreadyLinked(eppnAlreadyLinkedRequiredUri, eppn);
                if (eppnAlreadyLinkedOptional.isPresent()) {
                    return (ResponseEntity)eppnAlreadyLinkedOptional.get();
                }
                linkedAccounts.add(new LinkedAccount(institutionIdentifier, schacHomeOrganization, eppn, subjectId, givenName, familyName, affiliations, new Date(), expiresAt));
            }
            String action = optionalLinkedAccount.isPresent() ? "updated" : "add";
            String eppnValue = StringUtils.hasText((String)eppn) ? String.format("eppn %s", eppn) : "NO eppn";
            MDCContext.logWithContext((User)user, (String)action, (String)"linked_accounts", (Log)LOG, (String)String.format("Account link with EPPN %s for institution %s with the affiliations %s", eppnValue, institutionIdentifier, affiliations));
            this.userRepository.save((Object)user);
        } else {
            LOG.error((Object)"Account linking requested, but no schacHomeOrganization provided by the IdP");
        }
        boolean hasStudentAffiliation = user.getLinkedAccounts().stream().anyMatch(linkedAccount -> GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)linkedAccount.getEduPersonAffiliations()));
        if (studentAffiliationRequired && !hasStudentAffiliation) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(idpStudentAffiliationRequiredUri))).build();
        }
        boolean hasValidNames = GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        if (validateNames && !hasValidNames) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(idpValidNamesRequiredUri))).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(clientRedirectUri))).build();
    }

    private Optional<ResponseEntity<Object>> checkEppnAlreadyLinked(String eppnAlreadyLinkedRequiredUri, String eppn) throws UnsupportedEncodingException {
        List optionalUsers;
        if (StringUtils.hasText((String)eppn) && (optionalUsers = this.userRepository.findByLinkedAccounts_EduPersonPrincipalName(eppn)).size() > 0) {
            String charSet = Charset.defaultCharset().name();
            eppnAlreadyLinkedRequiredUri = (String)eppnAlreadyLinkedRequiredUri + (((String)eppnAlreadyLinkedRequiredUri).contains("?") ? "&" : "?");
            eppnAlreadyLinkedRequiredUri = (String)eppnAlreadyLinkedRequiredUri + "email=" + URLEncoder.encode(((User)optionalUsers.get(0)).getEmail(), charSet);
            return Optional.of(((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create((String)eppnAlreadyLinkedRequiredUri))).build());
        }
        return Optional.empty();
    }

    private Map<String, Object> requestUserInfo(String code, String oidcRedirectUri) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"redirect_uri", (Object)oidcRedirectUri);
        map.add((Object)"scope", (Object)"openid");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        1 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        Map body = (Map)this.restTemplate.exchange(this.oidcBaseUrl + "/oidc/token", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        map = new LinkedMultiValueMap();
        map.add((Object)"access_token", (Object)((String)body.get("access_token")));
        request = new HttpEntity((Object)map, (MultiValueMap)headers);
        return (Map)this.restTemplate.exchange(this.oidcBaseUrl + "/oidc/userinfo", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
    }

    protected static List<String> parseAffiliations(Map<String, Object> idpAttributes, String schacHomeOrganization) {
        if (!StringUtils.hasText((String)schacHomeOrganization)) {
            return new ArrayList<String>();
        }
        List eduPersonAffiliations = ((List)idpAttributes.getOrDefault("eduperson_affiliation", new ArrayList())).stream().map(affiliation -> String.format("%s@%s", affiliation, schacHomeOrganization)).collect(Collectors.toList());
        List eduPersonScopedAffiliations = idpAttributes.getOrDefault("eduperson_scoped_affiliation", eduPersonAffiliations);
        HashSet uniqueAffiliations = new HashSet(eduPersonAffiliations);
        uniqueAffiliations.addAll(eduPersonScopedAffiliations);
        return CollectionUtils.isEmpty(uniqueAffiliations) ? Arrays.asList(String.format("affiliate@%s", schacHomeOrganization)) : new ArrayList<String>(uniqueAffiliations);
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

