/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import myconext.exceptions.DisposableEmailProviderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DisposableEmailProviders {
    private static final Log LOG = LogFactory.getLog(DisposableEmailProviders.class);
    private final ObjectMapper objectMapper;
    private Set<String> disposableEmailProviders = new HashSet();
    private final boolean denyDisposableEmailProviders;
    private final TypeReference<Map<String, Object>> mapTypeReference = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public DisposableEmailProviders(ObjectMapper objectMapper, @Value(value="${feature.deny_disposable_email_providers}") boolean denyDisposableEmailProviders) {
        this.objectMapper = objectMapper;
        this.denyDisposableEmailProviders = denyDisposableEmailProviders;
    }

    @Scheduled(initialDelay=1L, fixedRate=24L, timeUnit=TimeUnit.HOURS)
    public void resolveIDisposableEmailProviders() {
        if (!this.denyDisposableEmailProviders) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            String location = "https://raw.githubusercontent.com/7c/fakefilter/main/json/data.json";
            Map emailProviders = (Map)this.objectMapper.readValue(new URL(location), this.mapTypeReference);
            this.disposableEmailProviders = ((Map)emailProviders.get("domains")).keySet();
            LOG.info((Object)String.format("Resolved %s disposable email providers %s in %s ms", this.disposableEmailProviders.size(), location, System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in resolveIDisposableEmailProviders", (Throwable)e);
        }
    }

    public void verifyDisposableEmailProviders(String email) {
        int beginIndex;
        boolean disposableEmail;
        if (!this.denyDisposableEmailProviders) {
            return;
        }
        if (this.disposableEmailProviders.isEmpty()) {
            this.resolveIDisposableEmailProviders();
        }
        if (disposableEmail = this.disposableEmailProviders.contains(email.substring(beginIndex = email.indexOf("@") + 1).toLowerCase())) {
            throw new DisposableEmailProviderException();
        }
    }
}

