/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.github.cloudyrock.mongock.ChangeLog;
import com.github.cloudyrock.mongock.ChangeSet;
import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator.impl.MongockTemplate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import myconext.manage.ServiceProviderResolver;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.ServiceProvider;
import myconext.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.util.StringUtils;

@ChangeLog(order="001")
public class Migrations {
    private static final Log LOG = LogFactory.getLog(Migrations.class);

    @ChangeSet(order="001", id="transformUserPublicKeyCredentials", author="okke.harsta@surf.nl")
    public void transformUserPublicKeyCredentials(MongockTemplate mongoTemplate) {
        List usersAsMaps = mongoTemplate.findAll(Map.class, "users");
        usersAsMaps.forEach(userAsMap -> {
            Map credentials;
            Object o;
            if (userAsMap.containsKey("publicKeyCredentials") && (o = userAsMap.get("publicKeyCredentials")) instanceof Map && !(credentials = (Map)userAsMap.get("publicKeyCredentials")).containsKey("name")) {
                List publicKeyCredentials = credentials.entrySet().stream().map(entry -> new PublicKeyCredentials((String)entry.getKey(), (String)entry.getValue(), "key-" + UUID.randomUUID().toString())).collect(Collectors.toList());
                userAsMap.put("publicKeyCredentials", publicKeyCredentials);
                mongoTemplate.save(userAsMap, "users");
            }
        });
    }

    @ChangeSet(order="002", id="transformEduIdPerServiceProvider", author="okke.harsta@surf.nl")
    public void transformEduIdPerServiceProvider(MongockTemplate mongoTemplate) {
        List usersAsMaps = mongoTemplate.findAll(Map.class, "users");
        usersAsMaps.forEach(userAsMap -> {
            if (userAsMap.containsKey("eduIdPerServiceProvider")) {
                Map eduIdPerServiceProvider = (Map)userAsMap.get("eduIdPerServiceProvider");
                ArrayList eduIDS = new ArrayList();
                eduIdPerServiceProvider.forEach((serviceProviderEntityId, values) -> eduIDS.add(new EduID(serviceProviderEntityId, values)));
                userAsMap.put("eduIDS", eduIDS);
                userAsMap.remove("eduIdPerServiceProvider");
                mongoTemplate.save(userAsMap, "users");
            }
        });
    }

    @ChangeSet(order="003", id="bugfixForDotReplacement", author="okke.harsta@surf.nl")
    public void bugfixForDotReplacement(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            this.mergeEduIDs(user);
            mongoTemplate.save(user);
        });
    }

    @ChangeSet(order="004", id="addServiceProviderInstitutionGuid", author="okke.harsta@surf.nl")
    public void addServiceProviderInstitutionGuid(MongockTemplate mongoTemplate, ServiceProviderResolver serviceProviderResolver) {
        List users = mongoTemplate.findAll(User.class, "users");
        serviceProviderResolver.refresh();
        users.forEach(user -> user.getEduIDS().forEach(eduID -> {
            Optional optionalServiceProvider = serviceProviderResolver.resolve(eduID.getServiceProviderEntityId());
            if (optionalServiceProvider.isPresent()) {
                ServiceProvider serviceProvider = (ServiceProvider)optionalServiceProvider.get();
                if (StringUtils.hasText((String)serviceProvider.getInstitutionGuid())) {
                    eduID.updateServiceProvider(serviceProvider);
                    mongoTemplate.save(user);
                    LOG.info((Object)("Added institutionGuid to " + eduID.getServiceProviderEntityId()));
                }
            } else {
                LOG.info((Object)("Unknown serviceProvider: " + eduID.getServiceProviderEntityId()));
            }
        }));
    }

    @ChangeSet(order="005", id="addTrackingGuid", author="okke.harsta@surf.nl")
    public void addTrackingGuid(MongockTemplate mongoTemplate) {
        List users = mongoTemplate.findAll(User.class, "users");
        users.forEach(user -> {
            if (!StringUtils.hasText((String)user.getTrackingUuid())) {
                user.setTrackingUuid(UUID.randomUUID().toString());
                mongoTemplate.save(user);
            }
        });
    }

    @ChangeSet(order="006", id="deleteSession", author="okke.harsta@surf.nl")
    public void deleteSession(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="007", id="expiresAtLinkedAccounts", author="okke.harsta@surf.nl")
    public void expiresAtLinkedAccounts(MongockTemplate mongoTemplate) {
        Criteria criteria = Criteria.where((String)"linkedAccounts").exists(true).type(new JsonSchemaObject.Type[]{JsonSchemaObject.Type.ARRAY}).ne(new ArrayList());
        List users = mongoTemplate.find(new Query((CriteriaDefinition)criteria), User.class, "users");
        users.forEach(user -> {
            user.getLinkedAccounts().forEach(linkedAccount -> {
                Date createdAt = linkedAccount.getCreatedAt();
                if (createdAt == null) {
                    createdAt = new Date();
                    linkedAccount.setCreatedAt(createdAt);
                }
                Date expiresAt = Date.from(createdAt.toInstant().plus(2190L, ChronoUnit.DAYS));
                linkedAccount.setExpiresAt(expiresAt);
            });
            mongoTemplate.save(user);
        });
    }

    @ChangeSet(order="006", id="deleteSessionAfterUserUpdate", author="okke.harsta@surf.nl")
    public void deleteSessionAfterUserUpdate(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    @ChangeSet(order="007", id="migrateUsers", author="okke.harsta@surf.nl")
    public void migrateUsers(MongockTemplate mongoTemplate) {
        Criteria criteria = Criteria.where((String)"linkedAccounts").exists(true).type(new JsonSchemaObject.Type[]{JsonSchemaObject.Type.ARRAY}).ne(new ArrayList());
        List users = mongoTemplate.find(new Query((CriteriaDefinition)criteria), User.class, "users");
        users.forEach(user -> user.linkedAccountsSorted().stream().filter(LinkedAccount::areNamesValidated).findFirst().ifPresent(linkedAccount -> {
            user.setGivenName(linkedAccount.getGivenName());
            user.setFamilyName(linkedAccount.getFamilyName());
            user.setChosenName(user.getGivenName());
            linkedAccount.setPreferred(true);
            mongoTemplate.save(user);
        }));
    }

    @ChangeSet(order="008", id="deleteSessionAgain", author="okke.harsta@surf.nl")
    public void deleteSessionAgain(MongockTemplate mongoTemplate) {
        mongoTemplate.remove(new Query(), "sessions");
    }

    protected User mergeEduIDs(User user) {
        List eduIDS = user.getEduIDS();
        ArrayList copiedEduIDs = new ArrayList(eduIDS);
        List<EduID> eduIDSFiltered = eduIDS.stream().filter(eduID -> {
            String entityId = eduID.getServiceProviderEntityId();
            boolean remove = false;
            boolean hasDot = entityId.contains(".");
            if (hasDot) {
                String oldEntityId = entityId.replaceAll("\\.", "@");
                remove = copiedEduIDs.stream().anyMatch(someEduID -> someEduID.getServiceProviderEntityId().equals(oldEntityId));
            }
            if (remove) {
                LOG.info((Object)("Removing " + eduID + " for user: " + user.getEmail()));
            }
            return !remove;
        }).collect(Collectors.toList());
        eduIDSFiltered.forEach(eduID -> eduID.replaceAtWithDot());
        user.setEduIDS(eduIDSFiltered);
        return user;
    }
}

