/*
 * Decompiled with CFR 0.152.
 */
package myconext.sms;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import myconext.sms.SMSService;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SMSServiceImpl
implements SMSService {
    private final String url;
    private final String templateNl;
    private final String templateEn;
    private final RestTemplate restTemplate = new RestTemplate();
    private final MultiValueMap<String, String> headers = new HttpHeaders();

    public SMSServiceImpl(String url, String bearer) {
        this.url = url;
        this.templateNl = IOUtils.toString((InputStream)new ClassPathResource("sms/template_nl.txt").getInputStream(), (Charset)Charset.defaultCharset());
        this.templateEn = IOUtils.toString((InputStream)new ClassPathResource("sms/template_en.txt").getInputStream(), (Charset)Charset.defaultCharset());
        this.headers.add((Object)"Accept", (Object)"application/json");
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.headers.add((Object)"Authorization", (Object)("Bearer " + bearer));
    }

    protected String formatMessage(String code, Locale locale) {
        String template = locale != null && locale.getLanguage().equalsIgnoreCase("nl") ? this.templateNl : this.templateEn;
        return String.format(template, code);
    }

    public String send(String mobile, String code, Locale locale) {
        String format = this.formatMessage(code, locale);
        Map<String, List<String>> body = Map.of("encoding", "auto", "body", format, "route", "business", "originator", "eduID", "recipients", List.of(mobile));
        RequestEntity requestEntity = new RequestEntity(body, this.headers, HttpMethod.POST, URI.create(this.url));
        this.restTemplate.exchange(requestEntity, Void.class);
        return format;
    }
}

