/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import myconext.cron.IdentityProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class IdPMetaDataResolver {
    private static final Log LOG = LogFactory.getLog(IdPMetaDataResolver.class);
    private static final List<String> languages = List.of("nl", "en");
    private final Resource metaDataResource;
    private Map<String, IdentityProvider> identityProviderMap = new HashMap();

    @Autowired
    public IdPMetaDataResolver(@Value(value="${cron.metadata-resolver-url}") Resource metaDataResource) {
        this.metaDataResource = metaDataResource;
    }

    @Scheduled(initialDelayString="${cron.metadata-resolver-initial-delay-milliseconds}", fixedRateString="${cron.metadata-resolver-fixed-rate-milliseconds}")
    public void resolveIdpMetaData() {
        long start = System.currentTimeMillis();
        HashMap<String, IdentityProvider> newIdentityProviderMap = new HashMap<String, IdentityProvider>();
        String displayNameEn = null;
        String displayNameNl = null;
        String logoUrl = null;
        ArrayList<String> domainNames = new ArrayList<String>();
        try {
            XMLStreamReader reader = this.getXMLStreamReader(this.metaDataResource);
            while (reader.hasNext()) {
                int next = reader.next();
                block1 : switch (next) {
                    case 1: {
                        String localName;
                        switch (localName = reader.getLocalName()) {
                            case "IDPSSODescriptor": {
                                domainNames.clear();
                                displayNameEn = null;
                                displayNameNl = null;
                                logoUrl = null;
                                break block1;
                            }
                            case "Scope": {
                                String scopeText = reader.getElementText();
                                if (!StringUtils.hasText((String)scopeText)) break;
                                String domainName = scopeText.trim().replaceAll("\\n\\t ", "").toLowerCase();
                                domainNames.add(domainName);
                                break block1;
                            }
                            case "DisplayName": {
                                String lang = this.getAttributeValue(reader, "lang");
                                String displayName = reader.getElementText();
                                if (!languages.contains(lang)) break;
                                if ("en".equals(lang)) {
                                    displayNameEn = displayName;
                                    break block1;
                                }
                                displayNameNl = displayName;
                                break block1;
                            }
                            case "Logo": {
                                logoUrl = reader.getElementText();
                            }
                        }
                        break;
                    }
                    case 2: {
                        String localName = reader.getLocalName();
                        if (!localName.equals("IDPSSODescriptor")) break;
                        IdentityProvider identityProvider = new IdentityProvider(displayNameEn, displayNameNl, logoUrl);
                        for (String domainName : domainNames) {
                            newIdentityProviderMap.put(domainName, identityProvider);
                        }
                        break;
                    }
                }
            }
            this.identityProviderMap = newIdentityProviderMap;
            LOG.info((Object)String.format("Parsed %s institution domain names from %s in %s ms", this.identityProviderMap.size(), this.metaDataResource.getDescription(), System.currentTimeMillis() - start));
        }
        catch (FileNotFoundException fe) {
            LOG.warn((Object)String.format("Could not read IdP Metadata from %s", this.metaDataResource.getDescription()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in resolveIdpMetaData", (Throwable)e);
        }
    }

    private String getAttributeValue(XMLStreamReader reader, String attributeName) {
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            QName qName = reader.getAttributeName(i);
            if (!qName.getLocalPart().equalsIgnoreCase(attributeName)) continue;
            return reader.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart());
        }
        throw new IllegalArgumentException(String.format("Attribute %s is not present", attributeName));
    }

    public Set<String> getDomainNames() {
        this.lazyLoadCheck();
        return this.identityProviderMap.keySet();
    }

    public Optional<IdentityProvider> getIdentityProvider(String domainName) {
        this.lazyLoadCheck();
        return Optional.ofNullable((IdentityProvider)this.identityProviderMap.get(domainName));
    }

    private void lazyLoadCheck() {
        if (this.identityProviderMap.isEmpty()) {
            this.resolveIdpMetaData();
        }
    }

    private XMLStreamReader getXMLStreamReader(Resource xml) throws IOException, XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory.createXMLStreamReader(xml.getInputStream());
    }
}

