/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.UUID;
import myconext.model.User;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

@Document(collection="user_logins")
public class UserLogin
implements Serializable {
    @Id
    private String id;
    private String uuid;
    private String userId;
    private String userAgent;
    private String forwardedFor;
    private String ipAddress;
    private String ipLocation;

    public UserLogin(User user, Map<String, String> headers) {
        this.userId = user.getId();
        this.uuid = UUID.randomUUID().toString();
        this.userAgent = headers.get("user-agent");
        String forwardedForHeader = headers.get("x-forwarded-for");
        if (StringUtils.hasText((String)forwardedForHeader)) {
            this.forwardedFor = forwardedForHeader.split(",")[0].trim();
            try {
                InetAddress addr = InetAddress.getByName(this.forwardedFor);
                this.ipAddress = addr.getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        } else {
            this.ipAddress = headers.get("ipAddress");
        }
    }

    public void setIpLocation(String ipLocation) {
        this.ipLocation = ipLocation;
    }

    public String getLookupAddress() {
        return StringUtils.hasText((String)this.forwardedFor) ? this.forwardedFor : this.ipAddress;
    }

    public String getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getForwardedFor() {
        return this.forwardedFor;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getIpLocation() {
        return this.ipLocation;
    }

    public UserLogin() {
    }
}

